/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetUserRequest
extends BmcRequest<Void> {
    private String managedDatabaseId;
    private String userName;
    private String opcRequestId;
    private String opcNamedCredentialId;

    public String getManagedDatabaseId() {
        return this.managedDatabaseId;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNamedCredentialId() {
        return this.opcNamedCredentialId;
    }

    public Builder toBuilder() {
        return new Builder().managedDatabaseId(this.managedDatabaseId).userName(this.userName).opcRequestId(this.opcRequestId).opcNamedCredentialId(this.opcNamedCredentialId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",managedDatabaseId=").append(String.valueOf(this.managedDatabaseId));
        sb.append(",userName=").append(String.valueOf(this.userName));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcNamedCredentialId=").append(String.valueOf(this.opcNamedCredentialId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetUserRequest)) {
            return false;
        }
        GetUserRequest other = (GetUserRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.managedDatabaseId, other.managedDatabaseId) && Objects.equals(this.userName, other.userName) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcNamedCredentialId, other.opcNamedCredentialId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.managedDatabaseId == null ? 43 : this.managedDatabaseId.hashCode());
        result = result * 59 + (this.userName == null ? 43 : this.userName.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcNamedCredentialId == null ? 43 : this.opcNamedCredentialId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetUserRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String managedDatabaseId = null;
        private String userName = null;
        private String opcRequestId = null;
        private String opcNamedCredentialId = null;

        public Builder managedDatabaseId(String managedDatabaseId) {
            this.managedDatabaseId = managedDatabaseId;
            return this;
        }

        public Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNamedCredentialId(String opcNamedCredentialId) {
            this.opcNamedCredentialId = opcNamedCredentialId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetUserRequest o) {
            this.managedDatabaseId(o.getManagedDatabaseId());
            this.userName(o.getUserName());
            this.opcRequestId(o.getOpcRequestId());
            this.opcNamedCredentialId(o.getOpcNamedCredentialId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetUserRequest build() {
            GetUserRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetUserRequest buildWithoutInvocationCallback() {
            GetUserRequest request = new GetUserRequest();
            request.managedDatabaseId = this.managedDatabaseId;
            request.userName = this.userName;
            request.opcRequestId = this.opcRequestId;
            request.opcNamedCredentialId = this.opcNamedCredentialId;
            return request;
        }
    }
}

