/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.databasemanagement.model.SortOrders;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListAttentionLogsRequest
extends BmcRequest<Void> {
    private String managedDatabaseId;
    private Date timeGreaterThanOrEqualTo;
    private Date timeLessThanOrEqualTo;
    private UrgencyFilter urgencyFilter;
    private TypeFilter typeFilter;
    private String logSearchText;
    private Boolean isRegularExpression;
    private SortBy sortBy;
    private SortOrders sortOrder;
    private String page;
    private Integer limit;
    private String opcRequestId;
    private String opcNamedCredentialId;

    public String getManagedDatabaseId() {
        return this.managedDatabaseId;
    }

    public Date getTimeGreaterThanOrEqualTo() {
        return this.timeGreaterThanOrEqualTo;
    }

    public Date getTimeLessThanOrEqualTo() {
        return this.timeLessThanOrEqualTo;
    }

    public UrgencyFilter getUrgencyFilter() {
        return this.urgencyFilter;
    }

    public TypeFilter getTypeFilter() {
        return this.typeFilter;
    }

    public String getLogSearchText() {
        return this.logSearchText;
    }

    public Boolean getIsRegularExpression() {
        return this.isRegularExpression;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrders getSortOrder() {
        return this.sortOrder;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNamedCredentialId() {
        return this.opcNamedCredentialId;
    }

    public Builder toBuilder() {
        return new Builder().managedDatabaseId(this.managedDatabaseId).timeGreaterThanOrEqualTo(this.timeGreaterThanOrEqualTo).timeLessThanOrEqualTo(this.timeLessThanOrEqualTo).urgencyFilter(this.urgencyFilter).typeFilter(this.typeFilter).logSearchText(this.logSearchText).isRegularExpression(this.isRegularExpression).sortBy(this.sortBy).sortOrder(this.sortOrder).page(this.page).limit(this.limit).opcRequestId(this.opcRequestId).opcNamedCredentialId(this.opcNamedCredentialId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",managedDatabaseId=").append(String.valueOf(this.managedDatabaseId));
        sb.append(",timeGreaterThanOrEqualTo=").append(String.valueOf(this.timeGreaterThanOrEqualTo));
        sb.append(",timeLessThanOrEqualTo=").append(String.valueOf(this.timeLessThanOrEqualTo));
        sb.append(",urgencyFilter=").append(String.valueOf((Object)this.urgencyFilter));
        sb.append(",typeFilter=").append(String.valueOf((Object)this.typeFilter));
        sb.append(",logSearchText=").append(String.valueOf(this.logSearchText));
        sb.append(",isRegularExpression=").append(String.valueOf(this.isRegularExpression));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcNamedCredentialId=").append(String.valueOf(this.opcNamedCredentialId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListAttentionLogsRequest)) {
            return false;
        }
        ListAttentionLogsRequest other = (ListAttentionLogsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.managedDatabaseId, other.managedDatabaseId) && Objects.equals(this.timeGreaterThanOrEqualTo, other.timeGreaterThanOrEqualTo) && Objects.equals(this.timeLessThanOrEqualTo, other.timeLessThanOrEqualTo) && Objects.equals((Object)this.urgencyFilter, (Object)other.urgencyFilter) && Objects.equals((Object)this.typeFilter, (Object)other.typeFilter) && Objects.equals(this.logSearchText, other.logSearchText) && Objects.equals(this.isRegularExpression, other.isRegularExpression) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcNamedCredentialId, other.opcNamedCredentialId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.managedDatabaseId == null ? 43 : this.managedDatabaseId.hashCode());
        result = result * 59 + (this.timeGreaterThanOrEqualTo == null ? 43 : this.timeGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeLessThanOrEqualTo == null ? 43 : this.timeLessThanOrEqualTo.hashCode());
        result = result * 59 + (this.urgencyFilter == null ? 43 : this.urgencyFilter.hashCode());
        result = result * 59 + (this.typeFilter == null ? 43 : this.typeFilter.hashCode());
        result = result * 59 + (this.logSearchText == null ? 43 : this.logSearchText.hashCode());
        result = result * 59 + (this.isRegularExpression == null ? 43 : this.isRegularExpression.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcNamedCredentialId == null ? 43 : this.opcNamedCredentialId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListAttentionLogsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String managedDatabaseId = null;
        private Date timeGreaterThanOrEqualTo = null;
        private Date timeLessThanOrEqualTo = null;
        private UrgencyFilter urgencyFilter = null;
        private TypeFilter typeFilter = null;
        private String logSearchText = null;
        private Boolean isRegularExpression = null;
        private SortBy sortBy = null;
        private SortOrders sortOrder = null;
        private String page = null;
        private Integer limit = null;
        private String opcRequestId = null;
        private String opcNamedCredentialId = null;

        public Builder managedDatabaseId(String managedDatabaseId) {
            this.managedDatabaseId = managedDatabaseId;
            return this;
        }

        public Builder timeGreaterThanOrEqualTo(Date timeGreaterThanOrEqualTo) {
            this.timeGreaterThanOrEqualTo = timeGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeLessThanOrEqualTo(Date timeLessThanOrEqualTo) {
            this.timeLessThanOrEqualTo = timeLessThanOrEqualTo;
            return this;
        }

        public Builder urgencyFilter(UrgencyFilter urgencyFilter) {
            this.urgencyFilter = urgencyFilter;
            return this;
        }

        public Builder typeFilter(TypeFilter typeFilter) {
            this.typeFilter = typeFilter;
            return this;
        }

        public Builder logSearchText(String logSearchText) {
            this.logSearchText = logSearchText;
            return this;
        }

        public Builder isRegularExpression(Boolean isRegularExpression) {
            this.isRegularExpression = isRegularExpression;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrders sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNamedCredentialId(String opcNamedCredentialId) {
            this.opcNamedCredentialId = opcNamedCredentialId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListAttentionLogsRequest o) {
            this.managedDatabaseId(o.getManagedDatabaseId());
            this.timeGreaterThanOrEqualTo(o.getTimeGreaterThanOrEqualTo());
            this.timeLessThanOrEqualTo(o.getTimeLessThanOrEqualTo());
            this.urgencyFilter(o.getUrgencyFilter());
            this.typeFilter(o.getTypeFilter());
            this.logSearchText(o.getLogSearchText());
            this.isRegularExpression(o.getIsRegularExpression());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.opcRequestId(o.getOpcRequestId());
            this.opcNamedCredentialId(o.getOpcNamedCredentialId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListAttentionLogsRequest build() {
            ListAttentionLogsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListAttentionLogsRequest buildWithoutInvocationCallback() {
            ListAttentionLogsRequest request = new ListAttentionLogsRequest();
            request.managedDatabaseId = this.managedDatabaseId;
            request.timeGreaterThanOrEqualTo = this.timeGreaterThanOrEqualTo;
            request.timeLessThanOrEqualTo = this.timeLessThanOrEqualTo;
            request.urgencyFilter = this.urgencyFilter;
            request.typeFilter = this.typeFilter;
            request.logSearchText = this.logSearchText;
            request.isRegularExpression = this.isRegularExpression;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.page = this.page;
            request.limit = this.limit;
            request.opcRequestId = this.opcRequestId;
            request.opcNamedCredentialId = this.opcNamedCredentialId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Urgency("URGENCY"),
        Type("TYPE"),
        Message("MESSAGE"),
        Timestamp("TIMESTAMP"),
        Scope("SCOPE"),
        TargetUser("TARGET_USER");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum TypeFilter implements BmcEnum
    {
        Unknown("UNKNOWN"),
        IncidentError("INCIDENT_ERROR"),
        Error("ERROR"),
        Warning("WARNING"),
        Notification("NOTIFICATION"),
        Trace("TRACE"),
        All("ALL");

        private final String value;
        private static Map<String, TypeFilter> map;

        private TypeFilter(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TypeFilter create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid TypeFilter: " + key);
        }

        static {
            map = new HashMap<String, TypeFilter>();
            for (TypeFilter v : TypeFilter.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum UrgencyFilter implements BmcEnum
    {
        Immediate("IMMEDIATE"),
        Soon("SOON"),
        Deferrable("DEFERRABLE"),
        Info("INFO"),
        All("ALL");

        private final String value;
        private static Map<String, UrgencyFilter> map;

        private UrgencyFilter(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static UrgencyFilter create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid UrgencyFilter: " + key);
        }

        static {
            map = new HashMap<String, UrgencyFilter>();
            for (UrgencyFilter v : UrgencyFilter.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

