/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.databasemanagement.model.OptimizerStatisticsTaskFilterTypes;
import com.oracle.bmc.databasemanagement.model.SortOrders;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListOptimizerStatisticsCollectionOperationsRequest
extends BmcRequest<Void> {
    private String managedDatabaseId;
    private String startTimeGreaterThanOrEqualTo;
    private String endTimeLessThanOrEqualTo;
    private OptimizerStatisticsTaskFilterTypes taskType;
    private Integer limit;
    private String page;
    private String filterBy;
    private SortBy sortBy;
    private SortOrders sortOrder;
    private String opcRequestId;
    private String opcNamedCredentialId;

    public String getManagedDatabaseId() {
        return this.managedDatabaseId;
    }

    public String getStartTimeGreaterThanOrEqualTo() {
        return this.startTimeGreaterThanOrEqualTo;
    }

    public String getEndTimeLessThanOrEqualTo() {
        return this.endTimeLessThanOrEqualTo;
    }

    public OptimizerStatisticsTaskFilterTypes getTaskType() {
        return this.taskType;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getFilterBy() {
        return this.filterBy;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrders getSortOrder() {
        return this.sortOrder;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNamedCredentialId() {
        return this.opcNamedCredentialId;
    }

    public Builder toBuilder() {
        return new Builder().managedDatabaseId(this.managedDatabaseId).startTimeGreaterThanOrEqualTo(this.startTimeGreaterThanOrEqualTo).endTimeLessThanOrEqualTo(this.endTimeLessThanOrEqualTo).taskType(this.taskType).limit(this.limit).page(this.page).filterBy(this.filterBy).sortBy(this.sortBy).sortOrder(this.sortOrder).opcRequestId(this.opcRequestId).opcNamedCredentialId(this.opcNamedCredentialId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",managedDatabaseId=").append(String.valueOf(this.managedDatabaseId));
        sb.append(",startTimeGreaterThanOrEqualTo=").append(String.valueOf(this.startTimeGreaterThanOrEqualTo));
        sb.append(",endTimeLessThanOrEqualTo=").append(String.valueOf(this.endTimeLessThanOrEqualTo));
        sb.append(",taskType=").append(String.valueOf((Object)this.taskType));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",filterBy=").append(String.valueOf(this.filterBy));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcNamedCredentialId=").append(String.valueOf(this.opcNamedCredentialId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListOptimizerStatisticsCollectionOperationsRequest)) {
            return false;
        }
        ListOptimizerStatisticsCollectionOperationsRequest other = (ListOptimizerStatisticsCollectionOperationsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.managedDatabaseId, other.managedDatabaseId) && Objects.equals(this.startTimeGreaterThanOrEqualTo, other.startTimeGreaterThanOrEqualTo) && Objects.equals(this.endTimeLessThanOrEqualTo, other.endTimeLessThanOrEqualTo) && Objects.equals((Object)this.taskType, (Object)other.taskType) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.filterBy, other.filterBy) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcNamedCredentialId, other.opcNamedCredentialId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.managedDatabaseId == null ? 43 : this.managedDatabaseId.hashCode());
        result = result * 59 + (this.startTimeGreaterThanOrEqualTo == null ? 43 : this.startTimeGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.endTimeLessThanOrEqualTo == null ? 43 : this.endTimeLessThanOrEqualTo.hashCode());
        result = result * 59 + (this.taskType == null ? 43 : this.taskType.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.filterBy == null ? 43 : this.filterBy.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcNamedCredentialId == null ? 43 : this.opcNamedCredentialId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListOptimizerStatisticsCollectionOperationsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String managedDatabaseId = null;
        private String startTimeGreaterThanOrEqualTo = null;
        private String endTimeLessThanOrEqualTo = null;
        private OptimizerStatisticsTaskFilterTypes taskType = null;
        private Integer limit = null;
        private String page = null;
        private String filterBy = null;
        private SortBy sortBy = null;
        private SortOrders sortOrder = null;
        private String opcRequestId = null;
        private String opcNamedCredentialId = null;

        public Builder managedDatabaseId(String managedDatabaseId) {
            this.managedDatabaseId = managedDatabaseId;
            return this;
        }

        public Builder startTimeGreaterThanOrEqualTo(String startTimeGreaterThanOrEqualTo) {
            this.startTimeGreaterThanOrEqualTo = startTimeGreaterThanOrEqualTo;
            return this;
        }

        public Builder endTimeLessThanOrEqualTo(String endTimeLessThanOrEqualTo) {
            this.endTimeLessThanOrEqualTo = endTimeLessThanOrEqualTo;
            return this;
        }

        public Builder taskType(OptimizerStatisticsTaskFilterTypes taskType) {
            this.taskType = taskType;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder filterBy(String filterBy) {
            this.filterBy = filterBy;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrders sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNamedCredentialId(String opcNamedCredentialId) {
            this.opcNamedCredentialId = opcNamedCredentialId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListOptimizerStatisticsCollectionOperationsRequest o) {
            this.managedDatabaseId(o.getManagedDatabaseId());
            this.startTimeGreaterThanOrEqualTo(o.getStartTimeGreaterThanOrEqualTo());
            this.endTimeLessThanOrEqualTo(o.getEndTimeLessThanOrEqualTo());
            this.taskType(o.getTaskType());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.filterBy(o.getFilterBy());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.opcRequestId(o.getOpcRequestId());
            this.opcNamedCredentialId(o.getOpcNamedCredentialId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListOptimizerStatisticsCollectionOperationsRequest build() {
            ListOptimizerStatisticsCollectionOperationsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListOptimizerStatisticsCollectionOperationsRequest buildWithoutInvocationCallback() {
            ListOptimizerStatisticsCollectionOperationsRequest request = new ListOptimizerStatisticsCollectionOperationsRequest();
            request.managedDatabaseId = this.managedDatabaseId;
            request.startTimeGreaterThanOrEqualTo = this.startTimeGreaterThanOrEqualTo;
            request.endTimeLessThanOrEqualTo = this.endTimeLessThanOrEqualTo;
            request.taskType = this.taskType;
            request.limit = this.limit;
            request.page = this.page;
            request.filterBy = this.filterBy;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.opcRequestId = this.opcRequestId;
            request.opcNamedCredentialId = this.opcNamedCredentialId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        StartTime("START_TIME"),
        EndTime("END_TIME"),
        Status("STATUS");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

