/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.databasemanagement.model.RunHistoricAddmDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class RunHistoricAddmRequest
extends BmcRequest<RunHistoricAddmDetails> {
    private String managedDatabaseId;
    private RunHistoricAddmDetails runHistoricAddmDetails;
    private String opcRetryToken;
    private String opcRequestId;
    private String opcNamedCredentialId;

    public String getManagedDatabaseId() {
        return this.managedDatabaseId;
    }

    public RunHistoricAddmDetails getRunHistoricAddmDetails() {
        return this.runHistoricAddmDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNamedCredentialId() {
        return this.opcNamedCredentialId;
    }

    @InternalSdk
    public RunHistoricAddmDetails getBody$() {
        return this.runHistoricAddmDetails;
    }

    public Builder toBuilder() {
        return new Builder().managedDatabaseId(this.managedDatabaseId).runHistoricAddmDetails(this.runHistoricAddmDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId).opcNamedCredentialId(this.opcNamedCredentialId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",managedDatabaseId=").append(String.valueOf(this.managedDatabaseId));
        sb.append(",runHistoricAddmDetails=").append(String.valueOf((Object)this.runHistoricAddmDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcNamedCredentialId=").append(String.valueOf(this.opcNamedCredentialId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RunHistoricAddmRequest)) {
            return false;
        }
        RunHistoricAddmRequest other = (RunHistoricAddmRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.managedDatabaseId, other.managedDatabaseId) && Objects.equals((Object)this.runHistoricAddmDetails, (Object)other.runHistoricAddmDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcNamedCredentialId, other.opcNamedCredentialId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.managedDatabaseId == null ? 43 : this.managedDatabaseId.hashCode());
        result = result * 59 + (this.runHistoricAddmDetails == null ? 43 : this.runHistoricAddmDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcNamedCredentialId == null ? 43 : this.opcNamedCredentialId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<RunHistoricAddmRequest, RunHistoricAddmDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String managedDatabaseId = null;
        private RunHistoricAddmDetails runHistoricAddmDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;
        private String opcNamedCredentialId = null;

        public Builder managedDatabaseId(String managedDatabaseId) {
            this.managedDatabaseId = managedDatabaseId;
            return this;
        }

        public Builder runHistoricAddmDetails(RunHistoricAddmDetails runHistoricAddmDetails) {
            this.runHistoricAddmDetails = runHistoricAddmDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNamedCredentialId(String opcNamedCredentialId) {
            this.opcNamedCredentialId = opcNamedCredentialId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RunHistoricAddmRequest o) {
            this.managedDatabaseId(o.getManagedDatabaseId());
            this.runHistoricAddmDetails(o.getRunHistoricAddmDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.opcNamedCredentialId(o.getOpcNamedCredentialId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RunHistoricAddmRequest build() {
            RunHistoricAddmRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(RunHistoricAddmDetails body) {
            this.runHistoricAddmDetails(body);
            return this;
        }

        public RunHistoricAddmRequest buildWithoutInvocationCallback() {
            RunHistoricAddmRequest request = new RunHistoricAddmRequest();
            request.managedDatabaseId = this.managedDatabaseId;
            request.runHistoricAddmDetails = this.runHistoricAddmDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            request.opcNamedCredentialId = this.opcNamedCredentialId;
            return request;
        }
    }
}

