/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement;

import com.oracle.bmc.databasemanagement.ManagedMySqlDatabases;
import com.oracle.bmc.databasemanagement.model.ManagedMySqlDatabaseSummary;
import com.oracle.bmc.databasemanagement.model.MySqlConfigurationDataSummary;
import com.oracle.bmc.databasemanagement.model.MySqlDataSummary;
import com.oracle.bmc.databasemanagement.requests.ListManagedMySqlDatabaseConfigurationDataRequest;
import com.oracle.bmc.databasemanagement.requests.ListManagedMySqlDatabaseSqlDataRequest;
import com.oracle.bmc.databasemanagement.requests.ListManagedMySqlDatabasesRequest;
import com.oracle.bmc.databasemanagement.responses.ListManagedMySqlDatabaseConfigurationDataResponse;
import com.oracle.bmc.databasemanagement.responses.ListManagedMySqlDatabaseSqlDataResponse;
import com.oracle.bmc.databasemanagement.responses.ListManagedMySqlDatabasesResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class ManagedMySqlDatabasesPaginators {
    private final ManagedMySqlDatabases client;

    public ManagedMySqlDatabasesPaginators(ManagedMySqlDatabases client) {
        this.client = client;
    }

    public Iterable<ListManagedMySqlDatabaseConfigurationDataResponse> listManagedMySqlDatabaseConfigurationDataResponseIterator(final ListManagedMySqlDatabaseConfigurationDataRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListManagedMySqlDatabaseConfigurationDataRequest.Builder>(){

            @Override
            public ListManagedMySqlDatabaseConfigurationDataRequest.Builder get() {
                return ListManagedMySqlDatabaseConfigurationDataRequest.builder().copy(request);
            }
        }, (Function)new Function<ListManagedMySqlDatabaseConfigurationDataResponse, String>(){

            @Override
            public String apply(ListManagedMySqlDatabaseConfigurationDataResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListManagedMySqlDatabaseConfigurationDataRequest.Builder>, ListManagedMySqlDatabaseConfigurationDataRequest>(){

            @Override
            public ListManagedMySqlDatabaseConfigurationDataRequest apply(RequestBuilderAndToken<ListManagedMySqlDatabaseConfigurationDataRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListManagedMySqlDatabaseConfigurationDataRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListManagedMySqlDatabaseConfigurationDataRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListManagedMySqlDatabaseConfigurationDataRequest, ListManagedMySqlDatabaseConfigurationDataResponse>(){

            @Override
            public ListManagedMySqlDatabaseConfigurationDataResponse apply(ListManagedMySqlDatabaseConfigurationDataRequest request) {
                return ManagedMySqlDatabasesPaginators.this.client.listManagedMySqlDatabaseConfigurationData(request);
            }
        });
    }

    public Iterable<MySqlConfigurationDataSummary> listManagedMySqlDatabaseConfigurationDataRecordIterator(final ListManagedMySqlDatabaseConfigurationDataRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListManagedMySqlDatabaseConfigurationDataRequest.Builder>(){

            @Override
            public ListManagedMySqlDatabaseConfigurationDataRequest.Builder get() {
                return ListManagedMySqlDatabaseConfigurationDataRequest.builder().copy(request);
            }
        }, (Function)new Function<ListManagedMySqlDatabaseConfigurationDataResponse, String>(){

            @Override
            public String apply(ListManagedMySqlDatabaseConfigurationDataResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListManagedMySqlDatabaseConfigurationDataRequest.Builder>, ListManagedMySqlDatabaseConfigurationDataRequest>(){

            @Override
            public ListManagedMySqlDatabaseConfigurationDataRequest apply(RequestBuilderAndToken<ListManagedMySqlDatabaseConfigurationDataRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListManagedMySqlDatabaseConfigurationDataRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListManagedMySqlDatabaseConfigurationDataRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListManagedMySqlDatabaseConfigurationDataRequest, ListManagedMySqlDatabaseConfigurationDataResponse>(){

            @Override
            public ListManagedMySqlDatabaseConfigurationDataResponse apply(ListManagedMySqlDatabaseConfigurationDataRequest request) {
                return ManagedMySqlDatabasesPaginators.this.client.listManagedMySqlDatabaseConfigurationData(request);
            }
        }, (Function)new Function<ListManagedMySqlDatabaseConfigurationDataResponse, List<MySqlConfigurationDataSummary>>(){

            @Override
            public List<MySqlConfigurationDataSummary> apply(ListManagedMySqlDatabaseConfigurationDataResponse response) {
                return response.getMySqlConfigurationDataCollection().getItems();
            }
        });
    }

    public Iterable<ListManagedMySqlDatabaseSqlDataResponse> listManagedMySqlDatabaseSqlDataResponseIterator(final ListManagedMySqlDatabaseSqlDataRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListManagedMySqlDatabaseSqlDataRequest.Builder>(){

            @Override
            public ListManagedMySqlDatabaseSqlDataRequest.Builder get() {
                return ListManagedMySqlDatabaseSqlDataRequest.builder().copy(request);
            }
        }, (Function)new Function<ListManagedMySqlDatabaseSqlDataResponse, String>(){

            @Override
            public String apply(ListManagedMySqlDatabaseSqlDataResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListManagedMySqlDatabaseSqlDataRequest.Builder>, ListManagedMySqlDatabaseSqlDataRequest>(){

            @Override
            public ListManagedMySqlDatabaseSqlDataRequest apply(RequestBuilderAndToken<ListManagedMySqlDatabaseSqlDataRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListManagedMySqlDatabaseSqlDataRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListManagedMySqlDatabaseSqlDataRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListManagedMySqlDatabaseSqlDataRequest, ListManagedMySqlDatabaseSqlDataResponse>(){

            @Override
            public ListManagedMySqlDatabaseSqlDataResponse apply(ListManagedMySqlDatabaseSqlDataRequest request) {
                return ManagedMySqlDatabasesPaginators.this.client.listManagedMySqlDatabaseSqlData(request);
            }
        });
    }

    public Iterable<MySqlDataSummary> listManagedMySqlDatabaseSqlDataRecordIterator(final ListManagedMySqlDatabaseSqlDataRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListManagedMySqlDatabaseSqlDataRequest.Builder>(){

            @Override
            public ListManagedMySqlDatabaseSqlDataRequest.Builder get() {
                return ListManagedMySqlDatabaseSqlDataRequest.builder().copy(request);
            }
        }, (Function)new Function<ListManagedMySqlDatabaseSqlDataResponse, String>(){

            @Override
            public String apply(ListManagedMySqlDatabaseSqlDataResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListManagedMySqlDatabaseSqlDataRequest.Builder>, ListManagedMySqlDatabaseSqlDataRequest>(){

            @Override
            public ListManagedMySqlDatabaseSqlDataRequest apply(RequestBuilderAndToken<ListManagedMySqlDatabaseSqlDataRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListManagedMySqlDatabaseSqlDataRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListManagedMySqlDatabaseSqlDataRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListManagedMySqlDatabaseSqlDataRequest, ListManagedMySqlDatabaseSqlDataResponse>(){

            @Override
            public ListManagedMySqlDatabaseSqlDataResponse apply(ListManagedMySqlDatabaseSqlDataRequest request) {
                return ManagedMySqlDatabasesPaginators.this.client.listManagedMySqlDatabaseSqlData(request);
            }
        }, (Function)new Function<ListManagedMySqlDatabaseSqlDataResponse, List<MySqlDataSummary>>(){

            @Override
            public List<MySqlDataSummary> apply(ListManagedMySqlDatabaseSqlDataResponse response) {
                return response.getMySqlDataCollection().getItems();
            }
        });
    }

    public Iterable<ListManagedMySqlDatabasesResponse> listManagedMySqlDatabasesResponseIterator(final ListManagedMySqlDatabasesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListManagedMySqlDatabasesRequest.Builder>(){

            @Override
            public ListManagedMySqlDatabasesRequest.Builder get() {
                return ListManagedMySqlDatabasesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListManagedMySqlDatabasesResponse, String>(){

            @Override
            public String apply(ListManagedMySqlDatabasesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListManagedMySqlDatabasesRequest.Builder>, ListManagedMySqlDatabasesRequest>(){

            @Override
            public ListManagedMySqlDatabasesRequest apply(RequestBuilderAndToken<ListManagedMySqlDatabasesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListManagedMySqlDatabasesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListManagedMySqlDatabasesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListManagedMySqlDatabasesRequest, ListManagedMySqlDatabasesResponse>(){

            @Override
            public ListManagedMySqlDatabasesResponse apply(ListManagedMySqlDatabasesRequest request) {
                return ManagedMySqlDatabasesPaginators.this.client.listManagedMySqlDatabases(request);
            }
        });
    }

    public Iterable<ManagedMySqlDatabaseSummary> listManagedMySqlDatabasesRecordIterator(final ListManagedMySqlDatabasesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListManagedMySqlDatabasesRequest.Builder>(){

            @Override
            public ListManagedMySqlDatabasesRequest.Builder get() {
                return ListManagedMySqlDatabasesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListManagedMySqlDatabasesResponse, String>(){

            @Override
            public String apply(ListManagedMySqlDatabasesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListManagedMySqlDatabasesRequest.Builder>, ListManagedMySqlDatabasesRequest>(){

            @Override
            public ListManagedMySqlDatabasesRequest apply(RequestBuilderAndToken<ListManagedMySqlDatabasesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListManagedMySqlDatabasesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListManagedMySqlDatabasesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListManagedMySqlDatabasesRequest, ListManagedMySqlDatabasesResponse>(){

            @Override
            public ListManagedMySqlDatabasesResponse apply(ListManagedMySqlDatabasesRequest request) {
                return ManagedMySqlDatabasesPaginators.this.client.listManagedMySqlDatabases(request);
            }
        }, (Function)new Function<ListManagedMySqlDatabasesResponse, List<ManagedMySqlDatabaseSummary>>(){

            @Override
            public List<ManagedMySqlDatabaseSummary> apply(ListManagedMySqlDatabasesResponse response) {
                return response.getManagedMySqlDatabaseCollection().getItems();
            }
        });
    }
}

