/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.DatabaseCredentialDetails;
import com.oracle.bmc.databasemanagement.model.TablespaceAdminCredentialDetails;
import com.oracle.bmc.databasemanagement.model.TablespaceStorageSize;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateTablespaceDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="credentialDetails")
    private final TablespaceAdminCredentialDetails credentialDetails;
    @JsonProperty(value="databaseCredential")
    private final DatabaseCredentialDetails databaseCredential;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="type")
    private final Type type;
    @JsonProperty(value="isBigfile")
    private final Boolean isBigfile;
    @JsonProperty(value="dataFiles")
    private final List<String> dataFiles;
    @JsonProperty(value="fileCount")
    private final Integer fileCount;
    @JsonProperty(value="fileSize")
    private final TablespaceStorageSize fileSize;
    @JsonProperty(value="isReusable")
    private final Boolean isReusable;
    @JsonProperty(value="isAutoExtensible")
    private final Boolean isAutoExtensible;
    @JsonProperty(value="autoExtendNextSize")
    private final TablespaceStorageSize autoExtendNextSize;
    @JsonProperty(value="autoExtendMaxSize")
    private final TablespaceStorageSize autoExtendMaxSize;
    @JsonProperty(value="isMaxSizeUnlimited")
    private final Boolean isMaxSizeUnlimited;
    @JsonProperty(value="blockSizeInKilobytes")
    private final Integer blockSizeInKilobytes;
    @JsonProperty(value="isEncrypted")
    private final Boolean isEncrypted;
    @JsonProperty(value="encryptionAlgorithm")
    private final String encryptionAlgorithm;
    @JsonProperty(value="defaultCompress")
    private final DefaultCompress defaultCompress;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="extentManagement")
    private final ExtentManagement extentManagement;
    @JsonProperty(value="extentUniformSize")
    private final TablespaceStorageSize extentUniformSize;
    @JsonProperty(value="segmentManagement")
    private final SegmentManagement segmentManagement;
    @JsonProperty(value="isDefault")
    private final Boolean isDefault;

    @Deprecated
    @ConstructorProperties(value={"credentialDetails", "databaseCredential", "name", "type", "isBigfile", "dataFiles", "fileCount", "fileSize", "isReusable", "isAutoExtensible", "autoExtendNextSize", "autoExtendMaxSize", "isMaxSizeUnlimited", "blockSizeInKilobytes", "isEncrypted", "encryptionAlgorithm", "defaultCompress", "status", "extentManagement", "extentUniformSize", "segmentManagement", "isDefault"})
    public CreateTablespaceDetails(TablespaceAdminCredentialDetails credentialDetails, DatabaseCredentialDetails databaseCredential, String name, Type type, Boolean isBigfile, List<String> dataFiles, Integer fileCount, TablespaceStorageSize fileSize, Boolean isReusable, Boolean isAutoExtensible, TablespaceStorageSize autoExtendNextSize, TablespaceStorageSize autoExtendMaxSize, Boolean isMaxSizeUnlimited, Integer blockSizeInKilobytes, Boolean isEncrypted, String encryptionAlgorithm, DefaultCompress defaultCompress, Status status, ExtentManagement extentManagement, TablespaceStorageSize extentUniformSize, SegmentManagement segmentManagement, Boolean isDefault) {
        this.credentialDetails = credentialDetails;
        this.databaseCredential = databaseCredential;
        this.name = name;
        this.type = type;
        this.isBigfile = isBigfile;
        this.dataFiles = dataFiles;
        this.fileCount = fileCount;
        this.fileSize = fileSize;
        this.isReusable = isReusable;
        this.isAutoExtensible = isAutoExtensible;
        this.autoExtendNextSize = autoExtendNextSize;
        this.autoExtendMaxSize = autoExtendMaxSize;
        this.isMaxSizeUnlimited = isMaxSizeUnlimited;
        this.blockSizeInKilobytes = blockSizeInKilobytes;
        this.isEncrypted = isEncrypted;
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.defaultCompress = defaultCompress;
        this.status = status;
        this.extentManagement = extentManagement;
        this.extentUniformSize = extentUniformSize;
        this.segmentManagement = segmentManagement;
        this.isDefault = isDefault;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public TablespaceAdminCredentialDetails getCredentialDetails() {
        return this.credentialDetails;
    }

    public DatabaseCredentialDetails getDatabaseCredential() {
        return this.databaseCredential;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public Boolean getIsBigfile() {
        return this.isBigfile;
    }

    public List<String> getDataFiles() {
        return this.dataFiles;
    }

    public Integer getFileCount() {
        return this.fileCount;
    }

    public TablespaceStorageSize getFileSize() {
        return this.fileSize;
    }

    public Boolean getIsReusable() {
        return this.isReusable;
    }

    public Boolean getIsAutoExtensible() {
        return this.isAutoExtensible;
    }

    public TablespaceStorageSize getAutoExtendNextSize() {
        return this.autoExtendNextSize;
    }

    public TablespaceStorageSize getAutoExtendMaxSize() {
        return this.autoExtendMaxSize;
    }

    public Boolean getIsMaxSizeUnlimited() {
        return this.isMaxSizeUnlimited;
    }

    public Integer getBlockSizeInKilobytes() {
        return this.blockSizeInKilobytes;
    }

    public Boolean getIsEncrypted() {
        return this.isEncrypted;
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public DefaultCompress getDefaultCompress() {
        return this.defaultCompress;
    }

    public Status getStatus() {
        return this.status;
    }

    public ExtentManagement getExtentManagement() {
        return this.extentManagement;
    }

    public TablespaceStorageSize getExtentUniformSize() {
        return this.extentUniformSize;
    }

    public SegmentManagement getSegmentManagement() {
        return this.segmentManagement;
    }

    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateTablespaceDetails(");
        sb.append("super=").append(super.toString());
        sb.append("credentialDetails=").append(String.valueOf((Object)this.credentialDetails));
        sb.append(", databaseCredential=").append(String.valueOf((Object)this.databaseCredential));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", type=").append(String.valueOf((Object)this.type));
        sb.append(", isBigfile=").append(String.valueOf(this.isBigfile));
        sb.append(", dataFiles=").append(String.valueOf(this.dataFiles));
        sb.append(", fileCount=").append(String.valueOf(this.fileCount));
        sb.append(", fileSize=").append(String.valueOf((Object)this.fileSize));
        sb.append(", isReusable=").append(String.valueOf(this.isReusable));
        sb.append(", isAutoExtensible=").append(String.valueOf(this.isAutoExtensible));
        sb.append(", autoExtendNextSize=").append(String.valueOf((Object)this.autoExtendNextSize));
        sb.append(", autoExtendMaxSize=").append(String.valueOf((Object)this.autoExtendMaxSize));
        sb.append(", isMaxSizeUnlimited=").append(String.valueOf(this.isMaxSizeUnlimited));
        sb.append(", blockSizeInKilobytes=").append(String.valueOf(this.blockSizeInKilobytes));
        sb.append(", isEncrypted=").append(String.valueOf(this.isEncrypted));
        sb.append(", encryptionAlgorithm=").append(String.valueOf(this.encryptionAlgorithm));
        sb.append(", defaultCompress=").append(String.valueOf((Object)this.defaultCompress));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", extentManagement=").append(String.valueOf((Object)this.extentManagement));
        sb.append(", extentUniformSize=").append(String.valueOf((Object)this.extentUniformSize));
        sb.append(", segmentManagement=").append(String.valueOf((Object)this.segmentManagement));
        sb.append(", isDefault=").append(String.valueOf(this.isDefault));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateTablespaceDetails)) {
            return false;
        }
        CreateTablespaceDetails other = (CreateTablespaceDetails)((Object)o);
        return Objects.equals((Object)this.credentialDetails, (Object)other.credentialDetails) && Objects.equals((Object)this.databaseCredential, (Object)other.databaseCredential) && Objects.equals(this.name, other.name) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.isBigfile, other.isBigfile) && Objects.equals(this.dataFiles, other.dataFiles) && Objects.equals(this.fileCount, other.fileCount) && Objects.equals((Object)this.fileSize, (Object)other.fileSize) && Objects.equals(this.isReusable, other.isReusable) && Objects.equals(this.isAutoExtensible, other.isAutoExtensible) && Objects.equals((Object)this.autoExtendNextSize, (Object)other.autoExtendNextSize) && Objects.equals((Object)this.autoExtendMaxSize, (Object)other.autoExtendMaxSize) && Objects.equals(this.isMaxSizeUnlimited, other.isMaxSizeUnlimited) && Objects.equals(this.blockSizeInKilobytes, other.blockSizeInKilobytes) && Objects.equals(this.isEncrypted, other.isEncrypted) && Objects.equals(this.encryptionAlgorithm, other.encryptionAlgorithm) && Objects.equals((Object)this.defaultCompress, (Object)other.defaultCompress) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals((Object)this.extentManagement, (Object)other.extentManagement) && Objects.equals((Object)this.extentUniformSize, (Object)other.extentUniformSize) && Objects.equals((Object)this.segmentManagement, (Object)other.segmentManagement) && Objects.equals(this.isDefault, other.isDefault) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.credentialDetails == null ? 43 : this.credentialDetails.hashCode());
        result = result * 59 + (this.databaseCredential == null ? 43 : this.databaseCredential.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.isBigfile == null ? 43 : this.isBigfile.hashCode());
        result = result * 59 + (this.dataFiles == null ? 43 : this.dataFiles.hashCode());
        result = result * 59 + (this.fileCount == null ? 43 : this.fileCount.hashCode());
        result = result * 59 + (this.fileSize == null ? 43 : this.fileSize.hashCode());
        result = result * 59 + (this.isReusable == null ? 43 : this.isReusable.hashCode());
        result = result * 59 + (this.isAutoExtensible == null ? 43 : this.isAutoExtensible.hashCode());
        result = result * 59 + (this.autoExtendNextSize == null ? 43 : this.autoExtendNextSize.hashCode());
        result = result * 59 + (this.autoExtendMaxSize == null ? 43 : this.autoExtendMaxSize.hashCode());
        result = result * 59 + (this.isMaxSizeUnlimited == null ? 43 : this.isMaxSizeUnlimited.hashCode());
        result = result * 59 + (this.blockSizeInKilobytes == null ? 43 : this.blockSizeInKilobytes.hashCode());
        result = result * 59 + (this.isEncrypted == null ? 43 : this.isEncrypted.hashCode());
        result = result * 59 + (this.encryptionAlgorithm == null ? 43 : this.encryptionAlgorithm.hashCode());
        result = result * 59 + (this.defaultCompress == null ? 43 : this.defaultCompress.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.extentManagement == null ? 43 : this.extentManagement.hashCode());
        result = result * 59 + (this.extentUniformSize == null ? 43 : this.extentUniformSize.hashCode());
        result = result * 59 + (this.segmentManagement == null ? 43 : this.segmentManagement.hashCode());
        result = result * 59 + (this.isDefault == null ? 43 : this.isDefault.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum SegmentManagement implements BmcEnum
    {
        Auto("AUTO"),
        Manual("MANUAL");

        private final String value;
        private static Map<String, SegmentManagement> map;

        private SegmentManagement(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SegmentManagement create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SegmentManagement: " + key);
        }

        static {
            map = new HashMap<String, SegmentManagement>();
            for (SegmentManagement v : SegmentManagement.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ExtentManagement implements BmcEnum
    {
        Autoallocate("AUTOALLOCATE"),
        Uniform("UNIFORM");

        private final String value;
        private static Map<String, ExtentManagement> map;

        private ExtentManagement(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ExtentManagement create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ExtentManagement: " + key);
        }

        static {
            map = new HashMap<String, ExtentManagement>();
            for (ExtentManagement v : ExtentManagement.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Status implements BmcEnum
    {
        ReadOnly("READ_ONLY"),
        ReadWrite("READ_WRITE");

        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Status: " + key);
        }

        static {
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum DefaultCompress implements BmcEnum
    {
        NoCompress("NO_COMPRESS"),
        BasicCompress("BASIC_COMPRESS");

        private final String value;
        private static Map<String, DefaultCompress> map;

        private DefaultCompress(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DefaultCompress create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid DefaultCompress: " + key);
        }

        static {
            map = new HashMap<String, DefaultCompress>();
            for (DefaultCompress v : DefaultCompress.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Type implements BmcEnum
    {
        Permanent("PERMANENT"),
        Temporary("TEMPORARY");

        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Type: " + key);
        }

        static {
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="credentialDetails")
        private TablespaceAdminCredentialDetails credentialDetails;
        @JsonProperty(value="databaseCredential")
        private DatabaseCredentialDetails databaseCredential;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="type")
        private Type type;
        @JsonProperty(value="isBigfile")
        private Boolean isBigfile;
        @JsonProperty(value="dataFiles")
        private List<String> dataFiles;
        @JsonProperty(value="fileCount")
        private Integer fileCount;
        @JsonProperty(value="fileSize")
        private TablespaceStorageSize fileSize;
        @JsonProperty(value="isReusable")
        private Boolean isReusable;
        @JsonProperty(value="isAutoExtensible")
        private Boolean isAutoExtensible;
        @JsonProperty(value="autoExtendNextSize")
        private TablespaceStorageSize autoExtendNextSize;
        @JsonProperty(value="autoExtendMaxSize")
        private TablespaceStorageSize autoExtendMaxSize;
        @JsonProperty(value="isMaxSizeUnlimited")
        private Boolean isMaxSizeUnlimited;
        @JsonProperty(value="blockSizeInKilobytes")
        private Integer blockSizeInKilobytes;
        @JsonProperty(value="isEncrypted")
        private Boolean isEncrypted;
        @JsonProperty(value="encryptionAlgorithm")
        private String encryptionAlgorithm;
        @JsonProperty(value="defaultCompress")
        private DefaultCompress defaultCompress;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="extentManagement")
        private ExtentManagement extentManagement;
        @JsonProperty(value="extentUniformSize")
        private TablespaceStorageSize extentUniformSize;
        @JsonProperty(value="segmentManagement")
        private SegmentManagement segmentManagement;
        @JsonProperty(value="isDefault")
        private Boolean isDefault;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder credentialDetails(TablespaceAdminCredentialDetails credentialDetails) {
            this.credentialDetails = credentialDetails;
            this.__explicitlySet__.add("credentialDetails");
            return this;
        }

        public Builder databaseCredential(DatabaseCredentialDetails databaseCredential) {
            this.databaseCredential = databaseCredential;
            this.__explicitlySet__.add("databaseCredential");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder isBigfile(Boolean isBigfile) {
            this.isBigfile = isBigfile;
            this.__explicitlySet__.add("isBigfile");
            return this;
        }

        public Builder dataFiles(List<String> dataFiles) {
            this.dataFiles = dataFiles;
            this.__explicitlySet__.add("dataFiles");
            return this;
        }

        public Builder fileCount(Integer fileCount) {
            this.fileCount = fileCount;
            this.__explicitlySet__.add("fileCount");
            return this;
        }

        public Builder fileSize(TablespaceStorageSize fileSize) {
            this.fileSize = fileSize;
            this.__explicitlySet__.add("fileSize");
            return this;
        }

        public Builder isReusable(Boolean isReusable) {
            this.isReusable = isReusable;
            this.__explicitlySet__.add("isReusable");
            return this;
        }

        public Builder isAutoExtensible(Boolean isAutoExtensible) {
            this.isAutoExtensible = isAutoExtensible;
            this.__explicitlySet__.add("isAutoExtensible");
            return this;
        }

        public Builder autoExtendNextSize(TablespaceStorageSize autoExtendNextSize) {
            this.autoExtendNextSize = autoExtendNextSize;
            this.__explicitlySet__.add("autoExtendNextSize");
            return this;
        }

        public Builder autoExtendMaxSize(TablespaceStorageSize autoExtendMaxSize) {
            this.autoExtendMaxSize = autoExtendMaxSize;
            this.__explicitlySet__.add("autoExtendMaxSize");
            return this;
        }

        public Builder isMaxSizeUnlimited(Boolean isMaxSizeUnlimited) {
            this.isMaxSizeUnlimited = isMaxSizeUnlimited;
            this.__explicitlySet__.add("isMaxSizeUnlimited");
            return this;
        }

        public Builder blockSizeInKilobytes(Integer blockSizeInKilobytes) {
            this.blockSizeInKilobytes = blockSizeInKilobytes;
            this.__explicitlySet__.add("blockSizeInKilobytes");
            return this;
        }

        public Builder isEncrypted(Boolean isEncrypted) {
            this.isEncrypted = isEncrypted;
            this.__explicitlySet__.add("isEncrypted");
            return this;
        }

        public Builder encryptionAlgorithm(String encryptionAlgorithm) {
            this.encryptionAlgorithm = encryptionAlgorithm;
            this.__explicitlySet__.add("encryptionAlgorithm");
            return this;
        }

        public Builder defaultCompress(DefaultCompress defaultCompress) {
            this.defaultCompress = defaultCompress;
            this.__explicitlySet__.add("defaultCompress");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder extentManagement(ExtentManagement extentManagement) {
            this.extentManagement = extentManagement;
            this.__explicitlySet__.add("extentManagement");
            return this;
        }

        public Builder extentUniformSize(TablespaceStorageSize extentUniformSize) {
            this.extentUniformSize = extentUniformSize;
            this.__explicitlySet__.add("extentUniformSize");
            return this;
        }

        public Builder segmentManagement(SegmentManagement segmentManagement) {
            this.segmentManagement = segmentManagement;
            this.__explicitlySet__.add("segmentManagement");
            return this;
        }

        public Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            this.__explicitlySet__.add("isDefault");
            return this;
        }

        public CreateTablespaceDetails build() {
            CreateTablespaceDetails model = new CreateTablespaceDetails(this.credentialDetails, this.databaseCredential, this.name, this.type, this.isBigfile, this.dataFiles, this.fileCount, this.fileSize, this.isReusable, this.isAutoExtensible, this.autoExtendNextSize, this.autoExtendMaxSize, this.isMaxSizeUnlimited, this.blockSizeInKilobytes, this.isEncrypted, this.encryptionAlgorithm, this.defaultCompress, this.status, this.extentManagement, this.extentUniformSize, this.segmentManagement, this.isDefault);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateTablespaceDetails model) {
            if (model.wasPropertyExplicitlySet("credentialDetails")) {
                this.credentialDetails(model.getCredentialDetails());
            }
            if (model.wasPropertyExplicitlySet("databaseCredential")) {
                this.databaseCredential(model.getDatabaseCredential());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("isBigfile")) {
                this.isBigfile(model.getIsBigfile());
            }
            if (model.wasPropertyExplicitlySet("dataFiles")) {
                this.dataFiles(model.getDataFiles());
            }
            if (model.wasPropertyExplicitlySet("fileCount")) {
                this.fileCount(model.getFileCount());
            }
            if (model.wasPropertyExplicitlySet("fileSize")) {
                this.fileSize(model.getFileSize());
            }
            if (model.wasPropertyExplicitlySet("isReusable")) {
                this.isReusable(model.getIsReusable());
            }
            if (model.wasPropertyExplicitlySet("isAutoExtensible")) {
                this.isAutoExtensible(model.getIsAutoExtensible());
            }
            if (model.wasPropertyExplicitlySet("autoExtendNextSize")) {
                this.autoExtendNextSize(model.getAutoExtendNextSize());
            }
            if (model.wasPropertyExplicitlySet("autoExtendMaxSize")) {
                this.autoExtendMaxSize(model.getAutoExtendMaxSize());
            }
            if (model.wasPropertyExplicitlySet("isMaxSizeUnlimited")) {
                this.isMaxSizeUnlimited(model.getIsMaxSizeUnlimited());
            }
            if (model.wasPropertyExplicitlySet("blockSizeInKilobytes")) {
                this.blockSizeInKilobytes(model.getBlockSizeInKilobytes());
            }
            if (model.wasPropertyExplicitlySet("isEncrypted")) {
                this.isEncrypted(model.getIsEncrypted());
            }
            if (model.wasPropertyExplicitlySet("encryptionAlgorithm")) {
                this.encryptionAlgorithm(model.getEncryptionAlgorithm());
            }
            if (model.wasPropertyExplicitlySet("defaultCompress")) {
                this.defaultCompress(model.getDefaultCompress());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("extentManagement")) {
                this.extentManagement(model.getExtentManagement());
            }
            if (model.wasPropertyExplicitlySet("extentUniformSize")) {
                this.extentUniformSize(model.getExtentUniformSize());
            }
            if (model.wasPropertyExplicitlySet("segmentManagement")) {
                this.segmentManagement(model.getSegmentManagement());
            }
            if (model.wasPropertyExplicitlySet("isDefault")) {
                this.isDefault(model.getIsDefault());
            }
            return this;
        }
    }
}

