/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CursorCacheStatementSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="sqlId")
    private final String sqlId;
    @JsonProperty(value="schema")
    private final String schema;
    @JsonProperty(value="sqlText")
    private final String sqlText;

    @Deprecated
    @ConstructorProperties(value={"sqlId", "schema", "sqlText"})
    public CursorCacheStatementSummary(String sqlId, String schema, String sqlText) {
        this.sqlId = sqlId;
        this.schema = schema;
        this.sqlText = sqlText;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getSqlId() {
        return this.sqlId;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getSqlText() {
        return this.sqlText;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CursorCacheStatementSummary(");
        sb.append("super=").append(super.toString());
        sb.append("sqlId=").append(String.valueOf(this.sqlId));
        sb.append(", schema=").append(String.valueOf(this.schema));
        sb.append(", sqlText=").append(String.valueOf(this.sqlText));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CursorCacheStatementSummary)) {
            return false;
        }
        CursorCacheStatementSummary other = (CursorCacheStatementSummary)((Object)o);
        return Objects.equals(this.sqlId, other.sqlId) && Objects.equals(this.schema, other.schema) && Objects.equals(this.sqlText, other.sqlText) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.sqlId == null ? 43 : this.sqlId.hashCode());
        result = result * 59 + (this.schema == null ? 43 : this.schema.hashCode());
        result = result * 59 + (this.sqlText == null ? 43 : this.sqlText.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="sqlId")
        private String sqlId;
        @JsonProperty(value="schema")
        private String schema;
        @JsonProperty(value="sqlText")
        private String sqlText;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder sqlId(String sqlId) {
            this.sqlId = sqlId;
            this.__explicitlySet__.add("sqlId");
            return this;
        }

        public Builder schema(String schema) {
            this.schema = schema;
            this.__explicitlySet__.add("schema");
            return this;
        }

        public Builder sqlText(String sqlText) {
            this.sqlText = sqlText;
            this.__explicitlySet__.add("sqlText");
            return this;
        }

        public CursorCacheStatementSummary build() {
            CursorCacheStatementSummary model = new CursorCacheStatementSummary(this.sqlId, this.schema, this.sqlText);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CursorCacheStatementSummary model) {
            if (model.wasPropertyExplicitlySet("sqlId")) {
                this.sqlId(model.getSqlId());
            }
            if (model.wasPropertyExplicitlySet("schema")) {
                this.schema(model.getSchema());
            }
            if (model.wasPropertyExplicitlySet("sqlText")) {
                this.sqlText(model.getSqlText());
            }
            return this;
        }
    }
}

