/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.DatabaseConnectionCredentials;
import com.oracle.bmc.databasemanagement.model.DatabaseConnectionStringDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DatabaseConnectionDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="connectionString")
    private final DatabaseConnectionStringDetails connectionString;
    @JsonProperty(value="connectionCredentials")
    private final DatabaseConnectionCredentials connectionCredentials;

    @Deprecated
    @ConstructorProperties(value={"connectionString", "connectionCredentials"})
    public DatabaseConnectionDetails(DatabaseConnectionStringDetails connectionString, DatabaseConnectionCredentials connectionCredentials) {
        this.connectionString = connectionString;
        this.connectionCredentials = connectionCredentials;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public DatabaseConnectionStringDetails getConnectionString() {
        return this.connectionString;
    }

    public DatabaseConnectionCredentials getConnectionCredentials() {
        return this.connectionCredentials;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DatabaseConnectionDetails(");
        sb.append("super=").append(super.toString());
        sb.append("connectionString=").append(String.valueOf((Object)this.connectionString));
        sb.append(", connectionCredentials=").append(String.valueOf((Object)this.connectionCredentials));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DatabaseConnectionDetails)) {
            return false;
        }
        DatabaseConnectionDetails other = (DatabaseConnectionDetails)((Object)o);
        return Objects.equals((Object)this.connectionString, (Object)other.connectionString) && Objects.equals((Object)this.connectionCredentials, (Object)other.connectionCredentials) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.connectionString == null ? 43 : this.connectionString.hashCode());
        result = result * 59 + (this.connectionCredentials == null ? 43 : this.connectionCredentials.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="connectionString")
        private DatabaseConnectionStringDetails connectionString;
        @JsonProperty(value="connectionCredentials")
        private DatabaseConnectionCredentials connectionCredentials;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder connectionString(DatabaseConnectionStringDetails connectionString) {
            this.connectionString = connectionString;
            this.__explicitlySet__.add("connectionString");
            return this;
        }

        public Builder connectionCredentials(DatabaseConnectionCredentials connectionCredentials) {
            this.connectionCredentials = connectionCredentials;
            this.__explicitlySet__.add("connectionCredentials");
            return this;
        }

        public DatabaseConnectionDetails build() {
            DatabaseConnectionDetails model = new DatabaseConnectionDetails(this.connectionString, this.connectionCredentials);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DatabaseConnectionDetails model) {
            if (model.wasPropertyExplicitlySet("connectionString")) {
                this.connectionString(model.getConnectionString());
            }
            if (model.wasPropertyExplicitlySet("connectionCredentials")) {
                this.connectionCredentials(model.getConnectionCredentials());
            }
            return this;
        }
    }
}

