/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.ConnectorDetails;
import com.oracle.bmc.databasemanagement.model.DatabaseConnectionDetails;
import com.oracle.bmc.databasemanagement.model.DatabaseFeatureDetails;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="feature")
@JsonFilter(value="explicitlySetFilter")
public final class DatabaseDiagnosticsAndManagementFeatureDetails
extends DatabaseFeatureDetails {
    @JsonProperty(value="managementType")
    private final ManagementType managementType;
    @JsonProperty(value="isAutoEnablePluggableDatabase")
    private final Boolean isAutoEnablePluggableDatabase;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public DatabaseDiagnosticsAndManagementFeatureDetails(DatabaseConnectionDetails databaseConnectionDetails, ConnectorDetails connectorDetails, ManagementType managementType, Boolean isAutoEnablePluggableDatabase) {
        super(databaseConnectionDetails, connectorDetails);
        this.managementType = managementType;
        this.isAutoEnablePluggableDatabase = isAutoEnablePluggableDatabase;
    }

    public ManagementType getManagementType() {
        return this.managementType;
    }

    public Boolean getIsAutoEnablePluggableDatabase() {
        return this.isAutoEnablePluggableDatabase;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DatabaseDiagnosticsAndManagementFeatureDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", managementType=").append(String.valueOf((Object)this.managementType));
        sb.append(", isAutoEnablePluggableDatabase=").append(String.valueOf(this.isAutoEnablePluggableDatabase));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DatabaseDiagnosticsAndManagementFeatureDetails)) {
            return false;
        }
        DatabaseDiagnosticsAndManagementFeatureDetails other = (DatabaseDiagnosticsAndManagementFeatureDetails)((Object)o);
        return Objects.equals((Object)this.managementType, (Object)other.managementType) && Objects.equals(this.isAutoEnablePluggableDatabase, other.isAutoEnablePluggableDatabase) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.managementType == null ? 43 : this.managementType.hashCode());
        result = result * 59 + (this.isAutoEnablePluggableDatabase == null ? 43 : this.isAutoEnablePluggableDatabase.hashCode());
        return result;
    }

    public static enum ManagementType implements BmcEnum
    {
        Basic("BASIC"),
        Advanced("ADVANCED");

        private final String value;
        private static Map<String, ManagementType> map;

        private ManagementType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ManagementType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ManagementType: " + key);
        }

        static {
            map = new HashMap<String, ManagementType>();
            for (ManagementType v : ManagementType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="databaseConnectionDetails")
        private DatabaseConnectionDetails databaseConnectionDetails;
        @JsonProperty(value="connectorDetails")
        private ConnectorDetails connectorDetails;
        @JsonProperty(value="managementType")
        private ManagementType managementType;
        @JsonProperty(value="isAutoEnablePluggableDatabase")
        private Boolean isAutoEnablePluggableDatabase;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder databaseConnectionDetails(DatabaseConnectionDetails databaseConnectionDetails) {
            this.databaseConnectionDetails = databaseConnectionDetails;
            this.__explicitlySet__.add("databaseConnectionDetails");
            return this;
        }

        public Builder connectorDetails(ConnectorDetails connectorDetails) {
            this.connectorDetails = connectorDetails;
            this.__explicitlySet__.add("connectorDetails");
            return this;
        }

        public Builder managementType(ManagementType managementType) {
            this.managementType = managementType;
            this.__explicitlySet__.add("managementType");
            return this;
        }

        public Builder isAutoEnablePluggableDatabase(Boolean isAutoEnablePluggableDatabase) {
            this.isAutoEnablePluggableDatabase = isAutoEnablePluggableDatabase;
            this.__explicitlySet__.add("isAutoEnablePluggableDatabase");
            return this;
        }

        public DatabaseDiagnosticsAndManagementFeatureDetails build() {
            DatabaseDiagnosticsAndManagementFeatureDetails model = new DatabaseDiagnosticsAndManagementFeatureDetails(this.databaseConnectionDetails, this.connectorDetails, this.managementType, this.isAutoEnablePluggableDatabase);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DatabaseDiagnosticsAndManagementFeatureDetails model) {
            if (model.wasPropertyExplicitlySet("databaseConnectionDetails")) {
                this.databaseConnectionDetails(model.getDatabaseConnectionDetails());
            }
            if (model.wasPropertyExplicitlySet("connectorDetails")) {
                this.connectorDetails(model.getConnectorDetails());
            }
            if (model.wasPropertyExplicitlySet("managementType")) {
                this.managementType(model.getManagementType());
            }
            if (model.wasPropertyExplicitlySet("isAutoEnablePluggableDatabase")) {
                this.isAutoEnablePluggableDatabase(model.getIsAutoEnablePluggableDatabase());
            }
            return this;
        }
    }
}

