/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.databasemanagement.model.ConnectorDetails;
import com.oracle.bmc.databasemanagement.model.DatabaseConnectionDetails;
import com.oracle.bmc.databasemanagement.model.DatabaseDiagnosticsAndManagementFeatureConfiguration;
import com.oracle.bmc.databasemanagement.model.DatabaseLifecycleFeatureConfiguration;
import com.oracle.bmc.databasemanagement.model.DatabaseSqlWatchFeatureConfiguration;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="feature", defaultImpl=DatabaseFeatureConfiguration.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=DatabaseDiagnosticsAndManagementFeatureConfiguration.class, name="DIAGNOSTICS_AND_MANAGEMENT"), @JsonSubTypes.Type(value=DatabaseLifecycleFeatureConfiguration.class, name="DB_LIFECYCLE_MANAGEMENT"), @JsonSubTypes.Type(value=DatabaseSqlWatchFeatureConfiguration.class, name="SQLWATCH")})
@JsonFilter(value="explicitlySetFilter")
public class DatabaseFeatureConfiguration
extends ExplicitlySetBmcModel {
    @JsonProperty(value="featureStatus")
    private final FeatureStatus featureStatus;
    @JsonProperty(value="connectorDetails")
    private final ConnectorDetails connectorDetails;
    @JsonProperty(value="databaseConnectionDetails")
    private final DatabaseConnectionDetails databaseConnectionDetails;

    @Deprecated
    @ConstructorProperties(value={"featureStatus", "connectorDetails", "databaseConnectionDetails"})
    protected DatabaseFeatureConfiguration(FeatureStatus featureStatus, ConnectorDetails connectorDetails, DatabaseConnectionDetails databaseConnectionDetails) {
        this.featureStatus = featureStatus;
        this.connectorDetails = connectorDetails;
        this.databaseConnectionDetails = databaseConnectionDetails;
    }

    public FeatureStatus getFeatureStatus() {
        return this.featureStatus;
    }

    public ConnectorDetails getConnectorDetails() {
        return this.connectorDetails;
    }

    public DatabaseConnectionDetails getDatabaseConnectionDetails() {
        return this.databaseConnectionDetails;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DatabaseFeatureConfiguration(");
        sb.append("super=").append(super.toString());
        sb.append("featureStatus=").append(String.valueOf((Object)this.featureStatus));
        sb.append(", connectorDetails=").append(String.valueOf((Object)this.connectorDetails));
        sb.append(", databaseConnectionDetails=").append(String.valueOf((Object)this.databaseConnectionDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DatabaseFeatureConfiguration)) {
            return false;
        }
        DatabaseFeatureConfiguration other = (DatabaseFeatureConfiguration)((Object)o);
        return Objects.equals((Object)this.featureStatus, (Object)other.featureStatus) && Objects.equals((Object)this.connectorDetails, (Object)other.connectorDetails) && Objects.equals((Object)this.databaseConnectionDetails, (Object)other.databaseConnectionDetails) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.featureStatus == null ? 43 : this.featureStatus.hashCode());
        result = result * 59 + (this.connectorDetails == null ? 43 : this.connectorDetails.hashCode());
        result = result * 59 + (this.databaseConnectionDetails == null ? 43 : this.databaseConnectionDetails.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum FeatureStatus implements BmcEnum
    {
        Enabled("ENABLED"),
        NotEnabled("NOT_ENABLED"),
        Unsupported("UNSUPPORTED"),
        FailedEnabling("FAILED_ENABLING"),
        FailedDisabling("FAILED_DISABLING"),
        Failed("FAILED"),
        EnabledWithWarnings("ENABLED_WITH_WARNINGS"),
        PendingDisable("PENDING_DISABLE"),
        Enabling("ENABLING"),
        Disabling("DISABLING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, FeatureStatus> map;

        private FeatureStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static FeatureStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'FeatureStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(FeatureStatus.class);
            map = new HashMap<String, FeatureStatus>();
            for (FeatureStatus v : FeatureStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

