/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.AssociatedComponent;
import com.oracle.bmc.databasemanagement.model.DiscoveredExternalDbSystemComponent;
import com.oracle.bmc.databasemanagement.model.ExternalDbSystemDiscoveryConnector;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="componentType")
@JsonFilter(value="explicitlySetFilter")
public final class DiscoveredExternalDbNode
extends DiscoveredExternalDbSystemComponent {
    @JsonProperty(value="hostName")
    private final String hostName;
    @JsonProperty(value="cpuCoreCount")
    private final Float cpuCoreCount;
    @JsonProperty(value="memorySizeInGBs")
    private final Float memorySizeInGBs;
    @JsonProperty(value="connector")
    private final ExternalDbSystemDiscoveryConnector connector;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public DiscoveredExternalDbNode(String componentId, String displayName, String componentName, String resourceId, Boolean isSelectedForMonitoring, DiscoveredExternalDbSystemComponent.Status status, List<AssociatedComponent> associatedComponents, String hostName, Float cpuCoreCount, Float memorySizeInGBs, ExternalDbSystemDiscoveryConnector connector) {
        super(componentId, displayName, componentName, resourceId, isSelectedForMonitoring, status, associatedComponents);
        this.hostName = hostName;
        this.cpuCoreCount = cpuCoreCount;
        this.memorySizeInGBs = memorySizeInGBs;
        this.connector = connector;
    }

    public String getHostName() {
        return this.hostName;
    }

    public Float getCpuCoreCount() {
        return this.cpuCoreCount;
    }

    public Float getMemorySizeInGBs() {
        return this.memorySizeInGBs;
    }

    public ExternalDbSystemDiscoveryConnector getConnector() {
        return this.connector;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DiscoveredExternalDbNode(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", hostName=").append(String.valueOf(this.hostName));
        sb.append(", cpuCoreCount=").append(String.valueOf(this.cpuCoreCount));
        sb.append(", memorySizeInGBs=").append(String.valueOf(this.memorySizeInGBs));
        sb.append(", connector=").append(String.valueOf((Object)this.connector));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DiscoveredExternalDbNode)) {
            return false;
        }
        DiscoveredExternalDbNode other = (DiscoveredExternalDbNode)((Object)o);
        return Objects.equals(this.hostName, other.hostName) && Objects.equals(this.cpuCoreCount, other.cpuCoreCount) && Objects.equals(this.memorySizeInGBs, other.memorySizeInGBs) && Objects.equals((Object)this.connector, (Object)other.connector) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.hostName == null ? 43 : this.hostName.hashCode());
        result = result * 59 + (this.cpuCoreCount == null ? 43 : this.cpuCoreCount.hashCode());
        result = result * 59 + (this.memorySizeInGBs == null ? 43 : this.memorySizeInGBs.hashCode());
        result = result * 59 + (this.connector == null ? 43 : this.connector.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="componentId")
        private String componentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="componentName")
        private String componentName;
        @JsonProperty(value="resourceId")
        private String resourceId;
        @JsonProperty(value="isSelectedForMonitoring")
        private Boolean isSelectedForMonitoring;
        @JsonProperty(value="status")
        private DiscoveredExternalDbSystemComponent.Status status;
        @JsonProperty(value="associatedComponents")
        private List<AssociatedComponent> associatedComponents;
        @JsonProperty(value="hostName")
        private String hostName;
        @JsonProperty(value="cpuCoreCount")
        private Float cpuCoreCount;
        @JsonProperty(value="memorySizeInGBs")
        private Float memorySizeInGBs;
        @JsonProperty(value="connector")
        private ExternalDbSystemDiscoveryConnector connector;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder componentId(String componentId) {
            this.componentId = componentId;
            this.__explicitlySet__.add("componentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder componentName(String componentName) {
            this.componentName = componentName;
            this.__explicitlySet__.add("componentName");
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.__explicitlySet__.add("resourceId");
            return this;
        }

        public Builder isSelectedForMonitoring(Boolean isSelectedForMonitoring) {
            this.isSelectedForMonitoring = isSelectedForMonitoring;
            this.__explicitlySet__.add("isSelectedForMonitoring");
            return this;
        }

        public Builder status(DiscoveredExternalDbSystemComponent.Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder associatedComponents(List<AssociatedComponent> associatedComponents) {
            this.associatedComponents = associatedComponents;
            this.__explicitlySet__.add("associatedComponents");
            return this;
        }

        public Builder hostName(String hostName) {
            this.hostName = hostName;
            this.__explicitlySet__.add("hostName");
            return this;
        }

        public Builder cpuCoreCount(Float cpuCoreCount) {
            this.cpuCoreCount = cpuCoreCount;
            this.__explicitlySet__.add("cpuCoreCount");
            return this;
        }

        public Builder memorySizeInGBs(Float memorySizeInGBs) {
            this.memorySizeInGBs = memorySizeInGBs;
            this.__explicitlySet__.add("memorySizeInGBs");
            return this;
        }

        public Builder connector(ExternalDbSystemDiscoveryConnector connector) {
            this.connector = connector;
            this.__explicitlySet__.add("connector");
            return this;
        }

        public DiscoveredExternalDbNode build() {
            DiscoveredExternalDbNode model = new DiscoveredExternalDbNode(this.componentId, this.displayName, this.componentName, this.resourceId, this.isSelectedForMonitoring, this.status, this.associatedComponents, this.hostName, this.cpuCoreCount, this.memorySizeInGBs, this.connector);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DiscoveredExternalDbNode model) {
            if (model.wasPropertyExplicitlySet("componentId")) {
                this.componentId(model.getComponentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("componentName")) {
                this.componentName(model.getComponentName());
            }
            if (model.wasPropertyExplicitlySet("resourceId")) {
                this.resourceId(model.getResourceId());
            }
            if (model.wasPropertyExplicitlySet("isSelectedForMonitoring")) {
                this.isSelectedForMonitoring(model.getIsSelectedForMonitoring());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("associatedComponents")) {
                this.associatedComponents(model.getAssociatedComponents());
            }
            if (model.wasPropertyExplicitlySet("hostName")) {
                this.hostName(model.getHostName());
            }
            if (model.wasPropertyExplicitlySet("cpuCoreCount")) {
                this.cpuCoreCount(model.getCpuCoreCount());
            }
            if (model.wasPropertyExplicitlySet("memorySizeInGBs")) {
                this.memorySizeInGBs(model.getMemorySizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("connector")) {
                this.connector(model.getConnector());
            }
            return this;
        }
    }
}

