/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ExternalClusterScanListenerConfiguration
extends ExplicitlySetBmcModel {
    @JsonProperty(value="scanName")
    private final String scanName;
    @JsonProperty(value="networkNumber")
    private final Integer networkNumber;
    @JsonProperty(value="scanPort")
    private final Integer scanPort;
    @JsonProperty(value="scanProtocol")
    private final ScanProtocol scanProtocol;

    @Deprecated
    @ConstructorProperties(value={"scanName", "networkNumber", "scanPort", "scanProtocol"})
    public ExternalClusterScanListenerConfiguration(String scanName, Integer networkNumber, Integer scanPort, ScanProtocol scanProtocol) {
        this.scanName = scanName;
        this.networkNumber = networkNumber;
        this.scanPort = scanPort;
        this.scanProtocol = scanProtocol;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getScanName() {
        return this.scanName;
    }

    public Integer getNetworkNumber() {
        return this.networkNumber;
    }

    public Integer getScanPort() {
        return this.scanPort;
    }

    public ScanProtocol getScanProtocol() {
        return this.scanProtocol;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExternalClusterScanListenerConfiguration(");
        sb.append("super=").append(super.toString());
        sb.append("scanName=").append(String.valueOf(this.scanName));
        sb.append(", networkNumber=").append(String.valueOf(this.networkNumber));
        sb.append(", scanPort=").append(String.valueOf(this.scanPort));
        sb.append(", scanProtocol=").append(String.valueOf((Object)this.scanProtocol));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExternalClusterScanListenerConfiguration)) {
            return false;
        }
        ExternalClusterScanListenerConfiguration other = (ExternalClusterScanListenerConfiguration)((Object)o);
        return Objects.equals(this.scanName, other.scanName) && Objects.equals(this.networkNumber, other.networkNumber) && Objects.equals(this.scanPort, other.scanPort) && Objects.equals((Object)this.scanProtocol, (Object)other.scanProtocol) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.scanName == null ? 43 : this.scanName.hashCode());
        result = result * 59 + (this.networkNumber == null ? 43 : this.networkNumber.hashCode());
        result = result * 59 + (this.scanPort == null ? 43 : this.scanPort.hashCode());
        result = result * 59 + (this.scanProtocol == null ? 43 : this.scanProtocol.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ScanProtocol implements BmcEnum
    {
        Tcp("TCP"),
        Tcps("TCPS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ScanProtocol> map;

        private ScanProtocol(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ScanProtocol create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ScanProtocol', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ScanProtocol.class);
            map = new HashMap<String, ScanProtocol>();
            for (ScanProtocol v : ScanProtocol.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="scanName")
        private String scanName;
        @JsonProperty(value="networkNumber")
        private Integer networkNumber;
        @JsonProperty(value="scanPort")
        private Integer scanPort;
        @JsonProperty(value="scanProtocol")
        private ScanProtocol scanProtocol;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder scanName(String scanName) {
            this.scanName = scanName;
            this.__explicitlySet__.add("scanName");
            return this;
        }

        public Builder networkNumber(Integer networkNumber) {
            this.networkNumber = networkNumber;
            this.__explicitlySet__.add("networkNumber");
            return this;
        }

        public Builder scanPort(Integer scanPort) {
            this.scanPort = scanPort;
            this.__explicitlySet__.add("scanPort");
            return this;
        }

        public Builder scanProtocol(ScanProtocol scanProtocol) {
            this.scanProtocol = scanProtocol;
            this.__explicitlySet__.add("scanProtocol");
            return this;
        }

        public ExternalClusterScanListenerConfiguration build() {
            ExternalClusterScanListenerConfiguration model = new ExternalClusterScanListenerConfiguration(this.scanName, this.networkNumber, this.scanPort, this.scanProtocol);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExternalClusterScanListenerConfiguration model) {
            if (model.wasPropertyExplicitlySet("scanName")) {
                this.scanName(model.getScanName());
            }
            if (model.wasPropertyExplicitlySet("networkNumber")) {
                this.networkNumber(model.getNetworkNumber());
            }
            if (model.wasPropertyExplicitlySet("scanPort")) {
                this.scanPort(model.getScanPort());
            }
            if (model.wasPropertyExplicitlySet("scanProtocol")) {
                this.scanProtocol(model.getScanProtocol());
            }
            return this;
        }
    }
}

