/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.ConnectorDetails;
import com.oracle.bmc.databasemanagement.model.ExternalDatabaseFeatureDetails;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="feature")
@JsonFilter(value="explicitlySetFilter")
public final class ExternalDatabaseDiagnosticsAndManagementFeatureDetails
extends ExternalDatabaseFeatureDetails {
    @JsonProperty(value="licenseModel")
    private final LicenseModel licenseModel;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ExternalDatabaseDiagnosticsAndManagementFeatureDetails(ConnectorDetails connectorDetails, LicenseModel licenseModel) {
        super(connectorDetails);
        this.licenseModel = licenseModel;
    }

    public LicenseModel getLicenseModel() {
        return this.licenseModel;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExternalDatabaseDiagnosticsAndManagementFeatureDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", licenseModel=").append(String.valueOf((Object)this.licenseModel));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExternalDatabaseDiagnosticsAndManagementFeatureDetails)) {
            return false;
        }
        ExternalDatabaseDiagnosticsAndManagementFeatureDetails other = (ExternalDatabaseDiagnosticsAndManagementFeatureDetails)((Object)o);
        return Objects.equals((Object)this.licenseModel, (Object)other.licenseModel) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.licenseModel == null ? 43 : this.licenseModel.hashCode());
        return result;
    }

    public static enum LicenseModel implements BmcEnum
    {
        LicenseIncluded("LICENSE_INCLUDED"),
        BringYourOwnLicense("BRING_YOUR_OWN_LICENSE");

        private final String value;
        private static Map<String, LicenseModel> map;

        private LicenseModel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LicenseModel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid LicenseModel: " + key);
        }

        static {
            map = new HashMap<String, LicenseModel>();
            for (LicenseModel v : LicenseModel.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="connectorDetails")
        private ConnectorDetails connectorDetails;
        @JsonProperty(value="licenseModel")
        private LicenseModel licenseModel;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder connectorDetails(ConnectorDetails connectorDetails) {
            this.connectorDetails = connectorDetails;
            this.__explicitlySet__.add("connectorDetails");
            return this;
        }

        public Builder licenseModel(LicenseModel licenseModel) {
            this.licenseModel = licenseModel;
            this.__explicitlySet__.add("licenseModel");
            return this;
        }

        public ExternalDatabaseDiagnosticsAndManagementFeatureDetails build() {
            ExternalDatabaseDiagnosticsAndManagementFeatureDetails model = new ExternalDatabaseDiagnosticsAndManagementFeatureDetails(this.connectorDetails, this.licenseModel);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExternalDatabaseDiagnosticsAndManagementFeatureDetails model) {
            if (model.wasPropertyExplicitlySet("connectorDetails")) {
                this.connectorDetails(model.getConnectorDetails());
            }
            if (model.wasPropertyExplicitlySet("licenseModel")) {
                this.licenseModel(model.getLicenseModel());
            }
            return this;
        }
    }
}

