/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.DbmResource;
import com.oracle.bmc.databasemanagement.model.ExternalExadataDatabaseSystemSummary;
import com.oracle.bmc.databasemanagement.model.ExternalExadataStorageGridSummary;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="resourceType")
@JsonFilter(value="explicitlySetFilter")
public final class ExternalExadataInfrastructure
extends DbmResource {
    @JsonProperty(value="rackSize")
    private final RackSize rackSize;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="licenseModel")
    private final LicenseModel licenseModel;
    @JsonProperty(value="storageGrid")
    private final ExternalExadataStorageGridSummary storageGrid;
    @JsonProperty(value="databaseSystems")
    private final List<ExternalExadataDatabaseSystemSummary> databaseSystems;
    @JsonProperty(value="databaseCompartments")
    private final List<String> databaseCompartments;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ExternalExadataInfrastructure(String id, String displayName, String version, String internalId, String status, DbmResource.LifecycleState lifecycleState, Date timeCreated, Date timeUpdated, String lifecycleDetails, Map<String, String> additionalDetails, RackSize rackSize, String compartmentId, LicenseModel licenseModel, ExternalExadataStorageGridSummary storageGrid, List<ExternalExadataDatabaseSystemSummary> databaseSystems, List<String> databaseCompartments, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags) {
        super(id, displayName, version, internalId, status, lifecycleState, timeCreated, timeUpdated, lifecycleDetails, additionalDetails);
        this.rackSize = rackSize;
        this.compartmentId = compartmentId;
        this.licenseModel = licenseModel;
        this.storageGrid = storageGrid;
        this.databaseSystems = databaseSystems;
        this.databaseCompartments = databaseCompartments;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
    }

    public RackSize getRackSize() {
        return this.rackSize;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public LicenseModel getLicenseModel() {
        return this.licenseModel;
    }

    public ExternalExadataStorageGridSummary getStorageGrid() {
        return this.storageGrid;
    }

    public List<ExternalExadataDatabaseSystemSummary> getDatabaseSystems() {
        return this.databaseSystems;
    }

    public List<String> getDatabaseCompartments() {
        return this.databaseCompartments;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExternalExadataInfrastructure(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", rackSize=").append(String.valueOf((Object)this.rackSize));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", licenseModel=").append(String.valueOf((Object)this.licenseModel));
        sb.append(", storageGrid=").append(String.valueOf((Object)this.storageGrid));
        sb.append(", databaseSystems=").append(String.valueOf(this.databaseSystems));
        sb.append(", databaseCompartments=").append(String.valueOf(this.databaseCompartments));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExternalExadataInfrastructure)) {
            return false;
        }
        ExternalExadataInfrastructure other = (ExternalExadataInfrastructure)((Object)o);
        return Objects.equals((Object)this.rackSize, (Object)other.rackSize) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.licenseModel, (Object)other.licenseModel) && Objects.equals((Object)this.storageGrid, (Object)other.storageGrid) && Objects.equals(this.databaseSystems, other.databaseSystems) && Objects.equals(this.databaseCompartments, other.databaseCompartments) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.rackSize == null ? 43 : this.rackSize.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.licenseModel == null ? 43 : this.licenseModel.hashCode());
        result = result * 59 + (this.storageGrid == null ? 43 : this.storageGrid.hashCode());
        result = result * 59 + (this.databaseSystems == null ? 43 : this.databaseSystems.hashCode());
        result = result * 59 + (this.databaseCompartments == null ? 43 : this.databaseCompartments.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        return result;
    }

    public static enum LicenseModel implements BmcEnum
    {
        LicenseIncluded("LICENSE_INCLUDED"),
        BringYourOwnLicense("BRING_YOUR_OWN_LICENSE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LicenseModel> map;

        private LicenseModel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LicenseModel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LicenseModel', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LicenseModel.class);
            map = new HashMap<String, LicenseModel>();
            for (LicenseModel v : LicenseModel.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum RackSize implements BmcEnum
    {
        Full("FULL"),
        Half("HALF"),
        Quarter("QUARTER"),
        Eighth("EIGHTH"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, RackSize> map;

        private RackSize(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static RackSize create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'RackSize', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(RackSize.class);
            map = new HashMap<String, RackSize>();
            for (RackSize v : RackSize.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="internalId")
        private String internalId;
        @JsonProperty(value="status")
        private String status;
        @JsonProperty(value="lifecycleState")
        private DbmResource.LifecycleState lifecycleState;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="additionalDetails")
        private Map<String, String> additionalDetails;
        @JsonProperty(value="rackSize")
        private RackSize rackSize;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="licenseModel")
        private LicenseModel licenseModel;
        @JsonProperty(value="storageGrid")
        private ExternalExadataStorageGridSummary storageGrid;
        @JsonProperty(value="databaseSystems")
        private List<ExternalExadataDatabaseSystemSummary> databaseSystems;
        @JsonProperty(value="databaseCompartments")
        private List<String> databaseCompartments;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder internalId(String internalId) {
            this.internalId = internalId;
            this.__explicitlySet__.add("internalId");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder lifecycleState(DbmResource.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder additionalDetails(Map<String, String> additionalDetails) {
            this.additionalDetails = additionalDetails;
            this.__explicitlySet__.add("additionalDetails");
            return this;
        }

        public Builder rackSize(RackSize rackSize) {
            this.rackSize = rackSize;
            this.__explicitlySet__.add("rackSize");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder licenseModel(LicenseModel licenseModel) {
            this.licenseModel = licenseModel;
            this.__explicitlySet__.add("licenseModel");
            return this;
        }

        public Builder storageGrid(ExternalExadataStorageGridSummary storageGrid) {
            this.storageGrid = storageGrid;
            this.__explicitlySet__.add("storageGrid");
            return this;
        }

        public Builder databaseSystems(List<ExternalExadataDatabaseSystemSummary> databaseSystems) {
            this.databaseSystems = databaseSystems;
            this.__explicitlySet__.add("databaseSystems");
            return this;
        }

        public Builder databaseCompartments(List<String> databaseCompartments) {
            this.databaseCompartments = databaseCompartments;
            this.__explicitlySet__.add("databaseCompartments");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public ExternalExadataInfrastructure build() {
            ExternalExadataInfrastructure model = new ExternalExadataInfrastructure(this.id, this.displayName, this.version, this.internalId, this.status, this.lifecycleState, this.timeCreated, this.timeUpdated, this.lifecycleDetails, this.additionalDetails, this.rackSize, this.compartmentId, this.licenseModel, this.storageGrid, this.databaseSystems, this.databaseCompartments, this.freeformTags, this.definedTags, this.systemTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExternalExadataInfrastructure model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("internalId")) {
                this.internalId(model.getInternalId());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("additionalDetails")) {
                this.additionalDetails(model.getAdditionalDetails());
            }
            if (model.wasPropertyExplicitlySet("rackSize")) {
                this.rackSize(model.getRackSize());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("licenseModel")) {
                this.licenseModel(model.getLicenseModel());
            }
            if (model.wasPropertyExplicitlySet("storageGrid")) {
                this.storageGrid(model.getStorageGrid());
            }
            if (model.wasPropertyExplicitlySet("databaseSystems")) {
                this.databaseSystems(model.getDatabaseSystems());
            }
            if (model.wasPropertyExplicitlySet("databaseCompartments")) {
                this.databaseCompartments(model.getDatabaseCompartments());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            return this;
        }
    }
}

