/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.DatabaseSubType;
import com.oracle.bmc.databasemanagement.model.DatabaseType;
import com.oracle.bmc.databasemanagement.model.DeploymentType;
import com.oracle.bmc.databasemanagement.model.JobExecution;
import com.oracle.bmc.databasemanagement.model.WorkloadType;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class JobExecutionSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="managedDatabaseGroupId")
    private final String managedDatabaseGroupId;
    @JsonProperty(value="managedDatabaseId")
    private final String managedDatabaseId;
    @JsonProperty(value="managedDatabaseName")
    private final String managedDatabaseName;
    @JsonProperty(value="databaseType")
    private final DatabaseType databaseType;
    @JsonProperty(value="databaseSubType")
    private final DatabaseSubType databaseSubType;
    @JsonProperty(value="deploymentType")
    private final DeploymentType deploymentType;
    @JsonProperty(value="isCluster")
    private final Boolean isCluster;
    @JsonProperty(value="workloadType")
    private final WorkloadType workloadType;
    @JsonProperty(value="jobId")
    private final String jobId;
    @JsonProperty(value="jobName")
    private final String jobName;
    @JsonProperty(value="status")
    private final JobExecution.Status status;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeCompleted")
    private final Date timeCompleted;

    @Deprecated
    @ConstructorProperties(value={"id", "name", "compartmentId", "managedDatabaseGroupId", "managedDatabaseId", "managedDatabaseName", "databaseType", "databaseSubType", "deploymentType", "isCluster", "workloadType", "jobId", "jobName", "status", "timeCreated", "timeCompleted"})
    public JobExecutionSummary(String id, String name, String compartmentId, String managedDatabaseGroupId, String managedDatabaseId, String managedDatabaseName, DatabaseType databaseType, DatabaseSubType databaseSubType, DeploymentType deploymentType, Boolean isCluster, WorkloadType workloadType, String jobId, String jobName, JobExecution.Status status, Date timeCreated, Date timeCompleted) {
        this.id = id;
        this.name = name;
        this.compartmentId = compartmentId;
        this.managedDatabaseGroupId = managedDatabaseGroupId;
        this.managedDatabaseId = managedDatabaseId;
        this.managedDatabaseName = managedDatabaseName;
        this.databaseType = databaseType;
        this.databaseSubType = databaseSubType;
        this.deploymentType = deploymentType;
        this.isCluster = isCluster;
        this.workloadType = workloadType;
        this.jobId = jobId;
        this.jobName = jobName;
        this.status = status;
        this.timeCreated = timeCreated;
        this.timeCompleted = timeCompleted;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getManagedDatabaseGroupId() {
        return this.managedDatabaseGroupId;
    }

    public String getManagedDatabaseId() {
        return this.managedDatabaseId;
    }

    public String getManagedDatabaseName() {
        return this.managedDatabaseName;
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public DatabaseSubType getDatabaseSubType() {
        return this.databaseSubType;
    }

    public DeploymentType getDeploymentType() {
        return this.deploymentType;
    }

    public Boolean getIsCluster() {
        return this.isCluster;
    }

    public WorkloadType getWorkloadType() {
        return this.workloadType;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getJobName() {
        return this.jobName;
    }

    public JobExecution.Status getStatus() {
        return this.status;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeCompleted() {
        return this.timeCompleted;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("JobExecutionSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", managedDatabaseGroupId=").append(String.valueOf(this.managedDatabaseGroupId));
        sb.append(", managedDatabaseId=").append(String.valueOf(this.managedDatabaseId));
        sb.append(", managedDatabaseName=").append(String.valueOf(this.managedDatabaseName));
        sb.append(", databaseType=").append(String.valueOf((Object)this.databaseType));
        sb.append(", databaseSubType=").append(String.valueOf((Object)this.databaseSubType));
        sb.append(", deploymentType=").append(String.valueOf((Object)this.deploymentType));
        sb.append(", isCluster=").append(String.valueOf(this.isCluster));
        sb.append(", workloadType=").append(String.valueOf((Object)this.workloadType));
        sb.append(", jobId=").append(String.valueOf(this.jobId));
        sb.append(", jobName=").append(String.valueOf(this.jobName));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeCompleted=").append(String.valueOf(this.timeCompleted));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JobExecutionSummary)) {
            return false;
        }
        JobExecutionSummary other = (JobExecutionSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.managedDatabaseGroupId, other.managedDatabaseGroupId) && Objects.equals(this.managedDatabaseId, other.managedDatabaseId) && Objects.equals(this.managedDatabaseName, other.managedDatabaseName) && Objects.equals((Object)this.databaseType, (Object)other.databaseType) && Objects.equals((Object)this.databaseSubType, (Object)other.databaseSubType) && Objects.equals((Object)this.deploymentType, (Object)other.deploymentType) && Objects.equals(this.isCluster, other.isCluster) && Objects.equals((Object)this.workloadType, (Object)other.workloadType) && Objects.equals(this.jobId, other.jobId) && Objects.equals(this.jobName, other.jobName) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeCompleted, other.timeCompleted) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.managedDatabaseGroupId == null ? 43 : this.managedDatabaseGroupId.hashCode());
        result = result * 59 + (this.managedDatabaseId == null ? 43 : this.managedDatabaseId.hashCode());
        result = result * 59 + (this.managedDatabaseName == null ? 43 : this.managedDatabaseName.hashCode());
        result = result * 59 + (this.databaseType == null ? 43 : this.databaseType.hashCode());
        result = result * 59 + (this.databaseSubType == null ? 43 : this.databaseSubType.hashCode());
        result = result * 59 + (this.deploymentType == null ? 43 : this.deploymentType.hashCode());
        result = result * 59 + (this.isCluster == null ? 43 : this.isCluster.hashCode());
        result = result * 59 + (this.workloadType == null ? 43 : this.workloadType.hashCode());
        result = result * 59 + (this.jobId == null ? 43 : this.jobId.hashCode());
        result = result * 59 + (this.jobName == null ? 43 : this.jobName.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeCompleted == null ? 43 : this.timeCompleted.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="managedDatabaseGroupId")
        private String managedDatabaseGroupId;
        @JsonProperty(value="managedDatabaseId")
        private String managedDatabaseId;
        @JsonProperty(value="managedDatabaseName")
        private String managedDatabaseName;
        @JsonProperty(value="databaseType")
        private DatabaseType databaseType;
        @JsonProperty(value="databaseSubType")
        private DatabaseSubType databaseSubType;
        @JsonProperty(value="deploymentType")
        private DeploymentType deploymentType;
        @JsonProperty(value="isCluster")
        private Boolean isCluster;
        @JsonProperty(value="workloadType")
        private WorkloadType workloadType;
        @JsonProperty(value="jobId")
        private String jobId;
        @JsonProperty(value="jobName")
        private String jobName;
        @JsonProperty(value="status")
        private JobExecution.Status status;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeCompleted")
        private Date timeCompleted;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder managedDatabaseGroupId(String managedDatabaseGroupId) {
            this.managedDatabaseGroupId = managedDatabaseGroupId;
            this.__explicitlySet__.add("managedDatabaseGroupId");
            return this;
        }

        public Builder managedDatabaseId(String managedDatabaseId) {
            this.managedDatabaseId = managedDatabaseId;
            this.__explicitlySet__.add("managedDatabaseId");
            return this;
        }

        public Builder managedDatabaseName(String managedDatabaseName) {
            this.managedDatabaseName = managedDatabaseName;
            this.__explicitlySet__.add("managedDatabaseName");
            return this;
        }

        public Builder databaseType(DatabaseType databaseType) {
            this.databaseType = databaseType;
            this.__explicitlySet__.add("databaseType");
            return this;
        }

        public Builder databaseSubType(DatabaseSubType databaseSubType) {
            this.databaseSubType = databaseSubType;
            this.__explicitlySet__.add("databaseSubType");
            return this;
        }

        public Builder deploymentType(DeploymentType deploymentType) {
            this.deploymentType = deploymentType;
            this.__explicitlySet__.add("deploymentType");
            return this;
        }

        public Builder isCluster(Boolean isCluster) {
            this.isCluster = isCluster;
            this.__explicitlySet__.add("isCluster");
            return this;
        }

        public Builder workloadType(WorkloadType workloadType) {
            this.workloadType = workloadType;
            this.__explicitlySet__.add("workloadType");
            return this;
        }

        public Builder jobId(String jobId) {
            this.jobId = jobId;
            this.__explicitlySet__.add("jobId");
            return this;
        }

        public Builder jobName(String jobName) {
            this.jobName = jobName;
            this.__explicitlySet__.add("jobName");
            return this;
        }

        public Builder status(JobExecution.Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeCompleted(Date timeCompleted) {
            this.timeCompleted = timeCompleted;
            this.__explicitlySet__.add("timeCompleted");
            return this;
        }

        public JobExecutionSummary build() {
            JobExecutionSummary model = new JobExecutionSummary(this.id, this.name, this.compartmentId, this.managedDatabaseGroupId, this.managedDatabaseId, this.managedDatabaseName, this.databaseType, this.databaseSubType, this.deploymentType, this.isCluster, this.workloadType, this.jobId, this.jobName, this.status, this.timeCreated, this.timeCompleted);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(JobExecutionSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("managedDatabaseGroupId")) {
                this.managedDatabaseGroupId(model.getManagedDatabaseGroupId());
            }
            if (model.wasPropertyExplicitlySet("managedDatabaseId")) {
                this.managedDatabaseId(model.getManagedDatabaseId());
            }
            if (model.wasPropertyExplicitlySet("managedDatabaseName")) {
                this.managedDatabaseName(model.getManagedDatabaseName());
            }
            if (model.wasPropertyExplicitlySet("databaseType")) {
                this.databaseType(model.getDatabaseType());
            }
            if (model.wasPropertyExplicitlySet("databaseSubType")) {
                this.databaseSubType(model.getDatabaseSubType());
            }
            if (model.wasPropertyExplicitlySet("deploymentType")) {
                this.deploymentType(model.getDeploymentType());
            }
            if (model.wasPropertyExplicitlySet("isCluster")) {
                this.isCluster(model.getIsCluster());
            }
            if (model.wasPropertyExplicitlySet("workloadType")) {
                this.workloadType(model.getWorkloadType());
            }
            if (model.wasPropertyExplicitlySet("jobId")) {
                this.jobId(model.getJobId());
            }
            if (model.wasPropertyExplicitlySet("jobName")) {
                this.jobName(model.getJobName());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeCompleted")) {
                this.timeCompleted(model.getTimeCompleted());
            }
            return this;
        }
    }
}

