/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.MySqlDatabaseStatus;
import com.oracle.bmc.databasemanagement.model.MySqlFleetMetricDefinition;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MySqlDatabaseUsageMetrics
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="databaseName")
    private final String databaseName;
    @JsonProperty(value="databaseType")
    private final String databaseType;
    @JsonProperty(value="mdsDeploymentType")
    private final String mdsDeploymentType;
    @JsonProperty(value="mdslifecycleState")
    private final String mdslifecycleState;
    @JsonProperty(value="databaseVersion")
    private final String databaseVersion;
    @JsonProperty(value="dbId")
    private final String dbId;
    @JsonProperty(value="databaseStatus")
    private final MySqlDatabaseStatus databaseStatus;
    @JsonProperty(value="isHeatWaveEnabled")
    private final Boolean isHeatWaveEnabled;
    @JsonProperty(value="heatWaveClusterDisplayName")
    private final String heatWaveClusterDisplayName;
    @JsonProperty(value="heatWaveNodeCount")
    private final Integer heatWaveNodeCount;
    @JsonProperty(value="metrics")
    private final List<MySqlFleetMetricDefinition> metrics;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "databaseName", "databaseType", "mdsDeploymentType", "mdslifecycleState", "databaseVersion", "dbId", "databaseStatus", "isHeatWaveEnabled", "heatWaveClusterDisplayName", "heatWaveNodeCount", "metrics"})
    public MySqlDatabaseUsageMetrics(String compartmentId, String databaseName, String databaseType, String mdsDeploymentType, String mdslifecycleState, String databaseVersion, String dbId, MySqlDatabaseStatus databaseStatus, Boolean isHeatWaveEnabled, String heatWaveClusterDisplayName, Integer heatWaveNodeCount, List<MySqlFleetMetricDefinition> metrics) {
        this.compartmentId = compartmentId;
        this.databaseName = databaseName;
        this.databaseType = databaseType;
        this.mdsDeploymentType = mdsDeploymentType;
        this.mdslifecycleState = mdslifecycleState;
        this.databaseVersion = databaseVersion;
        this.dbId = dbId;
        this.databaseStatus = databaseStatus;
        this.isHeatWaveEnabled = isHeatWaveEnabled;
        this.heatWaveClusterDisplayName = heatWaveClusterDisplayName;
        this.heatWaveNodeCount = heatWaveNodeCount;
        this.metrics = metrics;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public String getMdsDeploymentType() {
        return this.mdsDeploymentType;
    }

    public String getMdslifecycleState() {
        return this.mdslifecycleState;
    }

    public String getDatabaseVersion() {
        return this.databaseVersion;
    }

    public String getDbId() {
        return this.dbId;
    }

    public MySqlDatabaseStatus getDatabaseStatus() {
        return this.databaseStatus;
    }

    public Boolean getIsHeatWaveEnabled() {
        return this.isHeatWaveEnabled;
    }

    public String getHeatWaveClusterDisplayName() {
        return this.heatWaveClusterDisplayName;
    }

    public Integer getHeatWaveNodeCount() {
        return this.heatWaveNodeCount;
    }

    public List<MySqlFleetMetricDefinition> getMetrics() {
        return this.metrics;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MySqlDatabaseUsageMetrics(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", databaseName=").append(String.valueOf(this.databaseName));
        sb.append(", databaseType=").append(String.valueOf(this.databaseType));
        sb.append(", mdsDeploymentType=").append(String.valueOf(this.mdsDeploymentType));
        sb.append(", mdslifecycleState=").append(String.valueOf(this.mdslifecycleState));
        sb.append(", databaseVersion=").append(String.valueOf(this.databaseVersion));
        sb.append(", dbId=").append(String.valueOf(this.dbId));
        sb.append(", databaseStatus=").append(String.valueOf((Object)this.databaseStatus));
        sb.append(", isHeatWaveEnabled=").append(String.valueOf(this.isHeatWaveEnabled));
        sb.append(", heatWaveClusterDisplayName=").append(String.valueOf(this.heatWaveClusterDisplayName));
        sb.append(", heatWaveNodeCount=").append(String.valueOf(this.heatWaveNodeCount));
        sb.append(", metrics=").append(String.valueOf(this.metrics));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MySqlDatabaseUsageMetrics)) {
            return false;
        }
        MySqlDatabaseUsageMetrics other = (MySqlDatabaseUsageMetrics)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.databaseName, other.databaseName) && Objects.equals(this.databaseType, other.databaseType) && Objects.equals(this.mdsDeploymentType, other.mdsDeploymentType) && Objects.equals(this.mdslifecycleState, other.mdslifecycleState) && Objects.equals(this.databaseVersion, other.databaseVersion) && Objects.equals(this.dbId, other.dbId) && Objects.equals((Object)this.databaseStatus, (Object)other.databaseStatus) && Objects.equals(this.isHeatWaveEnabled, other.isHeatWaveEnabled) && Objects.equals(this.heatWaveClusterDisplayName, other.heatWaveClusterDisplayName) && Objects.equals(this.heatWaveNodeCount, other.heatWaveNodeCount) && Objects.equals(this.metrics, other.metrics) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.databaseName == null ? 43 : this.databaseName.hashCode());
        result = result * 59 + (this.databaseType == null ? 43 : this.databaseType.hashCode());
        result = result * 59 + (this.mdsDeploymentType == null ? 43 : this.mdsDeploymentType.hashCode());
        result = result * 59 + (this.mdslifecycleState == null ? 43 : this.mdslifecycleState.hashCode());
        result = result * 59 + (this.databaseVersion == null ? 43 : this.databaseVersion.hashCode());
        result = result * 59 + (this.dbId == null ? 43 : this.dbId.hashCode());
        result = result * 59 + (this.databaseStatus == null ? 43 : this.databaseStatus.hashCode());
        result = result * 59 + (this.isHeatWaveEnabled == null ? 43 : this.isHeatWaveEnabled.hashCode());
        result = result * 59 + (this.heatWaveClusterDisplayName == null ? 43 : this.heatWaveClusterDisplayName.hashCode());
        result = result * 59 + (this.heatWaveNodeCount == null ? 43 : this.heatWaveNodeCount.hashCode());
        result = result * 59 + (this.metrics == null ? 43 : this.metrics.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="databaseName")
        private String databaseName;
        @JsonProperty(value="databaseType")
        private String databaseType;
        @JsonProperty(value="mdsDeploymentType")
        private String mdsDeploymentType;
        @JsonProperty(value="mdslifecycleState")
        private String mdslifecycleState;
        @JsonProperty(value="databaseVersion")
        private String databaseVersion;
        @JsonProperty(value="dbId")
        private String dbId;
        @JsonProperty(value="databaseStatus")
        private MySqlDatabaseStatus databaseStatus;
        @JsonProperty(value="isHeatWaveEnabled")
        private Boolean isHeatWaveEnabled;
        @JsonProperty(value="heatWaveClusterDisplayName")
        private String heatWaveClusterDisplayName;
        @JsonProperty(value="heatWaveNodeCount")
        private Integer heatWaveNodeCount;
        @JsonProperty(value="metrics")
        private List<MySqlFleetMetricDefinition> metrics;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            this.__explicitlySet__.add("databaseName");
            return this;
        }

        public Builder databaseType(String databaseType) {
            this.databaseType = databaseType;
            this.__explicitlySet__.add("databaseType");
            return this;
        }

        public Builder mdsDeploymentType(String mdsDeploymentType) {
            this.mdsDeploymentType = mdsDeploymentType;
            this.__explicitlySet__.add("mdsDeploymentType");
            return this;
        }

        public Builder mdslifecycleState(String mdslifecycleState) {
            this.mdslifecycleState = mdslifecycleState;
            this.__explicitlySet__.add("mdslifecycleState");
            return this;
        }

        public Builder databaseVersion(String databaseVersion) {
            this.databaseVersion = databaseVersion;
            this.__explicitlySet__.add("databaseVersion");
            return this;
        }

        public Builder dbId(String dbId) {
            this.dbId = dbId;
            this.__explicitlySet__.add("dbId");
            return this;
        }

        public Builder databaseStatus(MySqlDatabaseStatus databaseStatus) {
            this.databaseStatus = databaseStatus;
            this.__explicitlySet__.add("databaseStatus");
            return this;
        }

        public Builder isHeatWaveEnabled(Boolean isHeatWaveEnabled) {
            this.isHeatWaveEnabled = isHeatWaveEnabled;
            this.__explicitlySet__.add("isHeatWaveEnabled");
            return this;
        }

        public Builder heatWaveClusterDisplayName(String heatWaveClusterDisplayName) {
            this.heatWaveClusterDisplayName = heatWaveClusterDisplayName;
            this.__explicitlySet__.add("heatWaveClusterDisplayName");
            return this;
        }

        public Builder heatWaveNodeCount(Integer heatWaveNodeCount) {
            this.heatWaveNodeCount = heatWaveNodeCount;
            this.__explicitlySet__.add("heatWaveNodeCount");
            return this;
        }

        public Builder metrics(List<MySqlFleetMetricDefinition> metrics) {
            this.metrics = metrics;
            this.__explicitlySet__.add("metrics");
            return this;
        }

        public MySqlDatabaseUsageMetrics build() {
            MySqlDatabaseUsageMetrics model = new MySqlDatabaseUsageMetrics(this.compartmentId, this.databaseName, this.databaseType, this.mdsDeploymentType, this.mdslifecycleState, this.databaseVersion, this.dbId, this.databaseStatus, this.isHeatWaveEnabled, this.heatWaveClusterDisplayName, this.heatWaveNodeCount, this.metrics);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MySqlDatabaseUsageMetrics model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("databaseName")) {
                this.databaseName(model.getDatabaseName());
            }
            if (model.wasPropertyExplicitlySet("databaseType")) {
                this.databaseType(model.getDatabaseType());
            }
            if (model.wasPropertyExplicitlySet("mdsDeploymentType")) {
                this.mdsDeploymentType(model.getMdsDeploymentType());
            }
            if (model.wasPropertyExplicitlySet("mdslifecycleState")) {
                this.mdslifecycleState(model.getMdslifecycleState());
            }
            if (model.wasPropertyExplicitlySet("databaseVersion")) {
                this.databaseVersion(model.getDatabaseVersion());
            }
            if (model.wasPropertyExplicitlySet("dbId")) {
                this.dbId(model.getDbId());
            }
            if (model.wasPropertyExplicitlySet("databaseStatus")) {
                this.databaseStatus(model.getDatabaseStatus());
            }
            if (model.wasPropertyExplicitlySet("isHeatWaveEnabled")) {
                this.isHeatWaveEnabled(model.getIsHeatWaveEnabled());
            }
            if (model.wasPropertyExplicitlySet("heatWaveClusterDisplayName")) {
                this.heatWaveClusterDisplayName(model.getHeatWaveClusterDisplayName());
            }
            if (model.wasPropertyExplicitlySet("heatWaveNodeCount")) {
                this.heatWaveNodeCount(model.getHeatWaveNodeCount());
            }
            if (model.wasPropertyExplicitlySet("metrics")) {
                this.metrics(model.getMetrics());
            }
            return this;
        }
    }
}

