/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MySqlFleetByCategory
extends ExplicitlySetBmcModel {
    @JsonProperty(value="databaseType")
    private final String databaseType;
    @JsonProperty(value="mdsDeploymentType")
    private final String mdsDeploymentType;
    @JsonProperty(value="inventoryCount")
    private final Integer inventoryCount;

    @Deprecated
    @ConstructorProperties(value={"databaseType", "mdsDeploymentType", "inventoryCount"})
    public MySqlFleetByCategory(String databaseType, String mdsDeploymentType, Integer inventoryCount) {
        this.databaseType = databaseType;
        this.mdsDeploymentType = mdsDeploymentType;
        this.inventoryCount = inventoryCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public String getMdsDeploymentType() {
        return this.mdsDeploymentType;
    }

    public Integer getInventoryCount() {
        return this.inventoryCount;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MySqlFleetByCategory(");
        sb.append("super=").append(super.toString());
        sb.append("databaseType=").append(String.valueOf(this.databaseType));
        sb.append(", mdsDeploymentType=").append(String.valueOf(this.mdsDeploymentType));
        sb.append(", inventoryCount=").append(String.valueOf(this.inventoryCount));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MySqlFleetByCategory)) {
            return false;
        }
        MySqlFleetByCategory other = (MySqlFleetByCategory)((Object)o);
        return Objects.equals(this.databaseType, other.databaseType) && Objects.equals(this.mdsDeploymentType, other.mdsDeploymentType) && Objects.equals(this.inventoryCount, other.inventoryCount) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.databaseType == null ? 43 : this.databaseType.hashCode());
        result = result * 59 + (this.mdsDeploymentType == null ? 43 : this.mdsDeploymentType.hashCode());
        result = result * 59 + (this.inventoryCount == null ? 43 : this.inventoryCount.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="databaseType")
        private String databaseType;
        @JsonProperty(value="mdsDeploymentType")
        private String mdsDeploymentType;
        @JsonProperty(value="inventoryCount")
        private Integer inventoryCount;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder databaseType(String databaseType) {
            this.databaseType = databaseType;
            this.__explicitlySet__.add("databaseType");
            return this;
        }

        public Builder mdsDeploymentType(String mdsDeploymentType) {
            this.mdsDeploymentType = mdsDeploymentType;
            this.__explicitlySet__.add("mdsDeploymentType");
            return this;
        }

        public Builder inventoryCount(Integer inventoryCount) {
            this.inventoryCount = inventoryCount;
            this.__explicitlySet__.add("inventoryCount");
            return this;
        }

        public MySqlFleetByCategory build() {
            MySqlFleetByCategory model = new MySqlFleetByCategory(this.databaseType, this.mdsDeploymentType, this.inventoryCount);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MySqlFleetByCategory model) {
            if (model.wasPropertyExplicitlySet("databaseType")) {
                this.databaseType(model.getDatabaseType());
            }
            if (model.wasPropertyExplicitlySet("mdsDeploymentType")) {
                this.mdsDeploymentType(model.getMdsDeploymentType());
            }
            if (model.wasPropertyExplicitlySet("inventoryCount")) {
                this.inventoryCount(model.getInventoryCount());
            }
            return this;
        }
    }
}

