/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class OptimizerStatisticsCollectionOperationSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final Integer id;
    @JsonProperty(value="operationName")
    private final String operationName;
    @JsonProperty(value="target")
    private final String target;
    @JsonProperty(value="jobName")
    private final String jobName;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="startTime")
    private final String startTime;
    @JsonProperty(value="endTime")
    private final String endTime;
    @JsonProperty(value="durationInSeconds")
    private final BigDecimal durationInSeconds;
    @JsonProperty(value="completedCount")
    private final Integer completedCount;
    @JsonProperty(value="inProgressCount")
    private final Integer inProgressCount;
    @JsonProperty(value="failedCount")
    private final Integer failedCount;
    @JsonProperty(value="timedOutCount")
    private final Integer timedOutCount;
    @JsonProperty(value="totalObjectsCount")
    private final Integer totalObjectsCount;

    @Deprecated
    @ConstructorProperties(value={"id", "operationName", "target", "jobName", "status", "startTime", "endTime", "durationInSeconds", "completedCount", "inProgressCount", "failedCount", "timedOutCount", "totalObjectsCount"})
    public OptimizerStatisticsCollectionOperationSummary(Integer id, String operationName, String target, String jobName, Status status, String startTime, String endTime, BigDecimal durationInSeconds, Integer completedCount, Integer inProgressCount, Integer failedCount, Integer timedOutCount, Integer totalObjectsCount) {
        this.id = id;
        this.operationName = operationName;
        this.target = target;
        this.jobName = jobName;
        this.status = status;
        this.startTime = startTime;
        this.endTime = endTime;
        this.durationInSeconds = durationInSeconds;
        this.completedCount = completedCount;
        this.inProgressCount = inProgressCount;
        this.failedCount = failedCount;
        this.timedOutCount = timedOutCount;
        this.totalObjectsCount = totalObjectsCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getId() {
        return this.id;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public String getTarget() {
        return this.target;
    }

    public String getJobName() {
        return this.jobName;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public BigDecimal getDurationInSeconds() {
        return this.durationInSeconds;
    }

    public Integer getCompletedCount() {
        return this.completedCount;
    }

    public Integer getInProgressCount() {
        return this.inProgressCount;
    }

    public Integer getFailedCount() {
        return this.failedCount;
    }

    public Integer getTimedOutCount() {
        return this.timedOutCount;
    }

    public Integer getTotalObjectsCount() {
        return this.totalObjectsCount;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OptimizerStatisticsCollectionOperationSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", operationName=").append(String.valueOf(this.operationName));
        sb.append(", target=").append(String.valueOf(this.target));
        sb.append(", jobName=").append(String.valueOf(this.jobName));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", startTime=").append(String.valueOf(this.startTime));
        sb.append(", endTime=").append(String.valueOf(this.endTime));
        sb.append(", durationInSeconds=").append(String.valueOf(this.durationInSeconds));
        sb.append(", completedCount=").append(String.valueOf(this.completedCount));
        sb.append(", inProgressCount=").append(String.valueOf(this.inProgressCount));
        sb.append(", failedCount=").append(String.valueOf(this.failedCount));
        sb.append(", timedOutCount=").append(String.valueOf(this.timedOutCount));
        sb.append(", totalObjectsCount=").append(String.valueOf(this.totalObjectsCount));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OptimizerStatisticsCollectionOperationSummary)) {
            return false;
        }
        OptimizerStatisticsCollectionOperationSummary other = (OptimizerStatisticsCollectionOperationSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.operationName, other.operationName) && Objects.equals(this.target, other.target) && Objects.equals(this.jobName, other.jobName) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.startTime, other.startTime) && Objects.equals(this.endTime, other.endTime) && Objects.equals(this.durationInSeconds, other.durationInSeconds) && Objects.equals(this.completedCount, other.completedCount) && Objects.equals(this.inProgressCount, other.inProgressCount) && Objects.equals(this.failedCount, other.failedCount) && Objects.equals(this.timedOutCount, other.timedOutCount) && Objects.equals(this.totalObjectsCount, other.totalObjectsCount) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.operationName == null ? 43 : this.operationName.hashCode());
        result = result * 59 + (this.target == null ? 43 : this.target.hashCode());
        result = result * 59 + (this.jobName == null ? 43 : this.jobName.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.startTime == null ? 43 : this.startTime.hashCode());
        result = result * 59 + (this.endTime == null ? 43 : this.endTime.hashCode());
        result = result * 59 + (this.durationInSeconds == null ? 43 : this.durationInSeconds.hashCode());
        result = result * 59 + (this.completedCount == null ? 43 : this.completedCount.hashCode());
        result = result * 59 + (this.inProgressCount == null ? 43 : this.inProgressCount.hashCode());
        result = result * 59 + (this.failedCount == null ? 43 : this.failedCount.hashCode());
        result = result * 59 + (this.timedOutCount == null ? 43 : this.timedOutCount.hashCode());
        result = result * 59 + (this.totalObjectsCount == null ? 43 : this.totalObjectsCount.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Status implements BmcEnum
    {
        InProgress("IN_PROGRESS"),
        Completed("COMPLETED"),
        Failed("FAILED"),
        TimedOut("TIMED_OUT"),
        Unknown("UNKNOWN"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private Integer id;
        @JsonProperty(value="operationName")
        private String operationName;
        @JsonProperty(value="target")
        private String target;
        @JsonProperty(value="jobName")
        private String jobName;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="startTime")
        private String startTime;
        @JsonProperty(value="endTime")
        private String endTime;
        @JsonProperty(value="durationInSeconds")
        private BigDecimal durationInSeconds;
        @JsonProperty(value="completedCount")
        private Integer completedCount;
        @JsonProperty(value="inProgressCount")
        private Integer inProgressCount;
        @JsonProperty(value="failedCount")
        private Integer failedCount;
        @JsonProperty(value="timedOutCount")
        private Integer timedOutCount;
        @JsonProperty(value="totalObjectsCount")
        private Integer totalObjectsCount;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(Integer id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder operationName(String operationName) {
            this.operationName = operationName;
            this.__explicitlySet__.add("operationName");
            return this;
        }

        public Builder target(String target) {
            this.target = target;
            this.__explicitlySet__.add("target");
            return this;
        }

        public Builder jobName(String jobName) {
            this.jobName = jobName;
            this.__explicitlySet__.add("jobName");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder startTime(String startTime) {
            this.startTime = startTime;
            this.__explicitlySet__.add("startTime");
            return this;
        }

        public Builder endTime(String endTime) {
            this.endTime = endTime;
            this.__explicitlySet__.add("endTime");
            return this;
        }

        public Builder durationInSeconds(BigDecimal durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
            this.__explicitlySet__.add("durationInSeconds");
            return this;
        }

        public Builder completedCount(Integer completedCount) {
            this.completedCount = completedCount;
            this.__explicitlySet__.add("completedCount");
            return this;
        }

        public Builder inProgressCount(Integer inProgressCount) {
            this.inProgressCount = inProgressCount;
            this.__explicitlySet__.add("inProgressCount");
            return this;
        }

        public Builder failedCount(Integer failedCount) {
            this.failedCount = failedCount;
            this.__explicitlySet__.add("failedCount");
            return this;
        }

        public Builder timedOutCount(Integer timedOutCount) {
            this.timedOutCount = timedOutCount;
            this.__explicitlySet__.add("timedOutCount");
            return this;
        }

        public Builder totalObjectsCount(Integer totalObjectsCount) {
            this.totalObjectsCount = totalObjectsCount;
            this.__explicitlySet__.add("totalObjectsCount");
            return this;
        }

        public OptimizerStatisticsCollectionOperationSummary build() {
            OptimizerStatisticsCollectionOperationSummary model = new OptimizerStatisticsCollectionOperationSummary(this.id, this.operationName, this.target, this.jobName, this.status, this.startTime, this.endTime, this.durationInSeconds, this.completedCount, this.inProgressCount, this.failedCount, this.timedOutCount, this.totalObjectsCount);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OptimizerStatisticsCollectionOperationSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("operationName")) {
                this.operationName(model.getOperationName());
            }
            if (model.wasPropertyExplicitlySet("target")) {
                this.target(model.getTarget());
            }
            if (model.wasPropertyExplicitlySet("jobName")) {
                this.jobName(model.getJobName());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("startTime")) {
                this.startTime(model.getStartTime());
            }
            if (model.wasPropertyExplicitlySet("endTime")) {
                this.endTime(model.getEndTime());
            }
            if (model.wasPropertyExplicitlySet("durationInSeconds")) {
                this.durationInSeconds(model.getDurationInSeconds());
            }
            if (model.wasPropertyExplicitlySet("completedCount")) {
                this.completedCount(model.getCompletedCount());
            }
            if (model.wasPropertyExplicitlySet("inProgressCount")) {
                this.inProgressCount(model.getInProgressCount());
            }
            if (model.wasPropertyExplicitlySet("failedCount")) {
                this.failedCount(model.getFailedCount());
            }
            if (model.wasPropertyExplicitlySet("timedOutCount")) {
                this.timedOutCount(model.getTimedOutCount());
            }
            if (model.wasPropertyExplicitlySet("totalObjectsCount")) {
                this.totalObjectsCount(model.getTotalObjectsCount());
            }
            return this;
        }
    }
}

