/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.Map;

public enum RankingMeasure implements BmcEnum
{
    ElapsedTime("ELAPSED_TIME"),
    CpuTime("CPU_TIME"),
    OptimizerCost("OPTIMIZER_COST"),
    BufferGets("BUFFER_GETS"),
    DiskReads("DISK_READS"),
    DirectWrites("DIRECT_WRITES");

    private final String value;
    private static Map<String, RankingMeasure> map;

    private RankingMeasure(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    @JsonCreator
    public static RankingMeasure create(String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        throw new IllegalArgumentException("Invalid RankingMeasure: " + key);
    }

    static {
        map = new HashMap<String, RankingMeasure>();
        for (RankingMeasure v : RankingMeasure.values()) {
            map.put(v.getValue(), v);
        }
    }
}

