/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SqlTuningSetAdminActionStatus
extends ExplicitlySetBmcModel {
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="successMessage")
    private final String successMessage;
    @JsonProperty(value="errorCode")
    private final Integer errorCode;
    @JsonProperty(value="errorMessage")
    private final String errorMessage;
    @JsonProperty(value="showSqlOnly")
    private final Integer showSqlOnly;
    @JsonProperty(value="sqlStatement")
    private final String sqlStatement;

    @Deprecated
    @ConstructorProperties(value={"status", "successMessage", "errorCode", "errorMessage", "showSqlOnly", "sqlStatement"})
    public SqlTuningSetAdminActionStatus(Status status, String successMessage, Integer errorCode, String errorMessage, Integer showSqlOnly, String sqlStatement) {
        this.status = status;
        this.successMessage = successMessage;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.showSqlOnly = showSqlOnly;
        this.sqlStatement = sqlStatement;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Status getStatus() {
        return this.status;
    }

    public String getSuccessMessage() {
        return this.successMessage;
    }

    public Integer getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Integer getShowSqlOnly() {
        return this.showSqlOnly;
    }

    public String getSqlStatement() {
        return this.sqlStatement;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SqlTuningSetAdminActionStatus(");
        sb.append("super=").append(super.toString());
        sb.append("status=").append(String.valueOf((Object)this.status));
        sb.append(", successMessage=").append(String.valueOf(this.successMessage));
        sb.append(", errorCode=").append(String.valueOf(this.errorCode));
        sb.append(", errorMessage=").append(String.valueOf(this.errorMessage));
        sb.append(", showSqlOnly=").append(String.valueOf(this.showSqlOnly));
        sb.append(", sqlStatement=").append(String.valueOf(this.sqlStatement));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SqlTuningSetAdminActionStatus)) {
            return false;
        }
        SqlTuningSetAdminActionStatus other = (SqlTuningSetAdminActionStatus)((Object)o);
        return Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.successMessage, other.successMessage) && Objects.equals(this.errorCode, other.errorCode) && Objects.equals(this.errorMessage, other.errorMessage) && Objects.equals(this.showSqlOnly, other.showSqlOnly) && Objects.equals(this.sqlStatement, other.sqlStatement) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.successMessage == null ? 43 : this.successMessage.hashCode());
        result = result * 59 + (this.errorCode == null ? 43 : this.errorCode.hashCode());
        result = result * 59 + (this.errorMessage == null ? 43 : this.errorMessage.hashCode());
        result = result * 59 + (this.showSqlOnly == null ? 43 : this.showSqlOnly.hashCode());
        result = result * 59 + (this.sqlStatement == null ? 43 : this.sqlStatement.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Status implements BmcEnum
    {
        Succeeded("SUCCEEDED"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="successMessage")
        private String successMessage;
        @JsonProperty(value="errorCode")
        private Integer errorCode;
        @JsonProperty(value="errorMessage")
        private String errorMessage;
        @JsonProperty(value="showSqlOnly")
        private Integer showSqlOnly;
        @JsonProperty(value="sqlStatement")
        private String sqlStatement;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder successMessage(String successMessage) {
            this.successMessage = successMessage;
            this.__explicitlySet__.add("successMessage");
            return this;
        }

        public Builder errorCode(Integer errorCode) {
            this.errorCode = errorCode;
            this.__explicitlySet__.add("errorCode");
            return this;
        }

        public Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            this.__explicitlySet__.add("errorMessage");
            return this;
        }

        public Builder showSqlOnly(Integer showSqlOnly) {
            this.showSqlOnly = showSqlOnly;
            this.__explicitlySet__.add("showSqlOnly");
            return this;
        }

        public Builder sqlStatement(String sqlStatement) {
            this.sqlStatement = sqlStatement;
            this.__explicitlySet__.add("sqlStatement");
            return this;
        }

        public SqlTuningSetAdminActionStatus build() {
            SqlTuningSetAdminActionStatus model = new SqlTuningSetAdminActionStatus(this.status, this.successMessage, this.errorCode, this.errorMessage, this.showSqlOnly, this.sqlStatement);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SqlTuningSetAdminActionStatus model) {
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("successMessage")) {
                this.successMessage(model.getSuccessMessage());
            }
            if (model.wasPropertyExplicitlySet("errorCode")) {
                this.errorCode(model.getErrorCode());
            }
            if (model.wasPropertyExplicitlySet("errorMessage")) {
                this.errorMessage(model.getErrorMessage());
            }
            if (model.wasPropertyExplicitlySet("showSqlOnly")) {
                this.showSqlOnly(model.getShowSqlOnly());
            }
            if (model.wasPropertyExplicitlySet("sqlStatement")) {
                this.sqlStatement(model.getSqlStatement());
            }
            return this;
        }
    }
}

