/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.databasemanagement.model.ChangeDatabaseParametersDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ChangeDatabaseParametersRequest
extends BmcRequest<ChangeDatabaseParametersDetails> {
    private String managedDatabaseId;
    private ChangeDatabaseParametersDetails changeDatabaseParametersDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public String getManagedDatabaseId() {
        return this.managedDatabaseId;
    }

    public ChangeDatabaseParametersDetails getChangeDatabaseParametersDetails() {
        return this.changeDatabaseParametersDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public ChangeDatabaseParametersDetails getBody$() {
        return this.changeDatabaseParametersDetails;
    }

    public Builder toBuilder() {
        return new Builder().managedDatabaseId(this.managedDatabaseId).changeDatabaseParametersDetails(this.changeDatabaseParametersDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",managedDatabaseId=").append(String.valueOf(this.managedDatabaseId));
        sb.append(",changeDatabaseParametersDetails=").append(String.valueOf((Object)this.changeDatabaseParametersDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangeDatabaseParametersRequest)) {
            return false;
        }
        ChangeDatabaseParametersRequest other = (ChangeDatabaseParametersRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.managedDatabaseId, other.managedDatabaseId) && Objects.equals((Object)this.changeDatabaseParametersDetails, (Object)other.changeDatabaseParametersDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.managedDatabaseId == null ? 43 : this.managedDatabaseId.hashCode());
        result = result * 59 + (this.changeDatabaseParametersDetails == null ? 43 : this.changeDatabaseParametersDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ChangeDatabaseParametersRequest, ChangeDatabaseParametersDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String managedDatabaseId = null;
        private ChangeDatabaseParametersDetails changeDatabaseParametersDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder managedDatabaseId(String managedDatabaseId) {
            this.managedDatabaseId = managedDatabaseId;
            return this;
        }

        public Builder changeDatabaseParametersDetails(ChangeDatabaseParametersDetails changeDatabaseParametersDetails) {
            this.changeDatabaseParametersDetails = changeDatabaseParametersDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ChangeDatabaseParametersRequest o) {
            this.managedDatabaseId(o.getManagedDatabaseId());
            this.changeDatabaseParametersDetails(o.getChangeDatabaseParametersDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ChangeDatabaseParametersRequest build() {
            ChangeDatabaseParametersRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ChangeDatabaseParametersDetails body) {
            this.changeDatabaseParametersDetails(body);
            return this;
        }

        public ChangeDatabaseParametersRequest buildWithoutInvocationCallback() {
            ChangeDatabaseParametersRequest request = new ChangeDatabaseParametersRequest();
            request.managedDatabaseId = this.managedDatabaseId;
            request.changeDatabaseParametersDetails = this.changeDatabaseParametersDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

