/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CheckExternalDbSystemConnectorConnectionStatusRequest
extends BmcRequest<Void> {
    private String externalDbSystemConnectorId;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;

    public String getExternalDbSystemConnectorId() {
        return this.externalDbSystemConnectorId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public Builder toBuilder() {
        return new Builder().externalDbSystemConnectorId(this.externalDbSystemConnectorId).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",externalDbSystemConnectorId=").append(String.valueOf(this.externalDbSystemConnectorId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CheckExternalDbSystemConnectorConnectionStatusRequest)) {
            return false;
        }
        CheckExternalDbSystemConnectorConnectionStatusRequest other = (CheckExternalDbSystemConnectorConnectionStatusRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.externalDbSystemConnectorId, other.externalDbSystemConnectorId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.externalDbSystemConnectorId == null ? 43 : this.externalDbSystemConnectorId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CheckExternalDbSystemConnectorConnectionStatusRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String externalDbSystemConnectorId = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder externalDbSystemConnectorId(String externalDbSystemConnectorId) {
            this.externalDbSystemConnectorId = externalDbSystemConnectorId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CheckExternalDbSystemConnectorConnectionStatusRequest o) {
            this.externalDbSystemConnectorId(o.getExternalDbSystemConnectorId());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CheckExternalDbSystemConnectorConnectionStatusRequest build() {
            CheckExternalDbSystemConnectorConnectionStatusRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public CheckExternalDbSystemConnectorConnectionStatusRequest buildWithoutInvocationCallback() {
            CheckExternalDbSystemConnectorConnectionStatusRequest request = new CheckExternalDbSystemConnectorConnectionStatusRequest();
            request.externalDbSystemConnectorId = this.externalDbSystemConnectorId;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

