/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetExternalDbSystemConnectorRequest
extends BmcRequest<Void> {
    private String externalDbSystemConnectorId;
    private String opcRequestId;

    public String getExternalDbSystemConnectorId() {
        return this.externalDbSystemConnectorId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().externalDbSystemConnectorId(this.externalDbSystemConnectorId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",externalDbSystemConnectorId=").append(String.valueOf(this.externalDbSystemConnectorId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetExternalDbSystemConnectorRequest)) {
            return false;
        }
        GetExternalDbSystemConnectorRequest other = (GetExternalDbSystemConnectorRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.externalDbSystemConnectorId, other.externalDbSystemConnectorId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.externalDbSystemConnectorId == null ? 43 : this.externalDbSystemConnectorId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetExternalDbSystemConnectorRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String externalDbSystemConnectorId = null;
        private String opcRequestId = null;

        public Builder externalDbSystemConnectorId(String externalDbSystemConnectorId) {
            this.externalDbSystemConnectorId = externalDbSystemConnectorId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetExternalDbSystemConnectorRequest o) {
            this.externalDbSystemConnectorId(o.getExternalDbSystemConnectorId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetExternalDbSystemConnectorRequest build() {
            GetExternalDbSystemConnectorRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetExternalDbSystemConnectorRequest buildWithoutInvocationCallback() {
            GetExternalDbSystemConnectorRequest request = new GetExternalDbSystemConnectorRequest();
            request.externalDbSystemConnectorId = this.externalDbSystemConnectorId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

