/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.oracle.bmc.databasemanagement.model.HeatWaveClusterStatus;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetHeatWaveFleetMetricRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String startTime;
    private String endTime;
    private String opcRequestId;
    private String filterByMetricNames;
    private HeatWaveClusterStatus filterByHeatWaveStatus;
    private String filterByHeatWaveShape;
    private Boolean isHeatWaveLakehouseEnabled;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getFilterByMetricNames() {
        return this.filterByMetricNames;
    }

    public HeatWaveClusterStatus getFilterByHeatWaveStatus() {
        return this.filterByHeatWaveStatus;
    }

    public String getFilterByHeatWaveShape() {
        return this.filterByHeatWaveShape;
    }

    public Boolean getIsHeatWaveLakehouseEnabled() {
        return this.isHeatWaveLakehouseEnabled;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).startTime(this.startTime).endTime(this.endTime).opcRequestId(this.opcRequestId).filterByMetricNames(this.filterByMetricNames).filterByHeatWaveStatus(this.filterByHeatWaveStatus).filterByHeatWaveShape(this.filterByHeatWaveShape).isHeatWaveLakehouseEnabled(this.isHeatWaveLakehouseEnabled);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",startTime=").append(String.valueOf(this.startTime));
        sb.append(",endTime=").append(String.valueOf(this.endTime));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",filterByMetricNames=").append(String.valueOf(this.filterByMetricNames));
        sb.append(",filterByHeatWaveStatus=").append(String.valueOf((Object)this.filterByHeatWaveStatus));
        sb.append(",filterByHeatWaveShape=").append(String.valueOf(this.filterByHeatWaveShape));
        sb.append(",isHeatWaveLakehouseEnabled=").append(String.valueOf(this.isHeatWaveLakehouseEnabled));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetHeatWaveFleetMetricRequest)) {
            return false;
        }
        GetHeatWaveFleetMetricRequest other = (GetHeatWaveFleetMetricRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.startTime, other.startTime) && Objects.equals(this.endTime, other.endTime) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.filterByMetricNames, other.filterByMetricNames) && Objects.equals((Object)this.filterByHeatWaveStatus, (Object)other.filterByHeatWaveStatus) && Objects.equals(this.filterByHeatWaveShape, other.filterByHeatWaveShape) && Objects.equals(this.isHeatWaveLakehouseEnabled, other.isHeatWaveLakehouseEnabled);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.startTime == null ? 43 : this.startTime.hashCode());
        result = result * 59 + (this.endTime == null ? 43 : this.endTime.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.filterByMetricNames == null ? 43 : this.filterByMetricNames.hashCode());
        result = result * 59 + (this.filterByHeatWaveStatus == null ? 43 : this.filterByHeatWaveStatus.hashCode());
        result = result * 59 + (this.filterByHeatWaveShape == null ? 43 : this.filterByHeatWaveShape.hashCode());
        result = result * 59 + (this.isHeatWaveLakehouseEnabled == null ? 43 : this.isHeatWaveLakehouseEnabled.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetHeatWaveFleetMetricRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String startTime = null;
        private String endTime = null;
        private String opcRequestId = null;
        private String filterByMetricNames = null;
        private HeatWaveClusterStatus filterByHeatWaveStatus = null;
        private String filterByHeatWaveShape = null;
        private Boolean isHeatWaveLakehouseEnabled = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder filterByMetricNames(String filterByMetricNames) {
            this.filterByMetricNames = filterByMetricNames;
            return this;
        }

        public Builder filterByHeatWaveStatus(HeatWaveClusterStatus filterByHeatWaveStatus) {
            this.filterByHeatWaveStatus = filterByHeatWaveStatus;
            return this;
        }

        public Builder filterByHeatWaveShape(String filterByHeatWaveShape) {
            this.filterByHeatWaveShape = filterByHeatWaveShape;
            return this;
        }

        public Builder isHeatWaveLakehouseEnabled(Boolean isHeatWaveLakehouseEnabled) {
            this.isHeatWaveLakehouseEnabled = isHeatWaveLakehouseEnabled;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetHeatWaveFleetMetricRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.startTime(o.getStartTime());
            this.endTime(o.getEndTime());
            this.opcRequestId(o.getOpcRequestId());
            this.filterByMetricNames(o.getFilterByMetricNames());
            this.filterByHeatWaveStatus(o.getFilterByHeatWaveStatus());
            this.filterByHeatWaveShape(o.getFilterByHeatWaveShape());
            this.isHeatWaveLakehouseEnabled(o.getIsHeatWaveLakehouseEnabled());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetHeatWaveFleetMetricRequest build() {
            GetHeatWaveFleetMetricRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetHeatWaveFleetMetricRequest buildWithoutInvocationCallback() {
            GetHeatWaveFleetMetricRequest request = new GetHeatWaveFleetMetricRequest();
            request.compartmentId = this.compartmentId;
            request.startTime = this.startTime;
            request.endTime = this.endTime;
            request.opcRequestId = this.opcRequestId;
            request.filterByMetricNames = this.filterByMetricNames;
            request.filterByHeatWaveStatus = this.filterByHeatWaveStatus;
            request.filterByHeatWaveShape = this.filterByHeatWaveShape;
            request.isHeatWaveLakehouseEnabled = this.isHeatWaveLakehouseEnabled;
            return request;
        }
    }
}

