/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.databasemanagement.model.TestNamedCredentialDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class TestNamedCredentialRequest
extends BmcRequest<TestNamedCredentialDetails> {
    private String namedCredentialId;
    private TestNamedCredentialDetails testNamedCredentialDetails;
    private String opcRequestId;

    public String getNamedCredentialId() {
        return this.namedCredentialId;
    }

    public TestNamedCredentialDetails getTestNamedCredentialDetails() {
        return this.testNamedCredentialDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public TestNamedCredentialDetails getBody$() {
        return this.testNamedCredentialDetails;
    }

    public Builder toBuilder() {
        return new Builder().namedCredentialId(this.namedCredentialId).testNamedCredentialDetails(this.testNamedCredentialDetails).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namedCredentialId=").append(String.valueOf(this.namedCredentialId));
        sb.append(",testNamedCredentialDetails=").append(String.valueOf((Object)this.testNamedCredentialDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TestNamedCredentialRequest)) {
            return false;
        }
        TestNamedCredentialRequest other = (TestNamedCredentialRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namedCredentialId, other.namedCredentialId) && Objects.equals((Object)this.testNamedCredentialDetails, (Object)other.testNamedCredentialDetails) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namedCredentialId == null ? 43 : this.namedCredentialId.hashCode());
        result = result * 59 + (this.testNamedCredentialDetails == null ? 43 : this.testNamedCredentialDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<TestNamedCredentialRequest, TestNamedCredentialDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namedCredentialId = null;
        private TestNamedCredentialDetails testNamedCredentialDetails = null;
        private String opcRequestId = null;

        public Builder namedCredentialId(String namedCredentialId) {
            this.namedCredentialId = namedCredentialId;
            return this;
        }

        public Builder testNamedCredentialDetails(TestNamedCredentialDetails testNamedCredentialDetails) {
            this.testNamedCredentialDetails = testNamedCredentialDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(TestNamedCredentialRequest o) {
            this.namedCredentialId(o.getNamedCredentialId());
            this.testNamedCredentialDetails(o.getTestNamedCredentialDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public TestNamedCredentialRequest build() {
            TestNamedCredentialRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(TestNamedCredentialDetails body) {
            this.testNamedCredentialDetails(body);
            return this;
        }

        public TestNamedCredentialRequest buildWithoutInvocationCallback() {
            TestNamedCredentialRequest request = new TestNamedCredentialRequest();
            request.namedCredentialId = this.namedCredentialId;
            request.testNamedCredentialDetails = this.testNamedCredentialDetails;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

