/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.databasemanagement.model.UpdateExternalDbSystemDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateExternalDbSystemRequest
extends BmcRequest<UpdateExternalDbSystemDetails> {
    private String externalDbSystemId;
    private UpdateExternalDbSystemDetails updateExternalDbSystemDetails;
    private String opcRequestId;
    private String ifMatch;

    public String getExternalDbSystemId() {
        return this.externalDbSystemId;
    }

    public UpdateExternalDbSystemDetails getUpdateExternalDbSystemDetails() {
        return this.updateExternalDbSystemDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateExternalDbSystemDetails getBody$() {
        return this.updateExternalDbSystemDetails;
    }

    public Builder toBuilder() {
        return new Builder().externalDbSystemId(this.externalDbSystemId).updateExternalDbSystemDetails(this.updateExternalDbSystemDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",externalDbSystemId=").append(String.valueOf(this.externalDbSystemId));
        sb.append(",updateExternalDbSystemDetails=").append(String.valueOf((Object)this.updateExternalDbSystemDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateExternalDbSystemRequest)) {
            return false;
        }
        UpdateExternalDbSystemRequest other = (UpdateExternalDbSystemRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.externalDbSystemId, other.externalDbSystemId) && Objects.equals((Object)this.updateExternalDbSystemDetails, (Object)other.updateExternalDbSystemDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.externalDbSystemId == null ? 43 : this.externalDbSystemId.hashCode());
        result = result * 59 + (this.updateExternalDbSystemDetails == null ? 43 : this.updateExternalDbSystemDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateExternalDbSystemRequest, UpdateExternalDbSystemDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String externalDbSystemId = null;
        private UpdateExternalDbSystemDetails updateExternalDbSystemDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder externalDbSystemId(String externalDbSystemId) {
            this.externalDbSystemId = externalDbSystemId;
            return this;
        }

        public Builder updateExternalDbSystemDetails(UpdateExternalDbSystemDetails updateExternalDbSystemDetails) {
            this.updateExternalDbSystemDetails = updateExternalDbSystemDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateExternalDbSystemRequest o) {
            this.externalDbSystemId(o.getExternalDbSystemId());
            this.updateExternalDbSystemDetails(o.getUpdateExternalDbSystemDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateExternalDbSystemRequest build() {
            UpdateExternalDbSystemRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateExternalDbSystemDetails body) {
            this.updateExternalDbSystemDetails(body);
            return this;
        }

        public UpdateExternalDbSystemRequest buildWithoutInvocationCallback() {
            UpdateExternalDbSystemRequest request = new UpdateExternalDbSystemRequest();
            request.externalDbSystemId = this.externalDbSystemId;
            request.updateExternalDbSystemDetails = this.updateExternalDbSystemDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

