/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.databasemanagement.model.AwrDbCollection;
import com.oracle.bmc.databasemanagement.model.AwrDbCpuUsageCollection;
import com.oracle.bmc.databasemanagement.model.AwrDbMetricCollection;
import com.oracle.bmc.databasemanagement.model.AwrDbParameterChangeCollection;
import com.oracle.bmc.databasemanagement.model.AwrDbParameterCollection;
import com.oracle.bmc.databasemanagement.model.AwrDbReport;
import com.oracle.bmc.databasemanagement.model.AwrDbSnapshotCollection;
import com.oracle.bmc.databasemanagement.model.AwrDbSnapshotRangeCollection;
import com.oracle.bmc.databasemanagement.model.AwrDbSqlReport;
import com.oracle.bmc.databasemanagement.model.AwrDbSysstatCollection;
import com.oracle.bmc.databasemanagement.model.AwrDbTopWaitEventCollection;
import com.oracle.bmc.databasemanagement.model.AwrDbWaitEventBucketCollection;
import com.oracle.bmc.databasemanagement.model.AwrDbWaitEventCollection;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="awrResultType", defaultImpl=AwrQueryResult.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=AwrDbParameterChangeCollection.class, name="AWRDB_DB_PARAMETER_CHANGE"), @JsonSubTypes.Type(value=AwrDbCpuUsageCollection.class, name="AWRDB_ASH_CPU_USAGE_SET"), @JsonSubTypes.Type(value=AwrDbWaitEventBucketCollection.class, name="AWRDB_EVENT_HISTOGRAM_SET"), @JsonSubTypes.Type(value=AwrDbParameterCollection.class, name="AWRDB_DB_PARAMETER_SET"), @JsonSubTypes.Type(value=AwrDbSysstatCollection.class, name="AWRDB_SYSSTAT_SET"), @JsonSubTypes.Type(value=AwrDbTopWaitEventCollection.class, name="AWRDB_TOP_EVENT_SET"), @JsonSubTypes.Type(value=AwrDbSnapshotCollection.class, name="AWRDB_SNAPSHOT_SET"), @JsonSubTypes.Type(value=AwrDbCollection.class, name="AWRDB_SET"), @JsonSubTypes.Type(value=AwrDbSnapshotRangeCollection.class, name="AWRDB_SNAPSHOT_RANGE_SET"), @JsonSubTypes.Type(value=AwrDbReport.class, name="AWRDB_DB_REPORT"), @JsonSubTypes.Type(value=AwrDbMetricCollection.class, name="AWRDB_METRICS_SET"), @JsonSubTypes.Type(value=AwrDbWaitEventCollection.class, name="AWRDB_EVENT_SET"), @JsonSubTypes.Type(value=AwrDbSqlReport.class, name="AWRDB_SQL_REPORT")})
@JsonFilter(value="explicitlySetFilter")
public class AwrQueryResult
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="queryKey")
    private final String queryKey;
    @JsonProperty(value="dbQueryTimeInSecs")
    private final Double dbQueryTimeInSecs;

    @Deprecated
    @ConstructorProperties(value={"name", "version", "queryKey", "dbQueryTimeInSecs"})
    protected AwrQueryResult(String name, String version, String queryKey, Double dbQueryTimeInSecs) {
        this.name = name;
        this.version = version;
        this.queryKey = queryKey;
        this.dbQueryTimeInSecs = dbQueryTimeInSecs;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getQueryKey() {
        return this.queryKey;
    }

    public Double getDbQueryTimeInSecs() {
        return this.dbQueryTimeInSecs;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AwrQueryResult(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(", queryKey=").append(String.valueOf(this.queryKey));
        sb.append(", dbQueryTimeInSecs=").append(String.valueOf(this.dbQueryTimeInSecs));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AwrQueryResult)) {
            return false;
        }
        AwrQueryResult other = (AwrQueryResult)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.version, other.version) && Objects.equals(this.queryKey, other.queryKey) && Objects.equals(this.dbQueryTimeInSecs, other.dbQueryTimeInSecs) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.queryKey == null ? 43 : this.queryKey.hashCode());
        result = result * 59 + (this.dbQueryTimeInSecs == null ? 43 : this.dbQueryTimeInSecs.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum AwrResultType implements BmcEnum
    {
        AwrdbSet("AWRDB_SET"),
        AwrdbSnapshotRangeSet("AWRDB_SNAPSHOT_RANGE_SET"),
        AwrdbSnapshotSet("AWRDB_SNAPSHOT_SET"),
        AwrdbMetricsSet("AWRDB_METRICS_SET"),
        AwrdbSysstatSet("AWRDB_SYSSTAT_SET"),
        AwrdbTopEventSet("AWRDB_TOP_EVENT_SET"),
        AwrdbEventSet("AWRDB_EVENT_SET"),
        AwrdbEventHistogram("AWRDB_EVENT_HISTOGRAM"),
        AwrdbDbParameterSet("AWRDB_DB_PARAMETER_SET"),
        AwrdbDbParameterChange("AWRDB_DB_PARAMETER_CHANGE"),
        AwrdbAshCpuUsageSet("AWRDB_ASH_CPU_USAGE_SET"),
        AwrdbDbReport("AWRDB_DB_REPORT"),
        AwrdbSqlReport("AWRDB_SQL_REPORT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, AwrResultType> map;

        private AwrResultType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AwrResultType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'AwrResultType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(AwrResultType.class);
            map = new HashMap<String, AwrResultType>();
            for (AwrResultType v : AwrResultType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

