/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.ChangeDatabaseParameterDetails;
import com.oracle.bmc.databasemanagement.model.DatabaseCredentialDetails;
import com.oracle.bmc.databasemanagement.model.DatabaseCredentials;
import com.oracle.bmc.databasemanagement.model.ParameterScope;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ChangeDatabaseParametersDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="credentials")
    private final DatabaseCredentials credentials;
    @JsonProperty(value="databaseCredential")
    private final DatabaseCredentialDetails databaseCredential;
    @JsonProperty(value="scope")
    private final ParameterScope scope;
    @JsonProperty(value="parameters")
    private final List<ChangeDatabaseParameterDetails> parameters;

    @Deprecated
    @ConstructorProperties(value={"credentials", "databaseCredential", "scope", "parameters"})
    public ChangeDatabaseParametersDetails(DatabaseCredentials credentials, DatabaseCredentialDetails databaseCredential, ParameterScope scope, List<ChangeDatabaseParameterDetails> parameters) {
        this.credentials = credentials;
        this.databaseCredential = databaseCredential;
        this.scope = scope;
        this.parameters = parameters;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public DatabaseCredentials getCredentials() {
        return this.credentials;
    }

    public DatabaseCredentialDetails getDatabaseCredential() {
        return this.databaseCredential;
    }

    public ParameterScope getScope() {
        return this.scope;
    }

    public List<ChangeDatabaseParameterDetails> getParameters() {
        return this.parameters;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ChangeDatabaseParametersDetails(");
        sb.append("super=").append(super.toString());
        sb.append("credentials=").append(String.valueOf((Object)this.credentials));
        sb.append(", databaseCredential=").append(String.valueOf((Object)this.databaseCredential));
        sb.append(", scope=").append(String.valueOf((Object)this.scope));
        sb.append(", parameters=").append(String.valueOf(this.parameters));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangeDatabaseParametersDetails)) {
            return false;
        }
        ChangeDatabaseParametersDetails other = (ChangeDatabaseParametersDetails)((Object)o);
        return Objects.equals((Object)this.credentials, (Object)other.credentials) && Objects.equals((Object)this.databaseCredential, (Object)other.databaseCredential) && Objects.equals((Object)this.scope, (Object)other.scope) && Objects.equals(this.parameters, other.parameters) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.credentials == null ? 43 : this.credentials.hashCode());
        result = result * 59 + (this.databaseCredential == null ? 43 : this.databaseCredential.hashCode());
        result = result * 59 + (this.scope == null ? 43 : this.scope.hashCode());
        result = result * 59 + (this.parameters == null ? 43 : this.parameters.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="credentials")
        private DatabaseCredentials credentials;
        @JsonProperty(value="databaseCredential")
        private DatabaseCredentialDetails databaseCredential;
        @JsonProperty(value="scope")
        private ParameterScope scope;
        @JsonProperty(value="parameters")
        private List<ChangeDatabaseParameterDetails> parameters;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder credentials(DatabaseCredentials credentials) {
            this.credentials = credentials;
            this.__explicitlySet__.add("credentials");
            return this;
        }

        public Builder databaseCredential(DatabaseCredentialDetails databaseCredential) {
            this.databaseCredential = databaseCredential;
            this.__explicitlySet__.add("databaseCredential");
            return this;
        }

        public Builder scope(ParameterScope scope) {
            this.scope = scope;
            this.__explicitlySet__.add("scope");
            return this;
        }

        public Builder parameters(List<ChangeDatabaseParameterDetails> parameters) {
            this.parameters = parameters;
            this.__explicitlySet__.add("parameters");
            return this;
        }

        public ChangeDatabaseParametersDetails build() {
            ChangeDatabaseParametersDetails model = new ChangeDatabaseParametersDetails(this.credentials, this.databaseCredential, this.scope, this.parameters);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ChangeDatabaseParametersDetails model) {
            if (model.wasPropertyExplicitlySet("credentials")) {
                this.credentials(model.getCredentials());
            }
            if (model.wasPropertyExplicitlySet("databaseCredential")) {
                this.databaseCredential(model.getDatabaseCredential());
            }
            if (model.wasPropertyExplicitlySet("scope")) {
                this.scope(model.getScope());
            }
            if (model.wasPropertyExplicitlySet("parameters")) {
                this.parameters(model.getParameters());
            }
            return this;
        }
    }
}

