/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateExternalExadataInfrastructureDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="discoveryKey")
    private final String discoveryKey;
    @JsonProperty(value="licenseModel")
    private final LicenseModel licenseModel;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="dbSystemIds")
    private final List<String> dbSystemIds;
    @JsonProperty(value="storageServerNames")
    private final List<String> storageServerNames;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"discoveryKey", "licenseModel", "compartmentId", "displayName", "dbSystemIds", "storageServerNames", "freeformTags", "definedTags"})
    public CreateExternalExadataInfrastructureDetails(String discoveryKey, LicenseModel licenseModel, String compartmentId, String displayName, List<String> dbSystemIds, List<String> storageServerNames, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.discoveryKey = discoveryKey;
        this.licenseModel = licenseModel;
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.dbSystemIds = dbSystemIds;
        this.storageServerNames = storageServerNames;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDiscoveryKey() {
        return this.discoveryKey;
    }

    public LicenseModel getLicenseModel() {
        return this.licenseModel;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<String> getDbSystemIds() {
        return this.dbSystemIds;
    }

    public List<String> getStorageServerNames() {
        return this.storageServerNames;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateExternalExadataInfrastructureDetails(");
        sb.append("super=").append(super.toString());
        sb.append("discoveryKey=").append(String.valueOf(this.discoveryKey));
        sb.append(", licenseModel=").append(String.valueOf((Object)this.licenseModel));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", dbSystemIds=").append(String.valueOf(this.dbSystemIds));
        sb.append(", storageServerNames=").append(String.valueOf(this.storageServerNames));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateExternalExadataInfrastructureDetails)) {
            return false;
        }
        CreateExternalExadataInfrastructureDetails other = (CreateExternalExadataInfrastructureDetails)((Object)o);
        return Objects.equals(this.discoveryKey, other.discoveryKey) && Objects.equals((Object)this.licenseModel, (Object)other.licenseModel) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.dbSystemIds, other.dbSystemIds) && Objects.equals(this.storageServerNames, other.storageServerNames) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.discoveryKey == null ? 43 : this.discoveryKey.hashCode());
        result = result * 59 + (this.licenseModel == null ? 43 : this.licenseModel.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.dbSystemIds == null ? 43 : this.dbSystemIds.hashCode());
        result = result * 59 + (this.storageServerNames == null ? 43 : this.storageServerNames.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LicenseModel implements BmcEnum
    {
        LicenseIncluded("LICENSE_INCLUDED"),
        BringYourOwnLicense("BRING_YOUR_OWN_LICENSE");

        private final String value;
        private static Map<String, LicenseModel> map;

        private LicenseModel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LicenseModel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid LicenseModel: " + key);
        }

        static {
            map = new HashMap<String, LicenseModel>();
            for (LicenseModel v : LicenseModel.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="discoveryKey")
        private String discoveryKey;
        @JsonProperty(value="licenseModel")
        private LicenseModel licenseModel;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="dbSystemIds")
        private List<String> dbSystemIds;
        @JsonProperty(value="storageServerNames")
        private List<String> storageServerNames;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder discoveryKey(String discoveryKey) {
            this.discoveryKey = discoveryKey;
            this.__explicitlySet__.add("discoveryKey");
            return this;
        }

        public Builder licenseModel(LicenseModel licenseModel) {
            this.licenseModel = licenseModel;
            this.__explicitlySet__.add("licenseModel");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder dbSystemIds(List<String> dbSystemIds) {
            this.dbSystemIds = dbSystemIds;
            this.__explicitlySet__.add("dbSystemIds");
            return this;
        }

        public Builder storageServerNames(List<String> storageServerNames) {
            this.storageServerNames = storageServerNames;
            this.__explicitlySet__.add("storageServerNames");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public CreateExternalExadataInfrastructureDetails build() {
            CreateExternalExadataInfrastructureDetails model = new CreateExternalExadataInfrastructureDetails(this.discoveryKey, this.licenseModel, this.compartmentId, this.displayName, this.dbSystemIds, this.storageServerNames, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateExternalExadataInfrastructureDetails model) {
            if (model.wasPropertyExplicitlySet("discoveryKey")) {
                this.discoveryKey(model.getDiscoveryKey());
            }
            if (model.wasPropertyExplicitlySet("licenseModel")) {
                this.licenseModel(model.getLicenseModel());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("dbSystemIds")) {
                this.dbSystemIds(model.getDbSystemIds());
            }
            if (model.wasPropertyExplicitlySet("storageServerNames")) {
                this.storageServerNames(model.getStorageServerNames());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

