/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.ConnectorDetails;
import com.oracle.bmc.databasemanagement.model.DatabaseConnectionDetails;
import com.oracle.bmc.databasemanagement.model.DatabaseFeatureConfiguration;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="feature")
@JsonFilter(value="explicitlySetFilter")
public final class DatabaseLifecycleFeatureConfiguration
extends DatabaseFeatureConfiguration {
    @JsonProperty(value="licenseModel")
    private final LicenseModel licenseModel;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public DatabaseLifecycleFeatureConfiguration(DatabaseFeatureConfiguration.FeatureStatus featureStatus, ConnectorDetails connectorDetails, DatabaseConnectionDetails databaseConnectionDetails, LicenseModel licenseModel) {
        super(featureStatus, connectorDetails, databaseConnectionDetails);
        this.licenseModel = licenseModel;
    }

    public LicenseModel getLicenseModel() {
        return this.licenseModel;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DatabaseLifecycleFeatureConfiguration(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", licenseModel=").append(String.valueOf((Object)this.licenseModel));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DatabaseLifecycleFeatureConfiguration)) {
            return false;
        }
        DatabaseLifecycleFeatureConfiguration other = (DatabaseLifecycleFeatureConfiguration)((Object)o);
        return Objects.equals((Object)this.licenseModel, (Object)other.licenseModel) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.licenseModel == null ? 43 : this.licenseModel.hashCode());
        return result;
    }

    public static enum LicenseModel implements BmcEnum
    {
        LicenseIncluded("LICENSE_INCLUDED"),
        BringYourOwnLicense("BRING_YOUR_OWN_LICENSE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LicenseModel> map;

        private LicenseModel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LicenseModel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LicenseModel', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LicenseModel.class);
            map = new HashMap<String, LicenseModel>();
            for (LicenseModel v : LicenseModel.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="featureStatus")
        private DatabaseFeatureConfiguration.FeatureStatus featureStatus;
        @JsonProperty(value="connectorDetails")
        private ConnectorDetails connectorDetails;
        @JsonProperty(value="databaseConnectionDetails")
        private DatabaseConnectionDetails databaseConnectionDetails;
        @JsonProperty(value="licenseModel")
        private LicenseModel licenseModel;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder featureStatus(DatabaseFeatureConfiguration.FeatureStatus featureStatus) {
            this.featureStatus = featureStatus;
            this.__explicitlySet__.add("featureStatus");
            return this;
        }

        public Builder connectorDetails(ConnectorDetails connectorDetails) {
            this.connectorDetails = connectorDetails;
            this.__explicitlySet__.add("connectorDetails");
            return this;
        }

        public Builder databaseConnectionDetails(DatabaseConnectionDetails databaseConnectionDetails) {
            this.databaseConnectionDetails = databaseConnectionDetails;
            this.__explicitlySet__.add("databaseConnectionDetails");
            return this;
        }

        public Builder licenseModel(LicenseModel licenseModel) {
            this.licenseModel = licenseModel;
            this.__explicitlySet__.add("licenseModel");
            return this;
        }

        public DatabaseLifecycleFeatureConfiguration build() {
            DatabaseLifecycleFeatureConfiguration model = new DatabaseLifecycleFeatureConfiguration(this.featureStatus, this.connectorDetails, this.databaseConnectionDetails, this.licenseModel);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DatabaseLifecycleFeatureConfiguration model) {
            if (model.wasPropertyExplicitlySet("featureStatus")) {
                this.featureStatus(model.getFeatureStatus());
            }
            if (model.wasPropertyExplicitlySet("connectorDetails")) {
                this.connectorDetails(model.getConnectorDetails());
            }
            if (model.wasPropertyExplicitlySet("databaseConnectionDetails")) {
                this.databaseConnectionDetails(model.getDatabaseConnectionDetails());
            }
            if (model.wasPropertyExplicitlySet("licenseModel")) {
                this.licenseModel(model.getLicenseModel());
            }
            return this;
        }
    }
}

