/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.AssociatedComponent;
import com.oracle.bmc.databasemanagement.model.DiscoveredExternalDbSystemComponent;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="componentType")
@JsonFilter(value="explicitlySetFilter")
public final class DiscoveredExternalDbHome
extends DiscoveredExternalDbSystemComponent {
    @JsonProperty(value="homeDirectory")
    private final String homeDirectory;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public DiscoveredExternalDbHome(String componentId, String displayName, String componentName, String resourceId, Boolean isSelectedForMonitoring, DiscoveredExternalDbSystemComponent.Status status, List<AssociatedComponent> associatedComponents, String homeDirectory) {
        super(componentId, displayName, componentName, resourceId, isSelectedForMonitoring, status, associatedComponents);
        this.homeDirectory = homeDirectory;
    }

    public String getHomeDirectory() {
        return this.homeDirectory;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DiscoveredExternalDbHome(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", homeDirectory=").append(String.valueOf(this.homeDirectory));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DiscoveredExternalDbHome)) {
            return false;
        }
        DiscoveredExternalDbHome other = (DiscoveredExternalDbHome)((Object)o);
        return Objects.equals(this.homeDirectory, other.homeDirectory) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.homeDirectory == null ? 43 : this.homeDirectory.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="componentId")
        private String componentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="componentName")
        private String componentName;
        @JsonProperty(value="resourceId")
        private String resourceId;
        @JsonProperty(value="isSelectedForMonitoring")
        private Boolean isSelectedForMonitoring;
        @JsonProperty(value="status")
        private DiscoveredExternalDbSystemComponent.Status status;
        @JsonProperty(value="associatedComponents")
        private List<AssociatedComponent> associatedComponents;
        @JsonProperty(value="homeDirectory")
        private String homeDirectory;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder componentId(String componentId) {
            this.componentId = componentId;
            this.__explicitlySet__.add("componentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder componentName(String componentName) {
            this.componentName = componentName;
            this.__explicitlySet__.add("componentName");
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.__explicitlySet__.add("resourceId");
            return this;
        }

        public Builder isSelectedForMonitoring(Boolean isSelectedForMonitoring) {
            this.isSelectedForMonitoring = isSelectedForMonitoring;
            this.__explicitlySet__.add("isSelectedForMonitoring");
            return this;
        }

        public Builder status(DiscoveredExternalDbSystemComponent.Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder associatedComponents(List<AssociatedComponent> associatedComponents) {
            this.associatedComponents = associatedComponents;
            this.__explicitlySet__.add("associatedComponents");
            return this;
        }

        public Builder homeDirectory(String homeDirectory) {
            this.homeDirectory = homeDirectory;
            this.__explicitlySet__.add("homeDirectory");
            return this;
        }

        public DiscoveredExternalDbHome build() {
            DiscoveredExternalDbHome model = new DiscoveredExternalDbHome(this.componentId, this.displayName, this.componentName, this.resourceId, this.isSelectedForMonitoring, this.status, this.associatedComponents, this.homeDirectory);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DiscoveredExternalDbHome model) {
            if (model.wasPropertyExplicitlySet("componentId")) {
                this.componentId(model.getComponentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("componentName")) {
                this.componentName(model.getComponentName());
            }
            if (model.wasPropertyExplicitlySet("resourceId")) {
                this.resourceId(model.getResourceId());
            }
            if (model.wasPropertyExplicitlySet("isSelectedForMonitoring")) {
                this.isSelectedForMonitoring(model.getIsSelectedForMonitoring());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("associatedComponents")) {
                this.associatedComponents(model.getAssociatedComponents());
            }
            if (model.wasPropertyExplicitlySet("homeDirectory")) {
                this.homeDirectory(model.getHomeDirectory());
            }
            return this;
        }
    }
}

