/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ExternalAsmDiskGroupSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="mountingInstanceCount")
    private final Integer mountingInstanceCount;
    @JsonProperty(value="dismountingInstanceCount")
    private final Integer dismountingInstanceCount;
    @JsonProperty(value="redundancyType")
    private final RedundancyType redundancyType;
    @JsonProperty(value="isSparse")
    private final Boolean isSparse;
    @JsonProperty(value="databases")
    private final List<String> databases;
    @JsonProperty(value="totalSizeInMBs")
    private final Long totalSizeInMBs;
    @JsonProperty(value="usedSizeInMBs")
    private final Long usedSizeInMBs;
    @JsonProperty(value="usedPercent")
    private final Float usedPercent;

    @Deprecated
    @ConstructorProperties(value={"name", "mountingInstanceCount", "dismountingInstanceCount", "redundancyType", "isSparse", "databases", "totalSizeInMBs", "usedSizeInMBs", "usedPercent"})
    public ExternalAsmDiskGroupSummary(String name, Integer mountingInstanceCount, Integer dismountingInstanceCount, RedundancyType redundancyType, Boolean isSparse, List<String> databases, Long totalSizeInMBs, Long usedSizeInMBs, Float usedPercent) {
        this.name = name;
        this.mountingInstanceCount = mountingInstanceCount;
        this.dismountingInstanceCount = dismountingInstanceCount;
        this.redundancyType = redundancyType;
        this.isSparse = isSparse;
        this.databases = databases;
        this.totalSizeInMBs = totalSizeInMBs;
        this.usedSizeInMBs = usedSizeInMBs;
        this.usedPercent = usedPercent;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public Integer getMountingInstanceCount() {
        return this.mountingInstanceCount;
    }

    public Integer getDismountingInstanceCount() {
        return this.dismountingInstanceCount;
    }

    public RedundancyType getRedundancyType() {
        return this.redundancyType;
    }

    public Boolean getIsSparse() {
        return this.isSparse;
    }

    public List<String> getDatabases() {
        return this.databases;
    }

    public Long getTotalSizeInMBs() {
        return this.totalSizeInMBs;
    }

    public Long getUsedSizeInMBs() {
        return this.usedSizeInMBs;
    }

    public Float getUsedPercent() {
        return this.usedPercent;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExternalAsmDiskGroupSummary(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", mountingInstanceCount=").append(String.valueOf(this.mountingInstanceCount));
        sb.append(", dismountingInstanceCount=").append(String.valueOf(this.dismountingInstanceCount));
        sb.append(", redundancyType=").append(String.valueOf((Object)this.redundancyType));
        sb.append(", isSparse=").append(String.valueOf(this.isSparse));
        sb.append(", databases=").append(String.valueOf(this.databases));
        sb.append(", totalSizeInMBs=").append(String.valueOf(this.totalSizeInMBs));
        sb.append(", usedSizeInMBs=").append(String.valueOf(this.usedSizeInMBs));
        sb.append(", usedPercent=").append(String.valueOf(this.usedPercent));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExternalAsmDiskGroupSummary)) {
            return false;
        }
        ExternalAsmDiskGroupSummary other = (ExternalAsmDiskGroupSummary)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.mountingInstanceCount, other.mountingInstanceCount) && Objects.equals(this.dismountingInstanceCount, other.dismountingInstanceCount) && Objects.equals((Object)this.redundancyType, (Object)other.redundancyType) && Objects.equals(this.isSparse, other.isSparse) && Objects.equals(this.databases, other.databases) && Objects.equals(this.totalSizeInMBs, other.totalSizeInMBs) && Objects.equals(this.usedSizeInMBs, other.usedSizeInMBs) && Objects.equals(this.usedPercent, other.usedPercent) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.mountingInstanceCount == null ? 43 : this.mountingInstanceCount.hashCode());
        result = result * 59 + (this.dismountingInstanceCount == null ? 43 : this.dismountingInstanceCount.hashCode());
        result = result * 59 + (this.redundancyType == null ? 43 : this.redundancyType.hashCode());
        result = result * 59 + (this.isSparse == null ? 43 : this.isSparse.hashCode());
        result = result * 59 + (this.databases == null ? 43 : this.databases.hashCode());
        result = result * 59 + (this.totalSizeInMBs == null ? 43 : this.totalSizeInMBs.hashCode());
        result = result * 59 + (this.usedSizeInMBs == null ? 43 : this.usedSizeInMBs.hashCode());
        result = result * 59 + (this.usedPercent == null ? 43 : this.usedPercent.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum RedundancyType implements BmcEnum
    {
        Extend("EXTEND"),
        Extern("EXTERN"),
        Flex("FLEX"),
        High("HIGH"),
        Normal("NORMAL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, RedundancyType> map;

        private RedundancyType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static RedundancyType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'RedundancyType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(RedundancyType.class);
            map = new HashMap<String, RedundancyType>();
            for (RedundancyType v : RedundancyType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="mountingInstanceCount")
        private Integer mountingInstanceCount;
        @JsonProperty(value="dismountingInstanceCount")
        private Integer dismountingInstanceCount;
        @JsonProperty(value="redundancyType")
        private RedundancyType redundancyType;
        @JsonProperty(value="isSparse")
        private Boolean isSparse;
        @JsonProperty(value="databases")
        private List<String> databases;
        @JsonProperty(value="totalSizeInMBs")
        private Long totalSizeInMBs;
        @JsonProperty(value="usedSizeInMBs")
        private Long usedSizeInMBs;
        @JsonProperty(value="usedPercent")
        private Float usedPercent;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder mountingInstanceCount(Integer mountingInstanceCount) {
            this.mountingInstanceCount = mountingInstanceCount;
            this.__explicitlySet__.add("mountingInstanceCount");
            return this;
        }

        public Builder dismountingInstanceCount(Integer dismountingInstanceCount) {
            this.dismountingInstanceCount = dismountingInstanceCount;
            this.__explicitlySet__.add("dismountingInstanceCount");
            return this;
        }

        public Builder redundancyType(RedundancyType redundancyType) {
            this.redundancyType = redundancyType;
            this.__explicitlySet__.add("redundancyType");
            return this;
        }

        public Builder isSparse(Boolean isSparse) {
            this.isSparse = isSparse;
            this.__explicitlySet__.add("isSparse");
            return this;
        }

        public Builder databases(List<String> databases) {
            this.databases = databases;
            this.__explicitlySet__.add("databases");
            return this;
        }

        public Builder totalSizeInMBs(Long totalSizeInMBs) {
            this.totalSizeInMBs = totalSizeInMBs;
            this.__explicitlySet__.add("totalSizeInMBs");
            return this;
        }

        public Builder usedSizeInMBs(Long usedSizeInMBs) {
            this.usedSizeInMBs = usedSizeInMBs;
            this.__explicitlySet__.add("usedSizeInMBs");
            return this;
        }

        public Builder usedPercent(Float usedPercent) {
            this.usedPercent = usedPercent;
            this.__explicitlySet__.add("usedPercent");
            return this;
        }

        public ExternalAsmDiskGroupSummary build() {
            ExternalAsmDiskGroupSummary model = new ExternalAsmDiskGroupSummary(this.name, this.mountingInstanceCount, this.dismountingInstanceCount, this.redundancyType, this.isSparse, this.databases, this.totalSizeInMBs, this.usedSizeInMBs, this.usedPercent);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExternalAsmDiskGroupSummary model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("mountingInstanceCount")) {
                this.mountingInstanceCount(model.getMountingInstanceCount());
            }
            if (model.wasPropertyExplicitlySet("dismountingInstanceCount")) {
                this.dismountingInstanceCount(model.getDismountingInstanceCount());
            }
            if (model.wasPropertyExplicitlySet("redundancyType")) {
                this.redundancyType(model.getRedundancyType());
            }
            if (model.wasPropertyExplicitlySet("isSparse")) {
                this.isSparse(model.getIsSparse());
            }
            if (model.wasPropertyExplicitlySet("databases")) {
                this.databases(model.getDatabases());
            }
            if (model.wasPropertyExplicitlySet("totalSizeInMBs")) {
                this.totalSizeInMBs(model.getTotalSizeInMBs());
            }
            if (model.wasPropertyExplicitlySet("usedSizeInMBs")) {
                this.usedSizeInMBs(model.getUsedSizeInMBs());
            }
            if (model.wasPropertyExplicitlySet("usedPercent")) {
                this.usedPercent(model.getUsedPercent());
            }
            return this;
        }
    }
}

