/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ExternalClusterNetworkConfiguration
extends ExplicitlySetBmcModel {
    @JsonProperty(value="networkNumber")
    private final Integer networkNumber;
    @JsonProperty(value="networkType")
    private final NetworkType networkType;
    @JsonProperty(value="subnet")
    private final String subnet;

    @Deprecated
    @ConstructorProperties(value={"networkNumber", "networkType", "subnet"})
    public ExternalClusterNetworkConfiguration(Integer networkNumber, NetworkType networkType, String subnet) {
        this.networkNumber = networkNumber;
        this.networkType = networkType;
        this.subnet = subnet;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getNetworkNumber() {
        return this.networkNumber;
    }

    public NetworkType getNetworkType() {
        return this.networkType;
    }

    public String getSubnet() {
        return this.subnet;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExternalClusterNetworkConfiguration(");
        sb.append("super=").append(super.toString());
        sb.append("networkNumber=").append(String.valueOf(this.networkNumber));
        sb.append(", networkType=").append(String.valueOf((Object)this.networkType));
        sb.append(", subnet=").append(String.valueOf(this.subnet));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExternalClusterNetworkConfiguration)) {
            return false;
        }
        ExternalClusterNetworkConfiguration other = (ExternalClusterNetworkConfiguration)((Object)o);
        return Objects.equals(this.networkNumber, other.networkNumber) && Objects.equals((Object)this.networkType, (Object)other.networkType) && Objects.equals(this.subnet, other.subnet) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.networkNumber == null ? 43 : this.networkNumber.hashCode());
        result = result * 59 + (this.networkType == null ? 43 : this.networkType.hashCode());
        result = result * 59 + (this.subnet == null ? 43 : this.subnet.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum NetworkType implements BmcEnum
    {
        Autoconfig("AUTOCONFIG"),
        Dhcp("DHCP"),
        Static("STATIC"),
        Mixed("MIXED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, NetworkType> map;

        private NetworkType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static NetworkType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'NetworkType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(NetworkType.class);
            map = new HashMap<String, NetworkType>();
            for (NetworkType v : NetworkType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="networkNumber")
        private Integer networkNumber;
        @JsonProperty(value="networkType")
        private NetworkType networkType;
        @JsonProperty(value="subnet")
        private String subnet;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder networkNumber(Integer networkNumber) {
            this.networkNumber = networkNumber;
            this.__explicitlySet__.add("networkNumber");
            return this;
        }

        public Builder networkType(NetworkType networkType) {
            this.networkType = networkType;
            this.__explicitlySet__.add("networkType");
            return this;
        }

        public Builder subnet(String subnet) {
            this.subnet = subnet;
            this.__explicitlySet__.add("subnet");
            return this;
        }

        public ExternalClusterNetworkConfiguration build() {
            ExternalClusterNetworkConfiguration model = new ExternalClusterNetworkConfiguration(this.networkNumber, this.networkType, this.subnet);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExternalClusterNetworkConfiguration model) {
            if (model.wasPropertyExplicitlySet("networkNumber")) {
                this.networkNumber(model.getNetworkNumber());
            }
            if (model.wasPropertyExplicitlySet("networkType")) {
                this.networkType(model.getNetworkType());
            }
            if (model.wasPropertyExplicitlySet("subnet")) {
                this.subnet(model.getSubnet());
            }
            return this;
        }
    }
}

