/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.EntityDiscovered;
import com.oracle.bmc.databasemanagement.model.ExternalDatabaseSystemDiscoverySummary;
import com.oracle.bmc.databasemanagement.model.ExternalStorageGridDiscoverySummary;
import com.oracle.bmc.databasemanagement.model.ExternalStorageServerDiscoverySummary;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="entityType")
@JsonFilter(value="explicitlySetFilter")
public final class ExternalExadataInfrastructureDiscovery
extends EntityDiscovered {
    @JsonProperty(value="discoveryKey")
    private final String discoveryKey;
    @JsonProperty(value="licenseModel")
    private final LicenseModel licenseModel;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="rackSize")
    private final RackSize rackSize;
    @JsonProperty(value="gridHomePath")
    private final String gridHomePath;
    @JsonProperty(value="dbSystems")
    private final List<ExternalDatabaseSystemDiscoverySummary> dbSystems;
    @JsonProperty(value="storageGrid")
    private final ExternalStorageGridDiscoverySummary storageGrid;
    @JsonProperty(value="storageServers")
    private final List<ExternalStorageServerDiscoverySummary> storageServers;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ExternalExadataInfrastructureDiscovery(String id, String agentId, String connectorId, String displayName, String version, String internalId, String status, EntityDiscovered.DiscoverStatus discoverStatus, String discoverErrorCode, String discoverErrorMsg, String discoveryKey, LicenseModel licenseModel, String compartmentId, RackSize rackSize, String gridHomePath, List<ExternalDatabaseSystemDiscoverySummary> dbSystems, ExternalStorageGridDiscoverySummary storageGrid, List<ExternalStorageServerDiscoverySummary> storageServers) {
        super(id, agentId, connectorId, displayName, version, internalId, status, discoverStatus, discoverErrorCode, discoverErrorMsg);
        this.discoveryKey = discoveryKey;
        this.licenseModel = licenseModel;
        this.compartmentId = compartmentId;
        this.rackSize = rackSize;
        this.gridHomePath = gridHomePath;
        this.dbSystems = dbSystems;
        this.storageGrid = storageGrid;
        this.storageServers = storageServers;
    }

    public String getDiscoveryKey() {
        return this.discoveryKey;
    }

    public LicenseModel getLicenseModel() {
        return this.licenseModel;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public RackSize getRackSize() {
        return this.rackSize;
    }

    public String getGridHomePath() {
        return this.gridHomePath;
    }

    public List<ExternalDatabaseSystemDiscoverySummary> getDbSystems() {
        return this.dbSystems;
    }

    public ExternalStorageGridDiscoverySummary getStorageGrid() {
        return this.storageGrid;
    }

    public List<ExternalStorageServerDiscoverySummary> getStorageServers() {
        return this.storageServers;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExternalExadataInfrastructureDiscovery(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", discoveryKey=").append(String.valueOf(this.discoveryKey));
        sb.append(", licenseModel=").append(String.valueOf((Object)this.licenseModel));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", rackSize=").append(String.valueOf((Object)this.rackSize));
        sb.append(", gridHomePath=").append(String.valueOf(this.gridHomePath));
        sb.append(", dbSystems=").append(String.valueOf(this.dbSystems));
        sb.append(", storageGrid=").append(String.valueOf((Object)this.storageGrid));
        sb.append(", storageServers=").append(String.valueOf(this.storageServers));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExternalExadataInfrastructureDiscovery)) {
            return false;
        }
        ExternalExadataInfrastructureDiscovery other = (ExternalExadataInfrastructureDiscovery)((Object)o);
        return Objects.equals(this.discoveryKey, other.discoveryKey) && Objects.equals((Object)this.licenseModel, (Object)other.licenseModel) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.rackSize, (Object)other.rackSize) && Objects.equals(this.gridHomePath, other.gridHomePath) && Objects.equals(this.dbSystems, other.dbSystems) && Objects.equals((Object)this.storageGrid, (Object)other.storageGrid) && Objects.equals(this.storageServers, other.storageServers) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.discoveryKey == null ? 43 : this.discoveryKey.hashCode());
        result = result * 59 + (this.licenseModel == null ? 43 : this.licenseModel.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.rackSize == null ? 43 : this.rackSize.hashCode());
        result = result * 59 + (this.gridHomePath == null ? 43 : this.gridHomePath.hashCode());
        result = result * 59 + (this.dbSystems == null ? 43 : this.dbSystems.hashCode());
        result = result * 59 + (this.storageGrid == null ? 43 : this.storageGrid.hashCode());
        result = result * 59 + (this.storageServers == null ? 43 : this.storageServers.hashCode());
        return result;
    }

    public static enum RackSize implements BmcEnum
    {
        Full("FULL"),
        Half("HALF"),
        Quarter("QUARTER"),
        Eighth("EIGHTH"),
        Unknown("UNKNOWN"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, RackSize> map;

        private RackSize(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static RackSize create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'RackSize', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(RackSize.class);
            map = new HashMap<String, RackSize>();
            for (RackSize v : RackSize.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LicenseModel implements BmcEnum
    {
        LicenseIncluded("LICENSE_INCLUDED"),
        BringYourOwnLicense("BRING_YOUR_OWN_LICENSE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LicenseModel> map;

        private LicenseModel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LicenseModel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LicenseModel', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LicenseModel.class);
            map = new HashMap<String, LicenseModel>();
            for (LicenseModel v : LicenseModel.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="agentId")
        private String agentId;
        @JsonProperty(value="connectorId")
        private String connectorId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="internalId")
        private String internalId;
        @JsonProperty(value="status")
        private String status;
        @JsonProperty(value="discoverStatus")
        private EntityDiscovered.DiscoverStatus discoverStatus;
        @JsonProperty(value="discoverErrorCode")
        private String discoverErrorCode;
        @JsonProperty(value="discoverErrorMsg")
        private String discoverErrorMsg;
        @JsonProperty(value="discoveryKey")
        private String discoveryKey;
        @JsonProperty(value="licenseModel")
        private LicenseModel licenseModel;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="rackSize")
        private RackSize rackSize;
        @JsonProperty(value="gridHomePath")
        private String gridHomePath;
        @JsonProperty(value="dbSystems")
        private List<ExternalDatabaseSystemDiscoverySummary> dbSystems;
        @JsonProperty(value="storageGrid")
        private ExternalStorageGridDiscoverySummary storageGrid;
        @JsonProperty(value="storageServers")
        private List<ExternalStorageServerDiscoverySummary> storageServers;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder agentId(String agentId) {
            this.agentId = agentId;
            this.__explicitlySet__.add("agentId");
            return this;
        }

        public Builder connectorId(String connectorId) {
            this.connectorId = connectorId;
            this.__explicitlySet__.add("connectorId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder internalId(String internalId) {
            this.internalId = internalId;
            this.__explicitlySet__.add("internalId");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder discoverStatus(EntityDiscovered.DiscoverStatus discoverStatus) {
            this.discoverStatus = discoverStatus;
            this.__explicitlySet__.add("discoverStatus");
            return this;
        }

        public Builder discoverErrorCode(String discoverErrorCode) {
            this.discoverErrorCode = discoverErrorCode;
            this.__explicitlySet__.add("discoverErrorCode");
            return this;
        }

        public Builder discoverErrorMsg(String discoverErrorMsg) {
            this.discoverErrorMsg = discoverErrorMsg;
            this.__explicitlySet__.add("discoverErrorMsg");
            return this;
        }

        public Builder discoveryKey(String discoveryKey) {
            this.discoveryKey = discoveryKey;
            this.__explicitlySet__.add("discoveryKey");
            return this;
        }

        public Builder licenseModel(LicenseModel licenseModel) {
            this.licenseModel = licenseModel;
            this.__explicitlySet__.add("licenseModel");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder rackSize(RackSize rackSize) {
            this.rackSize = rackSize;
            this.__explicitlySet__.add("rackSize");
            return this;
        }

        public Builder gridHomePath(String gridHomePath) {
            this.gridHomePath = gridHomePath;
            this.__explicitlySet__.add("gridHomePath");
            return this;
        }

        public Builder dbSystems(List<ExternalDatabaseSystemDiscoverySummary> dbSystems) {
            this.dbSystems = dbSystems;
            this.__explicitlySet__.add("dbSystems");
            return this;
        }

        public Builder storageGrid(ExternalStorageGridDiscoverySummary storageGrid) {
            this.storageGrid = storageGrid;
            this.__explicitlySet__.add("storageGrid");
            return this;
        }

        public Builder storageServers(List<ExternalStorageServerDiscoverySummary> storageServers) {
            this.storageServers = storageServers;
            this.__explicitlySet__.add("storageServers");
            return this;
        }

        public ExternalExadataInfrastructureDiscovery build() {
            ExternalExadataInfrastructureDiscovery model = new ExternalExadataInfrastructureDiscovery(this.id, this.agentId, this.connectorId, this.displayName, this.version, this.internalId, this.status, this.discoverStatus, this.discoverErrorCode, this.discoverErrorMsg, this.discoveryKey, this.licenseModel, this.compartmentId, this.rackSize, this.gridHomePath, this.dbSystems, this.storageGrid, this.storageServers);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExternalExadataInfrastructureDiscovery model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("agentId")) {
                this.agentId(model.getAgentId());
            }
            if (model.wasPropertyExplicitlySet("connectorId")) {
                this.connectorId(model.getConnectorId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("internalId")) {
                this.internalId(model.getInternalId());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("discoverStatus")) {
                this.discoverStatus(model.getDiscoverStatus());
            }
            if (model.wasPropertyExplicitlySet("discoverErrorCode")) {
                this.discoverErrorCode(model.getDiscoverErrorCode());
            }
            if (model.wasPropertyExplicitlySet("discoverErrorMsg")) {
                this.discoverErrorMsg(model.getDiscoverErrorMsg());
            }
            if (model.wasPropertyExplicitlySet("discoveryKey")) {
                this.discoveryKey(model.getDiscoveryKey());
            }
            if (model.wasPropertyExplicitlySet("licenseModel")) {
                this.licenseModel(model.getLicenseModel());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("rackSize")) {
                this.rackSize(model.getRackSize());
            }
            if (model.wasPropertyExplicitlySet("gridHomePath")) {
                this.gridHomePath(model.getGridHomePath());
            }
            if (model.wasPropertyExplicitlySet("dbSystems")) {
                this.dbSystems(model.getDbSystems());
            }
            if (model.wasPropertyExplicitlySet("storageGrid")) {
                this.storageGrid(model.getStorageGrid());
            }
            if (model.wasPropertyExplicitlySet("storageServers")) {
                this.storageServers(model.getStorageServers());
            }
            return this;
        }
    }
}

