/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class JobScheduleDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="startTime")
    private final String startTime;
    @JsonProperty(value="endTime")
    private final String endTime;
    @JsonProperty(value="intervalType")
    private final IntervalType intervalType;
    @JsonProperty(value="intervalValue")
    private final String intervalValue;

    @Deprecated
    @ConstructorProperties(value={"startTime", "endTime", "intervalType", "intervalValue"})
    public JobScheduleDetails(String startTime, String endTime, IntervalType intervalType, String intervalValue) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.intervalType = intervalType;
        this.intervalValue = intervalValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public IntervalType getIntervalType() {
        return this.intervalType;
    }

    public String getIntervalValue() {
        return this.intervalValue;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("JobScheduleDetails(");
        sb.append("super=").append(super.toString());
        sb.append("startTime=").append(String.valueOf(this.startTime));
        sb.append(", endTime=").append(String.valueOf(this.endTime));
        sb.append(", intervalType=").append(String.valueOf((Object)this.intervalType));
        sb.append(", intervalValue=").append(String.valueOf(this.intervalValue));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JobScheduleDetails)) {
            return false;
        }
        JobScheduleDetails other = (JobScheduleDetails)((Object)o);
        return Objects.equals(this.startTime, other.startTime) && Objects.equals(this.endTime, other.endTime) && Objects.equals((Object)this.intervalType, (Object)other.intervalType) && Objects.equals(this.intervalValue, other.intervalValue) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.startTime == null ? 43 : this.startTime.hashCode());
        result = result * 59 + (this.endTime == null ? 43 : this.endTime.hashCode());
        result = result * 59 + (this.intervalType == null ? 43 : this.intervalType.hashCode());
        result = result * 59 + (this.intervalValue == null ? 43 : this.intervalValue.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum IntervalType implements BmcEnum
    {
        Daily("DAILY"),
        Hourly("HOURLY"),
        Weekly("WEEKLY"),
        Monthly("MONTHLY"),
        Never("NEVER"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, IntervalType> map;

        private IntervalType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static IntervalType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'IntervalType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(IntervalType.class);
            map = new HashMap<String, IntervalType>();
            for (IntervalType v : IntervalType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="startTime")
        private String startTime;
        @JsonProperty(value="endTime")
        private String endTime;
        @JsonProperty(value="intervalType")
        private IntervalType intervalType;
        @JsonProperty(value="intervalValue")
        private String intervalValue;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder startTime(String startTime) {
            this.startTime = startTime;
            this.__explicitlySet__.add("startTime");
            return this;
        }

        public Builder endTime(String endTime) {
            this.endTime = endTime;
            this.__explicitlySet__.add("endTime");
            return this;
        }

        public Builder intervalType(IntervalType intervalType) {
            this.intervalType = intervalType;
            this.__explicitlySet__.add("intervalType");
            return this;
        }

        public Builder intervalValue(String intervalValue) {
            this.intervalValue = intervalValue;
            this.__explicitlySet__.add("intervalValue");
            return this;
        }

        public JobScheduleDetails build() {
            JobScheduleDetails model = new JobScheduleDetails(this.startTime, this.endTime, this.intervalType, this.intervalValue);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(JobScheduleDetails model) {
            if (model.wasPropertyExplicitlySet("startTime")) {
                this.startTime(model.getStartTime());
            }
            if (model.wasPropertyExplicitlySet("endTime")) {
                this.endTime(model.getEndTime());
            }
            if (model.wasPropertyExplicitlySet("intervalType")) {
                this.intervalType(model.getIntervalType());
            }
            if (model.wasPropertyExplicitlySet("intervalValue")) {
                this.intervalValue(model.getIntervalValue());
            }
            return this;
        }
    }
}

