/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MySqlConfigurationDataSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="value")
    private final String value;
    @JsonProperty(value="source")
    private final Source source;
    @JsonProperty(value="minValue")
    private final BigDecimal minValue;
    @JsonProperty(value="maxValue")
    private final BigDecimal maxValue;
    @JsonProperty(value="type")
    private final String type;
    @JsonProperty(value="defaultValue")
    private final String defaultValue;
    @JsonProperty(value="timeSet")
    private final Date timeSet;
    @JsonProperty(value="hostSet")
    private final String hostSet;
    @JsonProperty(value="userSet")
    private final String userSet;
    @JsonProperty(value="isDynamic")
    private final Boolean isDynamic;
    @JsonProperty(value="isInit")
    private final Boolean isInit;
    @JsonProperty(value="isConfigurable")
    private final Boolean isConfigurable;
    @JsonProperty(value="path")
    private final String path;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="possibleValues")
    private final String possibleValues;
    @JsonProperty(value="supportedVersions")
    private final String supportedVersions;

    @Deprecated
    @ConstructorProperties(value={"name", "value", "source", "minValue", "maxValue", "type", "defaultValue", "timeSet", "hostSet", "userSet", "isDynamic", "isInit", "isConfigurable", "path", "description", "possibleValues", "supportedVersions"})
    public MySqlConfigurationDataSummary(String name, String value, Source source, BigDecimal minValue, BigDecimal maxValue, String type, String defaultValue, Date timeSet, String hostSet, String userSet, Boolean isDynamic, Boolean isInit, Boolean isConfigurable, String path, String description, String possibleValues, String supportedVersions) {
        this.name = name;
        this.value = value;
        this.source = source;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.type = type;
        this.defaultValue = defaultValue;
        this.timeSet = timeSet;
        this.hostSet = hostSet;
        this.userSet = userSet;
        this.isDynamic = isDynamic;
        this.isInit = isInit;
        this.isConfigurable = isConfigurable;
        this.path = path;
        this.description = description;
        this.possibleValues = possibleValues;
        this.supportedVersions = supportedVersions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public Source getSource() {
        return this.source;
    }

    public BigDecimal getMinValue() {
        return this.minValue;
    }

    public BigDecimal getMaxValue() {
        return this.maxValue;
    }

    public String getType() {
        return this.type;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public Date getTimeSet() {
        return this.timeSet;
    }

    public String getHostSet() {
        return this.hostSet;
    }

    public String getUserSet() {
        return this.userSet;
    }

    public Boolean getIsDynamic() {
        return this.isDynamic;
    }

    public Boolean getIsInit() {
        return this.isInit;
    }

    public Boolean getIsConfigurable() {
        return this.isConfigurable;
    }

    public String getPath() {
        return this.path;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPossibleValues() {
        return this.possibleValues;
    }

    public String getSupportedVersions() {
        return this.supportedVersions;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MySqlConfigurationDataSummary(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", value=").append(String.valueOf(this.value));
        sb.append(", source=").append(String.valueOf((Object)this.source));
        sb.append(", minValue=").append(String.valueOf(this.minValue));
        sb.append(", maxValue=").append(String.valueOf(this.maxValue));
        sb.append(", type=").append(String.valueOf(this.type));
        sb.append(", defaultValue=").append(String.valueOf(this.defaultValue));
        sb.append(", timeSet=").append(String.valueOf(this.timeSet));
        sb.append(", hostSet=").append(String.valueOf(this.hostSet));
        sb.append(", userSet=").append(String.valueOf(this.userSet));
        sb.append(", isDynamic=").append(String.valueOf(this.isDynamic));
        sb.append(", isInit=").append(String.valueOf(this.isInit));
        sb.append(", isConfigurable=").append(String.valueOf(this.isConfigurable));
        sb.append(", path=").append(String.valueOf(this.path));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", possibleValues=").append(String.valueOf(this.possibleValues));
        sb.append(", supportedVersions=").append(String.valueOf(this.supportedVersions));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MySqlConfigurationDataSummary)) {
            return false;
        }
        MySqlConfigurationDataSummary other = (MySqlConfigurationDataSummary)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.value, other.value) && Objects.equals((Object)this.source, (Object)other.source) && Objects.equals(this.minValue, other.minValue) && Objects.equals(this.maxValue, other.maxValue) && Objects.equals(this.type, other.type) && Objects.equals(this.defaultValue, other.defaultValue) && Objects.equals(this.timeSet, other.timeSet) && Objects.equals(this.hostSet, other.hostSet) && Objects.equals(this.userSet, other.userSet) && Objects.equals(this.isDynamic, other.isDynamic) && Objects.equals(this.isInit, other.isInit) && Objects.equals(this.isConfigurable, other.isConfigurable) && Objects.equals(this.path, other.path) && Objects.equals(this.description, other.description) && Objects.equals(this.possibleValues, other.possibleValues) && Objects.equals(this.supportedVersions, other.supportedVersions) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.value == null ? 43 : this.value.hashCode());
        result = result * 59 + (this.source == null ? 43 : this.source.hashCode());
        result = result * 59 + (this.minValue == null ? 43 : this.minValue.hashCode());
        result = result * 59 + (this.maxValue == null ? 43 : this.maxValue.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.defaultValue == null ? 43 : this.defaultValue.hashCode());
        result = result * 59 + (this.timeSet == null ? 43 : this.timeSet.hashCode());
        result = result * 59 + (this.hostSet == null ? 43 : this.hostSet.hashCode());
        result = result * 59 + (this.userSet == null ? 43 : this.userSet.hashCode());
        result = result * 59 + (this.isDynamic == null ? 43 : this.isDynamic.hashCode());
        result = result * 59 + (this.isInit == null ? 43 : this.isInit.hashCode());
        result = result * 59 + (this.isConfigurable == null ? 43 : this.isConfigurable.hashCode());
        result = result * 59 + (this.path == null ? 43 : this.path.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.possibleValues == null ? 43 : this.possibleValues.hashCode());
        result = result * 59 + (this.supportedVersions == null ? 43 : this.supportedVersions.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Source implements BmcEnum
    {
        Compiled("COMPILED"),
        Global("GLOBAL"),
        Server("SERVER"),
        Explicit("EXPLICIT"),
        Extra("EXTRA"),
        User("USER"),
        Login("LOGIN"),
        CommandLine("COMMAND_LINE"),
        Persisted("PERSISTED"),
        Dynamic("DYNAMIC"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Source> map;

        private Source(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Source create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Source', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Source.class);
            map = new HashMap<String, Source>();
            for (Source v : Source.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="value")
        private String value;
        @JsonProperty(value="source")
        private Source source;
        @JsonProperty(value="minValue")
        private BigDecimal minValue;
        @JsonProperty(value="maxValue")
        private BigDecimal maxValue;
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="defaultValue")
        private String defaultValue;
        @JsonProperty(value="timeSet")
        private Date timeSet;
        @JsonProperty(value="hostSet")
        private String hostSet;
        @JsonProperty(value="userSet")
        private String userSet;
        @JsonProperty(value="isDynamic")
        private Boolean isDynamic;
        @JsonProperty(value="isInit")
        private Boolean isInit;
        @JsonProperty(value="isConfigurable")
        private Boolean isConfigurable;
        @JsonProperty(value="path")
        private String path;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="possibleValues")
        private String possibleValues;
        @JsonProperty(value="supportedVersions")
        private String supportedVersions;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            this.__explicitlySet__.add("value");
            return this;
        }

        public Builder source(Source source) {
            this.source = source;
            this.__explicitlySet__.add("source");
            return this;
        }

        public Builder minValue(BigDecimal minValue) {
            this.minValue = minValue;
            this.__explicitlySet__.add("minValue");
            return this;
        }

        public Builder maxValue(BigDecimal maxValue) {
            this.maxValue = maxValue;
            this.__explicitlySet__.add("maxValue");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            this.__explicitlySet__.add("defaultValue");
            return this;
        }

        public Builder timeSet(Date timeSet) {
            this.timeSet = timeSet;
            this.__explicitlySet__.add("timeSet");
            return this;
        }

        public Builder hostSet(String hostSet) {
            this.hostSet = hostSet;
            this.__explicitlySet__.add("hostSet");
            return this;
        }

        public Builder userSet(String userSet) {
            this.userSet = userSet;
            this.__explicitlySet__.add("userSet");
            return this;
        }

        public Builder isDynamic(Boolean isDynamic) {
            this.isDynamic = isDynamic;
            this.__explicitlySet__.add("isDynamic");
            return this;
        }

        public Builder isInit(Boolean isInit) {
            this.isInit = isInit;
            this.__explicitlySet__.add("isInit");
            return this;
        }

        public Builder isConfigurable(Boolean isConfigurable) {
            this.isConfigurable = isConfigurable;
            this.__explicitlySet__.add("isConfigurable");
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            this.__explicitlySet__.add("path");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder possibleValues(String possibleValues) {
            this.possibleValues = possibleValues;
            this.__explicitlySet__.add("possibleValues");
            return this;
        }

        public Builder supportedVersions(String supportedVersions) {
            this.supportedVersions = supportedVersions;
            this.__explicitlySet__.add("supportedVersions");
            return this;
        }

        public MySqlConfigurationDataSummary build() {
            MySqlConfigurationDataSummary model = new MySqlConfigurationDataSummary(this.name, this.value, this.source, this.minValue, this.maxValue, this.type, this.defaultValue, this.timeSet, this.hostSet, this.userSet, this.isDynamic, this.isInit, this.isConfigurable, this.path, this.description, this.possibleValues, this.supportedVersions);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MySqlConfigurationDataSummary model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("value")) {
                this.value(model.getValue());
            }
            if (model.wasPropertyExplicitlySet("source")) {
                this.source(model.getSource());
            }
            if (model.wasPropertyExplicitlySet("minValue")) {
                this.minValue(model.getMinValue());
            }
            if (model.wasPropertyExplicitlySet("maxValue")) {
                this.maxValue(model.getMaxValue());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("defaultValue")) {
                this.defaultValue(model.getDefaultValue());
            }
            if (model.wasPropertyExplicitlySet("timeSet")) {
                this.timeSet(model.getTimeSet());
            }
            if (model.wasPropertyExplicitlySet("hostSet")) {
                this.hostSet(model.getHostSet());
            }
            if (model.wasPropertyExplicitlySet("userSet")) {
                this.userSet(model.getUserSet());
            }
            if (model.wasPropertyExplicitlySet("isDynamic")) {
                this.isDynamic(model.getIsDynamic());
            }
            if (model.wasPropertyExplicitlySet("isInit")) {
                this.isInit(model.getIsInit());
            }
            if (model.wasPropertyExplicitlySet("isConfigurable")) {
                this.isConfigurable(model.getIsConfigurable());
            }
            if (model.wasPropertyExplicitlySet("path")) {
                this.path(model.getPath());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("possibleValues")) {
                this.possibleValues(model.getPossibleValues());
            }
            if (model.wasPropertyExplicitlySet("supportedVersions")) {
                this.supportedVersions(model.getSupportedVersions());
            }
            return this;
        }
    }
}

