/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.PreferredCredentialStatus;
import com.oracle.bmc.databasemanagement.model.Role;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PreferredCredentialSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="credentialName")
    private final String credentialName;
    @JsonProperty(value="status")
    private final PreferredCredentialStatus status;
    @JsonProperty(value="isAccessible")
    private final Boolean isAccessible;
    @JsonProperty(value="userName")
    private final String userName;
    @JsonProperty(value="role")
    private final Role role;
    @JsonProperty(value="passwordSecretId")
    private final String passwordSecretId;
    @JsonProperty(value="namedCredentialId")
    private final String namedCredentialId;

    @Deprecated
    @ConstructorProperties(value={"credentialName", "status", "isAccessible", "userName", "role", "passwordSecretId", "namedCredentialId"})
    public PreferredCredentialSummary(String credentialName, PreferredCredentialStatus status, Boolean isAccessible, String userName, Role role, String passwordSecretId, String namedCredentialId) {
        this.credentialName = credentialName;
        this.status = status;
        this.isAccessible = isAccessible;
        this.userName = userName;
        this.role = role;
        this.passwordSecretId = passwordSecretId;
        this.namedCredentialId = namedCredentialId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCredentialName() {
        return this.credentialName;
    }

    public PreferredCredentialStatus getStatus() {
        return this.status;
    }

    public Boolean getIsAccessible() {
        return this.isAccessible;
    }

    public String getUserName() {
        return this.userName;
    }

    public Role getRole() {
        return this.role;
    }

    public String getPasswordSecretId() {
        return this.passwordSecretId;
    }

    public String getNamedCredentialId() {
        return this.namedCredentialId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PreferredCredentialSummary(");
        sb.append("super=").append(super.toString());
        sb.append("credentialName=").append(String.valueOf(this.credentialName));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", isAccessible=").append(String.valueOf(this.isAccessible));
        sb.append(", userName=").append(String.valueOf(this.userName));
        sb.append(", role=").append(String.valueOf((Object)this.role));
        sb.append(", passwordSecretId=").append(String.valueOf(this.passwordSecretId));
        sb.append(", namedCredentialId=").append(String.valueOf(this.namedCredentialId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PreferredCredentialSummary)) {
            return false;
        }
        PreferredCredentialSummary other = (PreferredCredentialSummary)((Object)o);
        return Objects.equals(this.credentialName, other.credentialName) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.isAccessible, other.isAccessible) && Objects.equals(this.userName, other.userName) && Objects.equals((Object)this.role, (Object)other.role) && Objects.equals(this.passwordSecretId, other.passwordSecretId) && Objects.equals(this.namedCredentialId, other.namedCredentialId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.credentialName == null ? 43 : this.credentialName.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.isAccessible == null ? 43 : this.isAccessible.hashCode());
        result = result * 59 + (this.userName == null ? 43 : this.userName.hashCode());
        result = result * 59 + (this.role == null ? 43 : this.role.hashCode());
        result = result * 59 + (this.passwordSecretId == null ? 43 : this.passwordSecretId.hashCode());
        result = result * 59 + (this.namedCredentialId == null ? 43 : this.namedCredentialId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="credentialName")
        private String credentialName;
        @JsonProperty(value="status")
        private PreferredCredentialStatus status;
        @JsonProperty(value="isAccessible")
        private Boolean isAccessible;
        @JsonProperty(value="userName")
        private String userName;
        @JsonProperty(value="role")
        private Role role;
        @JsonProperty(value="passwordSecretId")
        private String passwordSecretId;
        @JsonProperty(value="namedCredentialId")
        private String namedCredentialId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder credentialName(String credentialName) {
            this.credentialName = credentialName;
            this.__explicitlySet__.add("credentialName");
            return this;
        }

        public Builder status(PreferredCredentialStatus status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder isAccessible(Boolean isAccessible) {
            this.isAccessible = isAccessible;
            this.__explicitlySet__.add("isAccessible");
            return this;
        }

        public Builder userName(String userName) {
            this.userName = userName;
            this.__explicitlySet__.add("userName");
            return this;
        }

        public Builder role(Role role) {
            this.role = role;
            this.__explicitlySet__.add("role");
            return this;
        }

        public Builder passwordSecretId(String passwordSecretId) {
            this.passwordSecretId = passwordSecretId;
            this.__explicitlySet__.add("passwordSecretId");
            return this;
        }

        public Builder namedCredentialId(String namedCredentialId) {
            this.namedCredentialId = namedCredentialId;
            this.__explicitlySet__.add("namedCredentialId");
            return this;
        }

        public PreferredCredentialSummary build() {
            PreferredCredentialSummary model = new PreferredCredentialSummary(this.credentialName, this.status, this.isAccessible, this.userName, this.role, this.passwordSecretId, this.namedCredentialId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PreferredCredentialSummary model) {
            if (model.wasPropertyExplicitlySet("credentialName")) {
                this.credentialName(model.getCredentialName());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("isAccessible")) {
                this.isAccessible(model.getIsAccessible());
            }
            if (model.wasPropertyExplicitlySet("userName")) {
                this.userName(model.getUserName());
            }
            if (model.wasPropertyExplicitlySet("role")) {
                this.role(model.getRole());
            }
            if (model.wasPropertyExplicitlySet("passwordSecretId")) {
                this.passwordSecretId(model.getPasswordSecretId());
            }
            if (model.wasPropertyExplicitlySet("namedCredentialId")) {
                this.namedCredentialId(model.getNamedCredentialId());
            }
            return this;
        }
    }
}

