/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.SqlMetrics;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SqlInSqlTuningSet
extends ExplicitlySetBmcModel {
    @JsonProperty(value="sqlId")
    private final String sqlId;
    @JsonProperty(value="sqlText")
    private final String sqlText;
    @JsonProperty(value="containerDatabaseId")
    private final Long containerDatabaseId;
    @JsonProperty(value="planHashValue")
    private final Long planHashValue;
    @JsonProperty(value="schema")
    private final String schema;
    @JsonProperty(value="module")
    private final String module;
    @JsonProperty(value="metrics")
    private final List<SqlMetrics> metrics;

    @Deprecated
    @ConstructorProperties(value={"sqlId", "sqlText", "containerDatabaseId", "planHashValue", "schema", "module", "metrics"})
    public SqlInSqlTuningSet(String sqlId, String sqlText, Long containerDatabaseId, Long planHashValue, String schema, String module, List<SqlMetrics> metrics) {
        this.sqlId = sqlId;
        this.sqlText = sqlText;
        this.containerDatabaseId = containerDatabaseId;
        this.planHashValue = planHashValue;
        this.schema = schema;
        this.module = module;
        this.metrics = metrics;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getSqlId() {
        return this.sqlId;
    }

    public String getSqlText() {
        return this.sqlText;
    }

    public Long getContainerDatabaseId() {
        return this.containerDatabaseId;
    }

    public Long getPlanHashValue() {
        return this.planHashValue;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getModule() {
        return this.module;
    }

    public List<SqlMetrics> getMetrics() {
        return this.metrics;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SqlInSqlTuningSet(");
        sb.append("super=").append(super.toString());
        sb.append("sqlId=").append(String.valueOf(this.sqlId));
        sb.append(", sqlText=").append(String.valueOf(this.sqlText));
        sb.append(", containerDatabaseId=").append(String.valueOf(this.containerDatabaseId));
        sb.append(", planHashValue=").append(String.valueOf(this.planHashValue));
        sb.append(", schema=").append(String.valueOf(this.schema));
        sb.append(", module=").append(String.valueOf(this.module));
        sb.append(", metrics=").append(String.valueOf(this.metrics));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SqlInSqlTuningSet)) {
            return false;
        }
        SqlInSqlTuningSet other = (SqlInSqlTuningSet)((Object)o);
        return Objects.equals(this.sqlId, other.sqlId) && Objects.equals(this.sqlText, other.sqlText) && Objects.equals(this.containerDatabaseId, other.containerDatabaseId) && Objects.equals(this.planHashValue, other.planHashValue) && Objects.equals(this.schema, other.schema) && Objects.equals(this.module, other.module) && Objects.equals(this.metrics, other.metrics) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.sqlId == null ? 43 : this.sqlId.hashCode());
        result = result * 59 + (this.sqlText == null ? 43 : this.sqlText.hashCode());
        result = result * 59 + (this.containerDatabaseId == null ? 43 : this.containerDatabaseId.hashCode());
        result = result * 59 + (this.planHashValue == null ? 43 : this.planHashValue.hashCode());
        result = result * 59 + (this.schema == null ? 43 : this.schema.hashCode());
        result = result * 59 + (this.module == null ? 43 : this.module.hashCode());
        result = result * 59 + (this.metrics == null ? 43 : this.metrics.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="sqlId")
        private String sqlId;
        @JsonProperty(value="sqlText")
        private String sqlText;
        @JsonProperty(value="containerDatabaseId")
        private Long containerDatabaseId;
        @JsonProperty(value="planHashValue")
        private Long planHashValue;
        @JsonProperty(value="schema")
        private String schema;
        @JsonProperty(value="module")
        private String module;
        @JsonProperty(value="metrics")
        private List<SqlMetrics> metrics;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder sqlId(String sqlId) {
            this.sqlId = sqlId;
            this.__explicitlySet__.add("sqlId");
            return this;
        }

        public Builder sqlText(String sqlText) {
            this.sqlText = sqlText;
            this.__explicitlySet__.add("sqlText");
            return this;
        }

        public Builder containerDatabaseId(Long containerDatabaseId) {
            this.containerDatabaseId = containerDatabaseId;
            this.__explicitlySet__.add("containerDatabaseId");
            return this;
        }

        public Builder planHashValue(Long planHashValue) {
            this.planHashValue = planHashValue;
            this.__explicitlySet__.add("planHashValue");
            return this;
        }

        public Builder schema(String schema) {
            this.schema = schema;
            this.__explicitlySet__.add("schema");
            return this;
        }

        public Builder module(String module) {
            this.module = module;
            this.__explicitlySet__.add("module");
            return this;
        }

        public Builder metrics(List<SqlMetrics> metrics) {
            this.metrics = metrics;
            this.__explicitlySet__.add("metrics");
            return this;
        }

        public SqlInSqlTuningSet build() {
            SqlInSqlTuningSet model = new SqlInSqlTuningSet(this.sqlId, this.sqlText, this.containerDatabaseId, this.planHashValue, this.schema, this.module, this.metrics);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SqlInSqlTuningSet model) {
            if (model.wasPropertyExplicitlySet("sqlId")) {
                this.sqlId(model.getSqlId());
            }
            if (model.wasPropertyExplicitlySet("sqlText")) {
                this.sqlText(model.getSqlText());
            }
            if (model.wasPropertyExplicitlySet("containerDatabaseId")) {
                this.containerDatabaseId(model.getContainerDatabaseId());
            }
            if (model.wasPropertyExplicitlySet("planHashValue")) {
                this.planHashValue(model.getPlanHashValue());
            }
            if (model.wasPropertyExplicitlySet("schema")) {
                this.schema(model.getSchema());
            }
            if (model.wasPropertyExplicitlySet("module")) {
                this.module(model.getModule());
            }
            if (model.wasPropertyExplicitlySet("metrics")) {
                this.metrics(model.getMetrics());
            }
            return this;
        }
    }
}

