/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.AutomaticCaptureFilter;
import com.oracle.bmc.databasemanagement.model.SpmEvolveTaskParameters;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SqlPlanBaselineConfiguration
extends ExplicitlySetBmcModel {
    @JsonProperty(value="isAutomaticInitialPlanCaptureEnabled")
    private final Boolean isAutomaticInitialPlanCaptureEnabled;
    @JsonProperty(value="isSqlPlanBaselinesUsageEnabled")
    private final Boolean isSqlPlanBaselinesUsageEnabled;
    @JsonProperty(value="isAutoSpmEvolveTaskEnabled")
    private final Boolean isAutoSpmEvolveTaskEnabled;
    @JsonProperty(value="isHighFrequencyAutoSpmEvolveTaskEnabled")
    private final Boolean isHighFrequencyAutoSpmEvolveTaskEnabled;
    @JsonProperty(value="planRetentionWeeks")
    private final Integer planRetentionWeeks;
    @JsonProperty(value="spaceBudgetPercent")
    private final Float spaceBudgetPercent;
    @JsonProperty(value="spaceBudgetMB")
    private final Float spaceBudgetMB;
    @JsonProperty(value="spaceUsedMB")
    private final Float spaceUsedMB;
    @JsonProperty(value="autoCaptureFilters")
    private final List<AutomaticCaptureFilter> autoCaptureFilters;
    @JsonProperty(value="autoSpmEvolveTaskParameters")
    private final SpmEvolveTaskParameters autoSpmEvolveTaskParameters;

    @Deprecated
    @ConstructorProperties(value={"isAutomaticInitialPlanCaptureEnabled", "isSqlPlanBaselinesUsageEnabled", "isAutoSpmEvolveTaskEnabled", "isHighFrequencyAutoSpmEvolveTaskEnabled", "planRetentionWeeks", "spaceBudgetPercent", "spaceBudgetMB", "spaceUsedMB", "autoCaptureFilters", "autoSpmEvolveTaskParameters"})
    public SqlPlanBaselineConfiguration(Boolean isAutomaticInitialPlanCaptureEnabled, Boolean isSqlPlanBaselinesUsageEnabled, Boolean isAutoSpmEvolveTaskEnabled, Boolean isHighFrequencyAutoSpmEvolveTaskEnabled, Integer planRetentionWeeks, Float spaceBudgetPercent, Float spaceBudgetMB, Float spaceUsedMB, List<AutomaticCaptureFilter> autoCaptureFilters, SpmEvolveTaskParameters autoSpmEvolveTaskParameters) {
        this.isAutomaticInitialPlanCaptureEnabled = isAutomaticInitialPlanCaptureEnabled;
        this.isSqlPlanBaselinesUsageEnabled = isSqlPlanBaselinesUsageEnabled;
        this.isAutoSpmEvolveTaskEnabled = isAutoSpmEvolveTaskEnabled;
        this.isHighFrequencyAutoSpmEvolveTaskEnabled = isHighFrequencyAutoSpmEvolveTaskEnabled;
        this.planRetentionWeeks = planRetentionWeeks;
        this.spaceBudgetPercent = spaceBudgetPercent;
        this.spaceBudgetMB = spaceBudgetMB;
        this.spaceUsedMB = spaceUsedMB;
        this.autoCaptureFilters = autoCaptureFilters;
        this.autoSpmEvolveTaskParameters = autoSpmEvolveTaskParameters;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Boolean getIsAutomaticInitialPlanCaptureEnabled() {
        return this.isAutomaticInitialPlanCaptureEnabled;
    }

    public Boolean getIsSqlPlanBaselinesUsageEnabled() {
        return this.isSqlPlanBaselinesUsageEnabled;
    }

    public Boolean getIsAutoSpmEvolveTaskEnabled() {
        return this.isAutoSpmEvolveTaskEnabled;
    }

    public Boolean getIsHighFrequencyAutoSpmEvolveTaskEnabled() {
        return this.isHighFrequencyAutoSpmEvolveTaskEnabled;
    }

    public Integer getPlanRetentionWeeks() {
        return this.planRetentionWeeks;
    }

    public Float getSpaceBudgetPercent() {
        return this.spaceBudgetPercent;
    }

    public Float getSpaceBudgetMB() {
        return this.spaceBudgetMB;
    }

    public Float getSpaceUsedMB() {
        return this.spaceUsedMB;
    }

    public List<AutomaticCaptureFilter> getAutoCaptureFilters() {
        return this.autoCaptureFilters;
    }

    public SpmEvolveTaskParameters getAutoSpmEvolveTaskParameters() {
        return this.autoSpmEvolveTaskParameters;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SqlPlanBaselineConfiguration(");
        sb.append("super=").append(super.toString());
        sb.append("isAutomaticInitialPlanCaptureEnabled=").append(String.valueOf(this.isAutomaticInitialPlanCaptureEnabled));
        sb.append(", isSqlPlanBaselinesUsageEnabled=").append(String.valueOf(this.isSqlPlanBaselinesUsageEnabled));
        sb.append(", isAutoSpmEvolveTaskEnabled=").append(String.valueOf(this.isAutoSpmEvolveTaskEnabled));
        sb.append(", isHighFrequencyAutoSpmEvolveTaskEnabled=").append(String.valueOf(this.isHighFrequencyAutoSpmEvolveTaskEnabled));
        sb.append(", planRetentionWeeks=").append(String.valueOf(this.planRetentionWeeks));
        sb.append(", spaceBudgetPercent=").append(String.valueOf(this.spaceBudgetPercent));
        sb.append(", spaceBudgetMB=").append(String.valueOf(this.spaceBudgetMB));
        sb.append(", spaceUsedMB=").append(String.valueOf(this.spaceUsedMB));
        sb.append(", autoCaptureFilters=").append(String.valueOf(this.autoCaptureFilters));
        sb.append(", autoSpmEvolveTaskParameters=").append(String.valueOf((Object)this.autoSpmEvolveTaskParameters));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SqlPlanBaselineConfiguration)) {
            return false;
        }
        SqlPlanBaselineConfiguration other = (SqlPlanBaselineConfiguration)((Object)o);
        return Objects.equals(this.isAutomaticInitialPlanCaptureEnabled, other.isAutomaticInitialPlanCaptureEnabled) && Objects.equals(this.isSqlPlanBaselinesUsageEnabled, other.isSqlPlanBaselinesUsageEnabled) && Objects.equals(this.isAutoSpmEvolveTaskEnabled, other.isAutoSpmEvolveTaskEnabled) && Objects.equals(this.isHighFrequencyAutoSpmEvolveTaskEnabled, other.isHighFrequencyAutoSpmEvolveTaskEnabled) && Objects.equals(this.planRetentionWeeks, other.planRetentionWeeks) && Objects.equals(this.spaceBudgetPercent, other.spaceBudgetPercent) && Objects.equals(this.spaceBudgetMB, other.spaceBudgetMB) && Objects.equals(this.spaceUsedMB, other.spaceUsedMB) && Objects.equals(this.autoCaptureFilters, other.autoCaptureFilters) && Objects.equals((Object)this.autoSpmEvolveTaskParameters, (Object)other.autoSpmEvolveTaskParameters) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAutomaticInitialPlanCaptureEnabled == null ? 43 : this.isAutomaticInitialPlanCaptureEnabled.hashCode());
        result = result * 59 + (this.isSqlPlanBaselinesUsageEnabled == null ? 43 : this.isSqlPlanBaselinesUsageEnabled.hashCode());
        result = result * 59 + (this.isAutoSpmEvolveTaskEnabled == null ? 43 : this.isAutoSpmEvolveTaskEnabled.hashCode());
        result = result * 59 + (this.isHighFrequencyAutoSpmEvolveTaskEnabled == null ? 43 : this.isHighFrequencyAutoSpmEvolveTaskEnabled.hashCode());
        result = result * 59 + (this.planRetentionWeeks == null ? 43 : this.planRetentionWeeks.hashCode());
        result = result * 59 + (this.spaceBudgetPercent == null ? 43 : this.spaceBudgetPercent.hashCode());
        result = result * 59 + (this.spaceBudgetMB == null ? 43 : this.spaceBudgetMB.hashCode());
        result = result * 59 + (this.spaceUsedMB == null ? 43 : this.spaceUsedMB.hashCode());
        result = result * 59 + (this.autoCaptureFilters == null ? 43 : this.autoCaptureFilters.hashCode());
        result = result * 59 + (this.autoSpmEvolveTaskParameters == null ? 43 : this.autoSpmEvolveTaskParameters.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="isAutomaticInitialPlanCaptureEnabled")
        private Boolean isAutomaticInitialPlanCaptureEnabled;
        @JsonProperty(value="isSqlPlanBaselinesUsageEnabled")
        private Boolean isSqlPlanBaselinesUsageEnabled;
        @JsonProperty(value="isAutoSpmEvolveTaskEnabled")
        private Boolean isAutoSpmEvolveTaskEnabled;
        @JsonProperty(value="isHighFrequencyAutoSpmEvolveTaskEnabled")
        private Boolean isHighFrequencyAutoSpmEvolveTaskEnabled;
        @JsonProperty(value="planRetentionWeeks")
        private Integer planRetentionWeeks;
        @JsonProperty(value="spaceBudgetPercent")
        private Float spaceBudgetPercent;
        @JsonProperty(value="spaceBudgetMB")
        private Float spaceBudgetMB;
        @JsonProperty(value="spaceUsedMB")
        private Float spaceUsedMB;
        @JsonProperty(value="autoCaptureFilters")
        private List<AutomaticCaptureFilter> autoCaptureFilters;
        @JsonProperty(value="autoSpmEvolveTaskParameters")
        private SpmEvolveTaskParameters autoSpmEvolveTaskParameters;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder isAutomaticInitialPlanCaptureEnabled(Boolean isAutomaticInitialPlanCaptureEnabled) {
            this.isAutomaticInitialPlanCaptureEnabled = isAutomaticInitialPlanCaptureEnabled;
            this.__explicitlySet__.add("isAutomaticInitialPlanCaptureEnabled");
            return this;
        }

        public Builder isSqlPlanBaselinesUsageEnabled(Boolean isSqlPlanBaselinesUsageEnabled) {
            this.isSqlPlanBaselinesUsageEnabled = isSqlPlanBaselinesUsageEnabled;
            this.__explicitlySet__.add("isSqlPlanBaselinesUsageEnabled");
            return this;
        }

        public Builder isAutoSpmEvolveTaskEnabled(Boolean isAutoSpmEvolveTaskEnabled) {
            this.isAutoSpmEvolveTaskEnabled = isAutoSpmEvolveTaskEnabled;
            this.__explicitlySet__.add("isAutoSpmEvolveTaskEnabled");
            return this;
        }

        public Builder isHighFrequencyAutoSpmEvolveTaskEnabled(Boolean isHighFrequencyAutoSpmEvolveTaskEnabled) {
            this.isHighFrequencyAutoSpmEvolveTaskEnabled = isHighFrequencyAutoSpmEvolveTaskEnabled;
            this.__explicitlySet__.add("isHighFrequencyAutoSpmEvolveTaskEnabled");
            return this;
        }

        public Builder planRetentionWeeks(Integer planRetentionWeeks) {
            this.planRetentionWeeks = planRetentionWeeks;
            this.__explicitlySet__.add("planRetentionWeeks");
            return this;
        }

        public Builder spaceBudgetPercent(Float spaceBudgetPercent) {
            this.spaceBudgetPercent = spaceBudgetPercent;
            this.__explicitlySet__.add("spaceBudgetPercent");
            return this;
        }

        public Builder spaceBudgetMB(Float spaceBudgetMB) {
            this.spaceBudgetMB = spaceBudgetMB;
            this.__explicitlySet__.add("spaceBudgetMB");
            return this;
        }

        public Builder spaceUsedMB(Float spaceUsedMB) {
            this.spaceUsedMB = spaceUsedMB;
            this.__explicitlySet__.add("spaceUsedMB");
            return this;
        }

        public Builder autoCaptureFilters(List<AutomaticCaptureFilter> autoCaptureFilters) {
            this.autoCaptureFilters = autoCaptureFilters;
            this.__explicitlySet__.add("autoCaptureFilters");
            return this;
        }

        public Builder autoSpmEvolveTaskParameters(SpmEvolveTaskParameters autoSpmEvolveTaskParameters) {
            this.autoSpmEvolveTaskParameters = autoSpmEvolveTaskParameters;
            this.__explicitlySet__.add("autoSpmEvolveTaskParameters");
            return this;
        }

        public SqlPlanBaselineConfiguration build() {
            SqlPlanBaselineConfiguration model = new SqlPlanBaselineConfiguration(this.isAutomaticInitialPlanCaptureEnabled, this.isSqlPlanBaselinesUsageEnabled, this.isAutoSpmEvolveTaskEnabled, this.isHighFrequencyAutoSpmEvolveTaskEnabled, this.planRetentionWeeks, this.spaceBudgetPercent, this.spaceBudgetMB, this.spaceUsedMB, this.autoCaptureFilters, this.autoSpmEvolveTaskParameters);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SqlPlanBaselineConfiguration model) {
            if (model.wasPropertyExplicitlySet("isAutomaticInitialPlanCaptureEnabled")) {
                this.isAutomaticInitialPlanCaptureEnabled(model.getIsAutomaticInitialPlanCaptureEnabled());
            }
            if (model.wasPropertyExplicitlySet("isSqlPlanBaselinesUsageEnabled")) {
                this.isSqlPlanBaselinesUsageEnabled(model.getIsSqlPlanBaselinesUsageEnabled());
            }
            if (model.wasPropertyExplicitlySet("isAutoSpmEvolveTaskEnabled")) {
                this.isAutoSpmEvolveTaskEnabled(model.getIsAutoSpmEvolveTaskEnabled());
            }
            if (model.wasPropertyExplicitlySet("isHighFrequencyAutoSpmEvolveTaskEnabled")) {
                this.isHighFrequencyAutoSpmEvolveTaskEnabled(model.getIsHighFrequencyAutoSpmEvolveTaskEnabled());
            }
            if (model.wasPropertyExplicitlySet("planRetentionWeeks")) {
                this.planRetentionWeeks(model.getPlanRetentionWeeks());
            }
            if (model.wasPropertyExplicitlySet("spaceBudgetPercent")) {
                this.spaceBudgetPercent(model.getSpaceBudgetPercent());
            }
            if (model.wasPropertyExplicitlySet("spaceBudgetMB")) {
                this.spaceBudgetMB(model.getSpaceBudgetMB());
            }
            if (model.wasPropertyExplicitlySet("spaceUsedMB")) {
                this.spaceUsedMB(model.getSpaceUsedMB());
            }
            if (model.wasPropertyExplicitlySet("autoCaptureFilters")) {
                this.autoCaptureFilters(model.getAutoCaptureFilters());
            }
            if (model.wasPropertyExplicitlySet("autoSpmEvolveTaskParameters")) {
                this.autoSpmEvolveTaskParameters(model.getAutoSpmEvolveTaskParameters());
            }
            return this;
        }
    }
}

