/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.SqlTuningSetStatusTypes;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SqlTuningSetSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="owner")
    private final String owner;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="statementCounts")
    private final Integer statementCounts;
    @JsonProperty(value="id")
    private final Integer id;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeLastModified")
    private final Date timeLastModified;
    @JsonProperty(value="status")
    private final SqlTuningSetStatusTypes status;
    @JsonProperty(value="scheduledJobName")
    private final String scheduledJobName;
    @JsonProperty(value="errorMessage")
    private final String errorMessage;

    @Deprecated
    @ConstructorProperties(value={"name", "owner", "description", "statementCounts", "id", "timeCreated", "timeLastModified", "status", "scheduledJobName", "errorMessage"})
    public SqlTuningSetSummary(String name, String owner, String description, Integer statementCounts, Integer id, Date timeCreated, Date timeLastModified, SqlTuningSetStatusTypes status, String scheduledJobName, String errorMessage) {
        this.name = name;
        this.owner = owner;
        this.description = description;
        this.statementCounts = statementCounts;
        this.id = id;
        this.timeCreated = timeCreated;
        this.timeLastModified = timeLastModified;
        this.status = status;
        this.scheduledJobName = scheduledJobName;
        this.errorMessage = errorMessage;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getStatementCounts() {
        return this.statementCounts;
    }

    public Integer getId() {
        return this.id;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeLastModified() {
        return this.timeLastModified;
    }

    public SqlTuningSetStatusTypes getStatus() {
        return this.status;
    }

    public String getScheduledJobName() {
        return this.scheduledJobName;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SqlTuningSetSummary(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", owner=").append(String.valueOf(this.owner));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", statementCounts=").append(String.valueOf(this.statementCounts));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeLastModified=").append(String.valueOf(this.timeLastModified));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", scheduledJobName=").append(String.valueOf(this.scheduledJobName));
        sb.append(", errorMessage=").append(String.valueOf(this.errorMessage));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SqlTuningSetSummary)) {
            return false;
        }
        SqlTuningSetSummary other = (SqlTuningSetSummary)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.owner, other.owner) && Objects.equals(this.description, other.description) && Objects.equals(this.statementCounts, other.statementCounts) && Objects.equals(this.id, other.id) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeLastModified, other.timeLastModified) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.scheduledJobName, other.scheduledJobName) && Objects.equals(this.errorMessage, other.errorMessage) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.owner == null ? 43 : this.owner.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.statementCounts == null ? 43 : this.statementCounts.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeLastModified == null ? 43 : this.timeLastModified.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.scheduledJobName == null ? 43 : this.scheduledJobName.hashCode());
        result = result * 59 + (this.errorMessage == null ? 43 : this.errorMessage.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="owner")
        private String owner;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="statementCounts")
        private Integer statementCounts;
        @JsonProperty(value="id")
        private Integer id;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeLastModified")
        private Date timeLastModified;
        @JsonProperty(value="status")
        private SqlTuningSetStatusTypes status;
        @JsonProperty(value="scheduledJobName")
        private String scheduledJobName;
        @JsonProperty(value="errorMessage")
        private String errorMessage;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            this.__explicitlySet__.add("owner");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder statementCounts(Integer statementCounts) {
            this.statementCounts = statementCounts;
            this.__explicitlySet__.add("statementCounts");
            return this;
        }

        public Builder id(Integer id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeLastModified(Date timeLastModified) {
            this.timeLastModified = timeLastModified;
            this.__explicitlySet__.add("timeLastModified");
            return this;
        }

        public Builder status(SqlTuningSetStatusTypes status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder scheduledJobName(String scheduledJobName) {
            this.scheduledJobName = scheduledJobName;
            this.__explicitlySet__.add("scheduledJobName");
            return this;
        }

        public Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            this.__explicitlySet__.add("errorMessage");
            return this;
        }

        public SqlTuningSetSummary build() {
            SqlTuningSetSummary model = new SqlTuningSetSummary(this.name, this.owner, this.description, this.statementCounts, this.id, this.timeCreated, this.timeLastModified, this.status, this.scheduledJobName, this.errorMessage);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SqlTuningSetSummary model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("owner")) {
                this.owner(model.getOwner());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("statementCounts")) {
                this.statementCounts(model.getStatementCounts());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeLastModified")) {
                this.timeLastModified(model.getTimeLastModified());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("scheduledJobName")) {
                this.scheduledJobName(model.getScheduledJobName());
            }
            if (model.wasPropertyExplicitlySet("errorMessage")) {
                this.errorMessage(model.getErrorMessage());
            }
            return this;
        }
    }
}

