/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.JobExecutionResultLocation;
import com.oracle.bmc.databasemanagement.model.JobInBindsDetails;
import com.oracle.bmc.databasemanagement.model.JobOutBindsDetails;
import com.oracle.bmc.databasemanagement.model.JobScheduleDetails;
import com.oracle.bmc.databasemanagement.model.SqlJob;
import com.oracle.bmc.databasemanagement.model.UpdateJobDetails;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="jobType")
@JsonFilter(value="explicitlySetFilter")
public final class UpdateSqlJobDetails
extends UpdateJobDetails {
    @JsonProperty(value="sqlText")
    private final String sqlText;
    @JsonProperty(value="inBinds")
    private final JobInBindsDetails inBinds;
    @JsonProperty(value="outBinds")
    private final JobOutBindsDetails outBinds;
    @JsonProperty(value="sqlType")
    private final SqlJob.SqlType sqlType;
    @JsonProperty(value="userName")
    private final String userName;
    @JsonProperty(value="password")
    private final String password;
    @JsonProperty(value="secretId")
    private final String secretId;
    @JsonProperty(value="namedCredentialId")
    private final String namedCredentialId;
    @JsonProperty(value="role")
    private final SqlJob.Role role;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public UpdateSqlJobDetails(String description, String timeout, JobExecutionResultLocation resultLocation, JobScheduleDetails scheduleDetails, String sqlText, JobInBindsDetails inBinds, JobOutBindsDetails outBinds, SqlJob.SqlType sqlType, String userName, String password, String secretId, String namedCredentialId, SqlJob.Role role, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        super(description, timeout, resultLocation, scheduleDetails);
        this.sqlText = sqlText;
        this.inBinds = inBinds;
        this.outBinds = outBinds;
        this.sqlType = sqlType;
        this.userName = userName;
        this.password = password;
        this.secretId = secretId;
        this.namedCredentialId = namedCredentialId;
        this.role = role;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public String getSqlText() {
        return this.sqlText;
    }

    public JobInBindsDetails getInBinds() {
        return this.inBinds;
    }

    public JobOutBindsDetails getOutBinds() {
        return this.outBinds;
    }

    public SqlJob.SqlType getSqlType() {
        return this.sqlType;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getSecretId() {
        return this.secretId;
    }

    public String getNamedCredentialId() {
        return this.namedCredentialId;
    }

    public SqlJob.Role getRole() {
        return this.role;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateSqlJobDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", sqlText=").append(String.valueOf(this.sqlText));
        sb.append(", inBinds=").append(String.valueOf((Object)this.inBinds));
        sb.append(", outBinds=").append(String.valueOf((Object)this.outBinds));
        sb.append(", sqlType=").append(String.valueOf((Object)this.sqlType));
        sb.append(", userName=").append(String.valueOf(this.userName));
        sb.append(", password=").append(String.valueOf(this.password));
        sb.append(", secretId=").append(String.valueOf(this.secretId));
        sb.append(", namedCredentialId=").append(String.valueOf(this.namedCredentialId));
        sb.append(", role=").append(String.valueOf((Object)this.role));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateSqlJobDetails)) {
            return false;
        }
        UpdateSqlJobDetails other = (UpdateSqlJobDetails)((Object)o);
        return Objects.equals(this.sqlText, other.sqlText) && Objects.equals((Object)this.inBinds, (Object)other.inBinds) && Objects.equals((Object)this.outBinds, (Object)other.outBinds) && Objects.equals((Object)this.sqlType, (Object)other.sqlType) && Objects.equals(this.userName, other.userName) && Objects.equals(this.password, other.password) && Objects.equals(this.secretId, other.secretId) && Objects.equals(this.namedCredentialId, other.namedCredentialId) && Objects.equals((Object)this.role, (Object)other.role) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.sqlText == null ? 43 : this.sqlText.hashCode());
        result = result * 59 + (this.inBinds == null ? 43 : this.inBinds.hashCode());
        result = result * 59 + (this.outBinds == null ? 43 : this.outBinds.hashCode());
        result = result * 59 + (this.sqlType == null ? 43 : this.sqlType.hashCode());
        result = result * 59 + (this.userName == null ? 43 : this.userName.hashCode());
        result = result * 59 + (this.password == null ? 43 : this.password.hashCode());
        result = result * 59 + (this.secretId == null ? 43 : this.secretId.hashCode());
        result = result * 59 + (this.namedCredentialId == null ? 43 : this.namedCredentialId.hashCode());
        result = result * 59 + (this.role == null ? 43 : this.role.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="timeout")
        private String timeout;
        @JsonProperty(value="resultLocation")
        private JobExecutionResultLocation resultLocation;
        @JsonProperty(value="scheduleDetails")
        private JobScheduleDetails scheduleDetails;
        @JsonProperty(value="sqlText")
        private String sqlText;
        @JsonProperty(value="inBinds")
        private JobInBindsDetails inBinds;
        @JsonProperty(value="outBinds")
        private JobOutBindsDetails outBinds;
        @JsonProperty(value="sqlType")
        private SqlJob.SqlType sqlType;
        @JsonProperty(value="userName")
        private String userName;
        @JsonProperty(value="password")
        private String password;
        @JsonProperty(value="secretId")
        private String secretId;
        @JsonProperty(value="namedCredentialId")
        private String namedCredentialId;
        @JsonProperty(value="role")
        private SqlJob.Role role;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder timeout(String timeout) {
            this.timeout = timeout;
            this.__explicitlySet__.add("timeout");
            return this;
        }

        public Builder resultLocation(JobExecutionResultLocation resultLocation) {
            this.resultLocation = resultLocation;
            this.__explicitlySet__.add("resultLocation");
            return this;
        }

        public Builder scheduleDetails(JobScheduleDetails scheduleDetails) {
            this.scheduleDetails = scheduleDetails;
            this.__explicitlySet__.add("scheduleDetails");
            return this;
        }

        public Builder sqlText(String sqlText) {
            this.sqlText = sqlText;
            this.__explicitlySet__.add("sqlText");
            return this;
        }

        public Builder inBinds(JobInBindsDetails inBinds) {
            this.inBinds = inBinds;
            this.__explicitlySet__.add("inBinds");
            return this;
        }

        public Builder outBinds(JobOutBindsDetails outBinds) {
            this.outBinds = outBinds;
            this.__explicitlySet__.add("outBinds");
            return this;
        }

        public Builder sqlType(SqlJob.SqlType sqlType) {
            this.sqlType = sqlType;
            this.__explicitlySet__.add("sqlType");
            return this;
        }

        public Builder userName(String userName) {
            this.userName = userName;
            this.__explicitlySet__.add("userName");
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            this.__explicitlySet__.add("password");
            return this;
        }

        public Builder secretId(String secretId) {
            this.secretId = secretId;
            this.__explicitlySet__.add("secretId");
            return this;
        }

        public Builder namedCredentialId(String namedCredentialId) {
            this.namedCredentialId = namedCredentialId;
            this.__explicitlySet__.add("namedCredentialId");
            return this;
        }

        public Builder role(SqlJob.Role role) {
            this.role = role;
            this.__explicitlySet__.add("role");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public UpdateSqlJobDetails build() {
            UpdateSqlJobDetails model = new UpdateSqlJobDetails(this.description, this.timeout, this.resultLocation, this.scheduleDetails, this.sqlText, this.inBinds, this.outBinds, this.sqlType, this.userName, this.password, this.secretId, this.namedCredentialId, this.role, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateSqlJobDetails model) {
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("timeout")) {
                this.timeout(model.getTimeout());
            }
            if (model.wasPropertyExplicitlySet("resultLocation")) {
                this.resultLocation(model.getResultLocation());
            }
            if (model.wasPropertyExplicitlySet("scheduleDetails")) {
                this.scheduleDetails(model.getScheduleDetails());
            }
            if (model.wasPropertyExplicitlySet("sqlText")) {
                this.sqlText(model.getSqlText());
            }
            if (model.wasPropertyExplicitlySet("inBinds")) {
                this.inBinds(model.getInBinds());
            }
            if (model.wasPropertyExplicitlySet("outBinds")) {
                this.outBinds(model.getOutBinds());
            }
            if (model.wasPropertyExplicitlySet("sqlType")) {
                this.sqlType(model.getSqlType());
            }
            if (model.wasPropertyExplicitlySet("userName")) {
                this.userName(model.getUserName());
            }
            if (model.wasPropertyExplicitlySet("password")) {
                this.password(model.getPassword());
            }
            if (model.wasPropertyExplicitlySet("secretId")) {
                this.secretId(model.getSecretId());
            }
            if (model.wasPropertyExplicitlySet("namedCredentialId")) {
                this.namedCredentialId(model.getNamedCredentialId());
            }
            if (model.wasPropertyExplicitlySet("role")) {
                this.role(model.getRole());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

