/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetAwrDbReportRequest
extends BmcRequest<Void> {
    private String managedDatabaseId;
    private String awrDbId;
    private List<Integer> instNums;
    private Integer beginSnIdGreaterThanOrEqualTo;
    private Integer endSnIdLessThanOrEqualTo;
    private Date timeGreaterThanOrEqualTo;
    private Date timeLessThanOrEqualTo;
    private ReportType reportType;
    private Integer containerId;
    private ReportFormat reportFormat;
    private String opcRequestId;
    private String opcRetryToken;
    private String opcNamedCredentialId;

    public String getManagedDatabaseId() {
        return this.managedDatabaseId;
    }

    public String getAwrDbId() {
        return this.awrDbId;
    }

    public List<Integer> getInstNums() {
        return this.instNums;
    }

    public Integer getBeginSnIdGreaterThanOrEqualTo() {
        return this.beginSnIdGreaterThanOrEqualTo;
    }

    public Integer getEndSnIdLessThanOrEqualTo() {
        return this.endSnIdLessThanOrEqualTo;
    }

    public Date getTimeGreaterThanOrEqualTo() {
        return this.timeGreaterThanOrEqualTo;
    }

    public Date getTimeLessThanOrEqualTo() {
        return this.timeLessThanOrEqualTo;
    }

    public ReportType getReportType() {
        return this.reportType;
    }

    public Integer getContainerId() {
        return this.containerId;
    }

    public ReportFormat getReportFormat() {
        return this.reportFormat;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcNamedCredentialId() {
        return this.opcNamedCredentialId;
    }

    public Builder toBuilder() {
        return new Builder().managedDatabaseId(this.managedDatabaseId).awrDbId(this.awrDbId).instNums(this.instNums).beginSnIdGreaterThanOrEqualTo(this.beginSnIdGreaterThanOrEqualTo).endSnIdLessThanOrEqualTo(this.endSnIdLessThanOrEqualTo).timeGreaterThanOrEqualTo(this.timeGreaterThanOrEqualTo).timeLessThanOrEqualTo(this.timeLessThanOrEqualTo).reportType(this.reportType).containerId(this.containerId).reportFormat(this.reportFormat).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken).opcNamedCredentialId(this.opcNamedCredentialId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",managedDatabaseId=").append(String.valueOf(this.managedDatabaseId));
        sb.append(",awrDbId=").append(String.valueOf(this.awrDbId));
        sb.append(",instNums=").append(String.valueOf(this.instNums));
        sb.append(",beginSnIdGreaterThanOrEqualTo=").append(String.valueOf(this.beginSnIdGreaterThanOrEqualTo));
        sb.append(",endSnIdLessThanOrEqualTo=").append(String.valueOf(this.endSnIdLessThanOrEqualTo));
        sb.append(",timeGreaterThanOrEqualTo=").append(String.valueOf(this.timeGreaterThanOrEqualTo));
        sb.append(",timeLessThanOrEqualTo=").append(String.valueOf(this.timeLessThanOrEqualTo));
        sb.append(",reportType=").append(String.valueOf((Object)this.reportType));
        sb.append(",containerId=").append(String.valueOf(this.containerId));
        sb.append(",reportFormat=").append(String.valueOf((Object)this.reportFormat));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcNamedCredentialId=").append(String.valueOf(this.opcNamedCredentialId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetAwrDbReportRequest)) {
            return false;
        }
        GetAwrDbReportRequest other = (GetAwrDbReportRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.managedDatabaseId, other.managedDatabaseId) && Objects.equals(this.awrDbId, other.awrDbId) && Objects.equals(this.instNums, other.instNums) && Objects.equals(this.beginSnIdGreaterThanOrEqualTo, other.beginSnIdGreaterThanOrEqualTo) && Objects.equals(this.endSnIdLessThanOrEqualTo, other.endSnIdLessThanOrEqualTo) && Objects.equals(this.timeGreaterThanOrEqualTo, other.timeGreaterThanOrEqualTo) && Objects.equals(this.timeLessThanOrEqualTo, other.timeLessThanOrEqualTo) && Objects.equals((Object)this.reportType, (Object)other.reportType) && Objects.equals(this.containerId, other.containerId) && Objects.equals((Object)this.reportFormat, (Object)other.reportFormat) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcNamedCredentialId, other.opcNamedCredentialId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.managedDatabaseId == null ? 43 : this.managedDatabaseId.hashCode());
        result = result * 59 + (this.awrDbId == null ? 43 : this.awrDbId.hashCode());
        result = result * 59 + (this.instNums == null ? 43 : this.instNums.hashCode());
        result = result * 59 + (this.beginSnIdGreaterThanOrEqualTo == null ? 43 : this.beginSnIdGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.endSnIdLessThanOrEqualTo == null ? 43 : this.endSnIdLessThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeGreaterThanOrEqualTo == null ? 43 : this.timeGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeLessThanOrEqualTo == null ? 43 : this.timeLessThanOrEqualTo.hashCode());
        result = result * 59 + (this.reportType == null ? 43 : this.reportType.hashCode());
        result = result * 59 + (this.containerId == null ? 43 : this.containerId.hashCode());
        result = result * 59 + (this.reportFormat == null ? 43 : this.reportFormat.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcNamedCredentialId == null ? 43 : this.opcNamedCredentialId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetAwrDbReportRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String managedDatabaseId = null;
        private String awrDbId = null;
        private List<Integer> instNums = null;
        private Integer beginSnIdGreaterThanOrEqualTo = null;
        private Integer endSnIdLessThanOrEqualTo = null;
        private Date timeGreaterThanOrEqualTo = null;
        private Date timeLessThanOrEqualTo = null;
        private ReportType reportType = null;
        private Integer containerId = null;
        private ReportFormat reportFormat = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;
        private String opcNamedCredentialId = null;

        public Builder managedDatabaseId(String managedDatabaseId) {
            this.managedDatabaseId = managedDatabaseId;
            return this;
        }

        public Builder awrDbId(String awrDbId) {
            this.awrDbId = awrDbId;
            return this;
        }

        public Builder instNums(List<Integer> instNums) {
            this.instNums = instNums;
            return this;
        }

        public Builder instNums(Integer singularValue) {
            return this.instNums(Arrays.asList(singularValue));
        }

        public Builder beginSnIdGreaterThanOrEqualTo(Integer beginSnIdGreaterThanOrEqualTo) {
            this.beginSnIdGreaterThanOrEqualTo = beginSnIdGreaterThanOrEqualTo;
            return this;
        }

        public Builder endSnIdLessThanOrEqualTo(Integer endSnIdLessThanOrEqualTo) {
            this.endSnIdLessThanOrEqualTo = endSnIdLessThanOrEqualTo;
            return this;
        }

        public Builder timeGreaterThanOrEqualTo(Date timeGreaterThanOrEqualTo) {
            this.timeGreaterThanOrEqualTo = timeGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeLessThanOrEqualTo(Date timeLessThanOrEqualTo) {
            this.timeLessThanOrEqualTo = timeLessThanOrEqualTo;
            return this;
        }

        public Builder reportType(ReportType reportType) {
            this.reportType = reportType;
            return this;
        }

        public Builder containerId(Integer containerId) {
            this.containerId = containerId;
            return this;
        }

        public Builder reportFormat(ReportFormat reportFormat) {
            this.reportFormat = reportFormat;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcNamedCredentialId(String opcNamedCredentialId) {
            this.opcNamedCredentialId = opcNamedCredentialId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetAwrDbReportRequest o) {
            this.managedDatabaseId(o.getManagedDatabaseId());
            this.awrDbId(o.getAwrDbId());
            this.instNums(o.getInstNums());
            this.beginSnIdGreaterThanOrEqualTo(o.getBeginSnIdGreaterThanOrEqualTo());
            this.endSnIdLessThanOrEqualTo(o.getEndSnIdLessThanOrEqualTo());
            this.timeGreaterThanOrEqualTo(o.getTimeGreaterThanOrEqualTo());
            this.timeLessThanOrEqualTo(o.getTimeLessThanOrEqualTo());
            this.reportType(o.getReportType());
            this.containerId(o.getContainerId());
            this.reportFormat(o.getReportFormat());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcNamedCredentialId(o.getOpcNamedCredentialId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetAwrDbReportRequest build() {
            GetAwrDbReportRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetAwrDbReportRequest buildWithoutInvocationCallback() {
            GetAwrDbReportRequest request = new GetAwrDbReportRequest();
            request.managedDatabaseId = this.managedDatabaseId;
            request.awrDbId = this.awrDbId;
            request.instNums = this.instNums;
            request.beginSnIdGreaterThanOrEqualTo = this.beginSnIdGreaterThanOrEqualTo;
            request.endSnIdLessThanOrEqualTo = this.endSnIdLessThanOrEqualTo;
            request.timeGreaterThanOrEqualTo = this.timeGreaterThanOrEqualTo;
            request.timeLessThanOrEqualTo = this.timeLessThanOrEqualTo;
            request.reportType = this.reportType;
            request.containerId = this.containerId;
            request.reportFormat = this.reportFormat;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            request.opcNamedCredentialId = this.opcNamedCredentialId;
            return request;
        }
    }

    public static enum ReportFormat implements BmcEnum
    {
        Html("HTML"),
        Text("TEXT");

        private final String value;
        private static Map<String, ReportFormat> map;

        private ReportFormat(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ReportFormat create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ReportFormat: " + key);
        }

        static {
            map = new HashMap<String, ReportFormat>();
            for (ReportFormat v : ReportFormat.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ReportType implements BmcEnum
    {
        Awr("AWR"),
        Ash("ASH");

        private final String value;
        private static Map<String, ReportType> map;

        private ReportType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ReportType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ReportType: " + key);
        }

        static {
            map = new HashMap<String, ReportType>();
            for (ReportType v : ReportType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

