/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetExternalAsmRequest
extends BmcRequest<Void> {
    private String externalAsmId;
    private String opcRequestId;

    public String getExternalAsmId() {
        return this.externalAsmId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().externalAsmId(this.externalAsmId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",externalAsmId=").append(String.valueOf(this.externalAsmId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetExternalAsmRequest)) {
            return false;
        }
        GetExternalAsmRequest other = (GetExternalAsmRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.externalAsmId, other.externalAsmId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.externalAsmId == null ? 43 : this.externalAsmId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetExternalAsmRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String externalAsmId = null;
        private String opcRequestId = null;

        public Builder externalAsmId(String externalAsmId) {
            this.externalAsmId = externalAsmId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetExternalAsmRequest o) {
            this.externalAsmId(o.getExternalAsmId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetExternalAsmRequest build() {
            GetExternalAsmRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetExternalAsmRequest buildWithoutInvocationCallback() {
            GetExternalAsmRequest request = new GetExternalAsmRequest();
            request.externalAsmId = this.externalAsmId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

