/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetManagedDatabaseGroupRequest
extends BmcRequest<Void> {
    private String managedDatabaseGroupId;
    private String opcRequestId;

    public String getManagedDatabaseGroupId() {
        return this.managedDatabaseGroupId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().managedDatabaseGroupId(this.managedDatabaseGroupId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",managedDatabaseGroupId=").append(String.valueOf(this.managedDatabaseGroupId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetManagedDatabaseGroupRequest)) {
            return false;
        }
        GetManagedDatabaseGroupRequest other = (GetManagedDatabaseGroupRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.managedDatabaseGroupId, other.managedDatabaseGroupId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.managedDatabaseGroupId == null ? 43 : this.managedDatabaseGroupId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetManagedDatabaseGroupRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String managedDatabaseGroupId = null;
        private String opcRequestId = null;

        public Builder managedDatabaseGroupId(String managedDatabaseGroupId) {
            this.managedDatabaseGroupId = managedDatabaseGroupId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetManagedDatabaseGroupRequest o) {
            this.managedDatabaseGroupId(o.getManagedDatabaseGroupId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetManagedDatabaseGroupRequest build() {
            GetManagedDatabaseGroupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetManagedDatabaseGroupRequest buildWithoutInvocationCallback() {
            GetManagedDatabaseGroupRequest request = new GetManagedDatabaseGroupRequest();
            request.managedDatabaseGroupId = this.managedDatabaseGroupId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

