/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.responses;

import com.oracle.bmc.databasemanagement.model.NamedCredential;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CreateNamedCredentialResponse
extends BmcResponse {
    private String opcRequestId;
    private String etag;
    private String location;
    private NamedCredential namedCredential;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public String getLocation() {
        return this.location;
    }

    public NamedCredential getNamedCredential() {
        return this.namedCredential;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "etag", "location", "namedCredential"})
    private CreateNamedCredentialResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, String etag, String location, NamedCredential namedCredential) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.location = location;
        this.namedCredential = namedCredential;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",location=").append(String.valueOf(this.location));
        sb.append(",namedCredential=").append(String.valueOf((Object)this.namedCredential));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateNamedCredentialResponse)) {
            return false;
        }
        CreateNamedCredentialResponse other = (CreateNamedCredentialResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.etag, other.etag) && Objects.equals(this.location, other.location) && Objects.equals((Object)this.namedCredential, (Object)other.namedCredential);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.location == null ? 43 : this.location.hashCode());
        result = result * 59 + (this.namedCredential == null ? 43 : this.namedCredential.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<CreateNamedCredentialResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private String etag;
        private String location;
        private NamedCredential namedCredential;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public Builder namedCredential(NamedCredential namedCredential) {
            this.namedCredential = namedCredential;
            return this;
        }

        public Builder copy(CreateNamedCredentialResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.location(o.getLocation());
            this.namedCredential(o.getNamedCredential());
            return this;
        }

        public CreateNamedCredentialResponse build() {
            return new CreateNamedCredentialResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.etag, this.location, this.namedCredential);
        }
    }
}

