/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.responses;

import com.oracle.bmc.databasemanagement.model.ManagedDatabase;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class UpdateManagedDatabaseResponse
extends BmcResponse {
    private String opcRequestId;
    private String etag;
    private ManagedDatabase managedDatabase;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public ManagedDatabase getManagedDatabase() {
        return this.managedDatabase;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "etag", "managedDatabase"})
    private UpdateManagedDatabaseResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, String etag, ManagedDatabase managedDatabase) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.managedDatabase = managedDatabase;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",managedDatabase=").append(String.valueOf((Object)this.managedDatabase));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateManagedDatabaseResponse)) {
            return false;
        }
        UpdateManagedDatabaseResponse other = (UpdateManagedDatabaseResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.etag, other.etag) && Objects.equals((Object)this.managedDatabase, (Object)other.managedDatabase);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.managedDatabase == null ? 43 : this.managedDatabase.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<UpdateManagedDatabaseResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private String etag;
        private ManagedDatabase managedDatabase;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder managedDatabase(ManagedDatabase managedDatabase) {
            this.managedDatabase = managedDatabase;
            return this;
        }

        public Builder copy(UpdateManagedDatabaseResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.managedDatabase(o.getManagedDatabase());
            return this;
        }

        public UpdateManagedDatabaseResponse build() {
            return new UpdateManagedDatabaseResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.etag, this.managedDatabase);
        }
    }
}

