/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemigration;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.databasemigration.DatabaseMigration;
import com.oracle.bmc.databasemigration.DatabaseMigrationPaginators;
import com.oracle.bmc.databasemigration.DatabaseMigrationWaiters;
import com.oracle.bmc.databasemigration.model.AdvisorReport;
import com.oracle.bmc.databasemigration.model.Connection;
import com.oracle.bmc.databasemigration.model.ConnectionCollection;
import com.oracle.bmc.databasemigration.model.DiagnosticsResult;
import com.oracle.bmc.databasemigration.model.ExcludedObjectSummaryCollection;
import com.oracle.bmc.databasemigration.model.Job;
import com.oracle.bmc.databasemigration.model.JobCollection;
import com.oracle.bmc.databasemigration.model.JobOutputSummaryCollection;
import com.oracle.bmc.databasemigration.model.Migration;
import com.oracle.bmc.databasemigration.model.MigrationCollection;
import com.oracle.bmc.databasemigration.model.MigrationObjectCollection;
import com.oracle.bmc.databasemigration.model.MigrationObjectTypeSummaryCollection;
import com.oracle.bmc.databasemigration.model.MigrationPhaseCollection;
import com.oracle.bmc.databasemigration.model.WorkRequest;
import com.oracle.bmc.databasemigration.model.WorkRequestCollection;
import com.oracle.bmc.databasemigration.model.WorkRequestErrorCollection;
import com.oracle.bmc.databasemigration.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.databasemigration.requests.AbortJobRequest;
import com.oracle.bmc.databasemigration.requests.AddMigrationObjectsRequest;
import com.oracle.bmc.databasemigration.requests.ChangeConnectionCompartmentRequest;
import com.oracle.bmc.databasemigration.requests.ChangeMigrationCompartmentRequest;
import com.oracle.bmc.databasemigration.requests.CloneMigrationRequest;
import com.oracle.bmc.databasemigration.requests.ConnectionDiagnosticsRequest;
import com.oracle.bmc.databasemigration.requests.CreateConnectionRequest;
import com.oracle.bmc.databasemigration.requests.CreateMigrationRequest;
import com.oracle.bmc.databasemigration.requests.DeleteConnectionRequest;
import com.oracle.bmc.databasemigration.requests.DeleteJobRequest;
import com.oracle.bmc.databasemigration.requests.DeleteMigrationRequest;
import com.oracle.bmc.databasemigration.requests.EvaluateMigrationRequest;
import com.oracle.bmc.databasemigration.requests.GetAdvisorReportRequest;
import com.oracle.bmc.databasemigration.requests.GetConnectionRequest;
import com.oracle.bmc.databasemigration.requests.GetJobOutputContentRequest;
import com.oracle.bmc.databasemigration.requests.GetJobRequest;
import com.oracle.bmc.databasemigration.requests.GetMigrationRequest;
import com.oracle.bmc.databasemigration.requests.GetWorkRequestRequest;
import com.oracle.bmc.databasemigration.requests.ListConnectionsRequest;
import com.oracle.bmc.databasemigration.requests.ListExcludedObjectsRequest;
import com.oracle.bmc.databasemigration.requests.ListJobOutputsRequest;
import com.oracle.bmc.databasemigration.requests.ListJobsRequest;
import com.oracle.bmc.databasemigration.requests.ListMigrationObjectTypesRequest;
import com.oracle.bmc.databasemigration.requests.ListMigrationObjectsRequest;
import com.oracle.bmc.databasemigration.requests.ListMigrationsRequest;
import com.oracle.bmc.databasemigration.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.databasemigration.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.databasemigration.requests.ListWorkRequestsRequest;
import com.oracle.bmc.databasemigration.requests.RemoveMigrationObjectsRequest;
import com.oracle.bmc.databasemigration.requests.ResumeJobRequest;
import com.oracle.bmc.databasemigration.requests.RetrieveSupportedPhasesRequest;
import com.oracle.bmc.databasemigration.requests.StartMigrationRequest;
import com.oracle.bmc.databasemigration.requests.UpdateConnectionRequest;
import com.oracle.bmc.databasemigration.requests.UpdateJobRequest;
import com.oracle.bmc.databasemigration.requests.UpdateMigrationRequest;
import com.oracle.bmc.databasemigration.responses.AbortJobResponse;
import com.oracle.bmc.databasemigration.responses.AddMigrationObjectsResponse;
import com.oracle.bmc.databasemigration.responses.ChangeConnectionCompartmentResponse;
import com.oracle.bmc.databasemigration.responses.ChangeMigrationCompartmentResponse;
import com.oracle.bmc.databasemigration.responses.CloneMigrationResponse;
import com.oracle.bmc.databasemigration.responses.ConnectionDiagnosticsResponse;
import com.oracle.bmc.databasemigration.responses.CreateConnectionResponse;
import com.oracle.bmc.databasemigration.responses.CreateMigrationResponse;
import com.oracle.bmc.databasemigration.responses.DeleteConnectionResponse;
import com.oracle.bmc.databasemigration.responses.DeleteJobResponse;
import com.oracle.bmc.databasemigration.responses.DeleteMigrationResponse;
import com.oracle.bmc.databasemigration.responses.EvaluateMigrationResponse;
import com.oracle.bmc.databasemigration.responses.GetAdvisorReportResponse;
import com.oracle.bmc.databasemigration.responses.GetConnectionResponse;
import com.oracle.bmc.databasemigration.responses.GetJobOutputContentResponse;
import com.oracle.bmc.databasemigration.responses.GetJobResponse;
import com.oracle.bmc.databasemigration.responses.GetMigrationResponse;
import com.oracle.bmc.databasemigration.responses.GetWorkRequestResponse;
import com.oracle.bmc.databasemigration.responses.ListConnectionsResponse;
import com.oracle.bmc.databasemigration.responses.ListExcludedObjectsResponse;
import com.oracle.bmc.databasemigration.responses.ListJobOutputsResponse;
import com.oracle.bmc.databasemigration.responses.ListJobsResponse;
import com.oracle.bmc.databasemigration.responses.ListMigrationObjectTypesResponse;
import com.oracle.bmc.databasemigration.responses.ListMigrationObjectsResponse;
import com.oracle.bmc.databasemigration.responses.ListMigrationsResponse;
import com.oracle.bmc.databasemigration.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.databasemigration.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.databasemigration.responses.ListWorkRequestsResponse;
import com.oracle.bmc.databasemigration.responses.RemoveMigrationObjectsResponse;
import com.oracle.bmc.databasemigration.responses.ResumeJobResponse;
import com.oracle.bmc.databasemigration.responses.RetrieveSupportedPhasesResponse;
import com.oracle.bmc.databasemigration.responses.StartMigrationResponse;
import com.oracle.bmc.databasemigration.responses.UpdateConnectionResponse;
import com.oracle.bmc.databasemigration.responses.UpdateJobResponse;
import com.oracle.bmc.databasemigration.responses.UpdateMigrationResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.StreamUtils;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseMigrationClient
extends BaseSyncClient
implements DatabaseMigration {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DATABASEMIGRATION").serviceEndpointPrefix("").serviceEndpointTemplate("https://odms.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseMigrationClient.class);
    private final DatabaseMigrationWaiters waiters;
    private final DatabaseMigrationPaginators paginators;

    DatabaseMigrationClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        this(builder, authenticationDetailsProvider, executorService, true);
    }

    DatabaseMigrationClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService, boolean isStreamWarningEnabled) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("DatabaseMigration-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new DatabaseMigrationWaiters(executorService, this);
        this.paginators = new DatabaseMigrationPaginators(this);
        if (isStreamWarningEnabled && StreamUtils.isExtraStreamLogsEnabled()) {
            LOG.warn(StreamUtils.getStreamWarningMessage((String)"DatabaseMigrationClient", (String)"getJobOutputContent"));
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public AbortJobResponse abortJob(AbortJobRequest request) {
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        return (AbortJobResponse)this.clientCall(request, AbortJobResponse::builder).logger(LOG, "abortJob").serviceDetails("DatabaseMigration", "AbortJob", "https://docs.oracle.com/iaas/api/#/en/database-migration/20230518/Job/AbortJob").method(Method.POST).requestBuilder(AbortJobRequest::builder).basePath("/20230518").appendPathParam("jobs").appendPathParam(request.getJobId()).appendPathParam("actions").appendPathParam("abort").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(Job.class, AbortJobResponse.Builder::job).handleResponseHeaderString("opc-request-id", AbortJobResponse.Builder::opcRequestId).handleResponseHeaderString("etag", AbortJobResponse.Builder::etag).callSync();
    }

    @Override
    public AddMigrationObjectsResponse addMigrationObjects(AddMigrationObjectsRequest request) {
        Validate.notBlank((String)request.getMigrationId(), (String)"migrationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddMigrationObjectsDetails(), "addMigrationObjectsDetails is required");
        return (AddMigrationObjectsResponse)this.clientCall(request, AddMigrationObjectsResponse::builder).logger(LOG, "addMigrationObjects").serviceDetails("DatabaseMigration", "AddMigrationObjects", "https://docs.oracle.com/iaas/api/#/en/database-migration/20230518/Migration/AddMigrationObjects").method(Method.POST).requestBuilder(AddMigrationObjectsRequest::builder).basePath("/20230518").appendPathParam("migrations").appendPathParam(request.getMigrationId()).appendPathParam("actions").appendPathParam("addMigrationObjects").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", AddMigrationObjectsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeConnectionCompartmentResponse changeConnectionCompartment(ChangeConnectionCompartmentRequest request) {
        Validate.notBlank((String)request.getConnectionId(), (String)"connectionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeConnectionCompartmentDetails(), "changeConnectionCompartmentDetails is required");
        return (ChangeConnectionCompartmentResponse)this.clientCall(request, ChangeConnectionCompartmentResponse::builder).logger(LOG, "changeConnectionCompartment").serviceDetails("DatabaseMigration", "ChangeConnectionCompartment", "https://docs.oracle.com/iaas/api/#/en/database-migration/20230518/Connection/ChangeConnectionCompartment").method(Method.POST).requestBuilder(ChangeConnectionCompartmentRequest::builder).basePath("/20230518").appendPathParam("connections").appendPathParam(request.getConnectionId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", ChangeConnectionCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeMigrationCompartmentResponse changeMigrationCompartment(ChangeMigrationCompartmentRequest request) {
        Validate.notBlank((String)request.getMigrationId(), (String)"migrationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeMigrationCompartmentDetails(), "changeMigrationCompartmentDetails is required");
        return (ChangeMigrationCompartmentResponse)this.clientCall(request, ChangeMigrationCompartmentResponse::builder).logger(LOG, "changeMigrationCompartment").serviceDetails("DatabaseMigration", "ChangeMigrationCompartment", "https://docs.oracle.com/iaas/api/#/en/database-migration/20230518/Migration/ChangeMigrationCompartment").method(Method.POST).requestBuilder(ChangeMigrationCompartmentRequest::builder).basePath("/20230518").appendPathParam("migrations").appendPathParam(request.getMigrationId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", ChangeMigrationCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CloneMigrationResponse cloneMigration(CloneMigrationRequest request) {
        Validate.notBlank((String)request.getMigrationId(), (String)"migrationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCloneMigrationDetails(), "cloneMigrationDetails is required");
        return (CloneMigrationResponse)this.clientCall(request, CloneMigrationResponse::builder).logger(LOG, "cloneMigration").serviceDetails("DatabaseMigration", "CloneMigration", "https://docs.oracle.com/iaas/api/#/en/database-migration/20230518/Migration/CloneMigration").method(Method.POST).requestBuilder(CloneMigrationRequest::builder).basePath("/20230518").appendPathParam("migrations").appendPathParam(request.getMigrationId()).appendPathParam("actions").appendPathParam("clone").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(Migration.class, CloneMigrationResponse.Builder::migration).handleResponseHeaderString("opc-request-id", CloneMigrationResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CloneMigrationResponse.Builder::opcWorkRequestId).handleResponseHeaderString("etag", CloneMigrationResponse.Builder::etag).callSync();
    }

    @Override
    public ConnectionDiagnosticsResponse connectionDiagnostics(ConnectionDiagnosticsRequest request) {
        Validate.notBlank((String)request.getConnectionId(), (String)"connectionId must not be blank", (Object[])new Object[0]);
        return (ConnectionDiagnosticsResponse)this.clientCall(request, ConnectionDiagnosticsResponse::builder).logger(LOG, "connectionDiagnostics").serviceDetails("DatabaseMigration", "ConnectionDiagnostics", "https://docs.oracle.com/iaas/api/#/en/database-migration/20230518/Connection/ConnectionDiagnostics").method(Method.POST).requestBuilder(ConnectionDiagnosticsRequest::builder).basePath("/20230518").appendPathParam("connections").appendPathParam(request.getConnectionId()).appendPathParam("actions").appendPathParam("diagnostics").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().handleBody(DiagnosticsResult.class, ConnectionDiagnosticsResponse.Builder::diagnosticsResult).handleResponseHeaderString("opc-request-id", ConnectionDiagnosticsResponse.Builder::opcRequestId).handleResponseHeaderString("etag", ConnectionDiagnosticsResponse.Builder::etag).callSync();
    }

    @Override
    public CreateConnectionResponse createConnection(CreateConnectionRequest request) {
        Objects.requireNonNull(request.getCreateConnectionDetails(), "createConnectionDetails is required");
        return (CreateConnectionResponse)this.clientCall(request, CreateConnectionResponse::builder).logger(LOG, "createConnection").serviceDetails("DatabaseMigration", "CreateConnection", "").method(Method.POST).requestBuilder(CreateConnectionRequest::builder).basePath("/20230518").appendPathParam("connections").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(Connection.class, CreateConnectionResponse.Builder::connection).handleResponseHeaderString("opc-request-id", CreateConnectionResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateConnectionResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateConnectionResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public CreateMigrationResponse createMigration(CreateMigrationRequest request) {
        Objects.requireNonNull(request.getCreateMigrationDetails(), "createMigrationDetails is required");
        return (CreateMigrationResponse)this.clientCall(request, CreateMigrationResponse::builder).logger(LOG, "createMigration").serviceDetails("DatabaseMigration", "CreateMigration", "https://docs.oracle.com/iaas/api/#/en/database-migration/20230518/Migration/CreateMigration").method(Method.POST).requestBuilder(CreateMigrationRequest::builder).basePath("/20230518").appendPathParam("migrations").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(Migration.class, CreateMigrationResponse.Builder::migration).handleResponseHeaderString("opc-request-id", CreateMigrationResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateMigrationResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateMigrationResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public DeleteConnectionResponse deleteConnection(DeleteConnectionRequest request) {
        Validate.notBlank((String)request.getConnectionId(), (String)"connectionId must not be blank", (Object[])new Object[0]);
        return (DeleteConnectionResponse)this.clientCall(request, DeleteConnectionResponse::builder).logger(LOG, "deleteConnection").serviceDetails("DatabaseMigration", "DeleteConnection", "https://docs.oracle.com/iaas/api/#/en/database-migration/20230518/Connection/DeleteConnection").method(Method.DELETE).requestBuilder(DeleteConnectionRequest::builder).basePath("/20230518").appendPathParam("connections").appendPathParam(request.getConnectionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteConnectionResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteConnectionResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public DeleteJobResponse deleteJob(DeleteJobRequest request) {
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        return (DeleteJobResponse)this.clientCall(request, DeleteJobResponse::builder).logger(LOG, "deleteJob").serviceDetails("DatabaseMigration", "DeleteJob", "https://docs.oracle.com/iaas/api/#/en/database-migration/20230518/Job/DeleteJob").method(Method.DELETE).requestBuilder(DeleteJobRequest::builder).basePath("/20230518").appendPathParam("jobs").appendPathParam(request.getJobId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteJobResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteMigrationResponse deleteMigration(DeleteMigrationRequest request) {
        Validate.notBlank((String)request.getMigrationId(), (String)"migrationId must not be blank", (Object[])new Object[0]);
        return (DeleteMigrationResponse)this.clientCall(request, DeleteMigrationResponse::builder).logger(LOG, "deleteMigration").serviceDetails("DatabaseMigration", "DeleteMigration", "https://docs.oracle.com/iaas/api/#/en/database-migration/20230518/Migration/DeleteMigration").method(Method.DELETE).requestBuilder(DeleteMigrationRequest::builder).basePath("/20230518").appendPathParam("migrations").appendPathParam(request.getMigrationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteMigrationResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteMigrationResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public EvaluateMigrationResponse evaluateMigration(EvaluateMigrationRequest request) {
        Validate.notBlank((String)request.getMigrationId(), (String)"migrationId must not be blank", (Object[])new Object[0]);
        return (EvaluateMigrationResponse)this.clientCall(request, EvaluateMigrationResponse::builder).logger(LOG, "evaluateMigration").serviceDetails("DatabaseMigration", "EvaluateMigration", "https://docs.oracle.com/iaas/api/#/en/database-migration/20230518/Job/EvaluateMigration").method(Method.POST).requestBuilder(EvaluateMigrationRequest::builder).basePath("/20230518").appendPathParam("migrations").appendPathParam(request.getMigrationId()).appendPathParam("actions").appendPathParam("validate").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(Job.class, EvaluateMigrationResponse.Builder::job).handleResponseHeaderString("opc-request-id", EvaluateMigrationResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", EvaluateMigrationResponse.Builder::opcWorkRequestId).handleResponseHeaderString("etag", EvaluateMigrationResponse.Builder::etag).callSync();
    }

    @Override
    public GetAdvisorReportResponse getAdvisorReport(GetAdvisorReportRequest request) {
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        return (GetAdvisorReportResponse)this.clientCall(request, GetAdvisorReportResponse::builder).logger(LOG, "getAdvisorReport").serviceDetails("DatabaseMigration", "GetAdvisorReport", "https://docs.oracle.com/iaas/api/#/en/database-migration/20230518/Job/GetAdvisorReport").method(Method.GET).requestBuilder(GetAdvisorReportRequest::builder).basePath("/20230518").appendPathParam("jobs").appendPathParam(request.getJobId()).appendPathParam("advisorReport").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(AdvisorReport.class, GetAdvisorReportResponse.Builder::advisorReport).handleResponseHeaderString("opc-request-id", GetAdvisorReportResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetAdvisorReportResponse.Builder::etag).callSync();
    }

    @Override
    public GetConnectionResponse getConnection(GetConnectionRequest request) {
        Validate.notBlank((String)request.getConnectionId(), (String)"connectionId must not be blank", (Object[])new Object[0]);
        return (GetConnectionResponse)this.clientCall(request, GetConnectionResponse::builder).logger(LOG, "getConnection").serviceDetails("DatabaseMigration", "GetConnection", "https://docs.oracle.com/iaas/api/#/en/database-migration/20230518/Connection/GetConnection").method(Method.GET).requestBuilder(GetConnectionRequest::builder).basePath("/20230518").appendPathParam("connections").appendPathParam(request.getConnectionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(Connection.class, GetConnectionResponse.Builder::connection).handleResponseHeaderString("opc-request-id", GetConnectionResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetConnectionResponse.Builder::etag).callSync();
    }

    @Override
    public GetJobResponse getJob(GetJobRequest request) {
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        return (GetJobResponse)this.clientCall(request, GetJobResponse::builder).logger(LOG, "getJob").serviceDetails("DatabaseMigration", "GetJob", "https://docs.oracle.com/iaas/api/#/en/database-migration/20230518/Job/GetJob").method(Method.GET).requestBuilder(GetJobRequest::builder).basePath("/20230518").appendPathParam("jobs").appendPathParam(request.getJobId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(Job.class, GetJobResponse.Builder::job).handleResponseHeaderString("opc-request-id", GetJobResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetJobResponse.Builder::etag).callSync();
    }

    @Override
    public GetJobOutputContentResponse getJobOutputContent(GetJobOutputContentRequest request) {
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        return (GetJobOutputContentResponse)this.clientCall(request, GetJobOutputContentResponse::builder).logger(LOG, "getJobOutputContent").serviceDetails("DatabaseMigration", "GetJobOutputContent", "https://docs.oracle.com/iaas/api/#/en/database-migration/20230518/Job/GetJobOutputContent").method(Method.GET).requestBuilder(GetJobOutputContentRequest::builder).basePath("/20230518").appendPathParam("jobs").appendPathParam(request.getJobId()).appendPathParam("output").appendPathParam("content").accept(new String[]{"application/x-yaml"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(InputStream.class, GetJobOutputContentResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", GetJobOutputContentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetMigrationResponse getMigration(GetMigrationRequest request) {
        Validate.notBlank((String)request.getMigrationId(), (String)"migrationId must not be blank", (Object[])new Object[0]);
        return (GetMigrationResponse)this.clientCall(request, GetMigrationResponse::builder).logger(LOG, "getMigration").serviceDetails("DatabaseMigration", "GetMigration", "https://docs.oracle.com/iaas/api/#/en/database-migration/20230518/Migration/GetMigration").method(Method.GET).requestBuilder(GetMigrationRequest::builder).basePath("/20230518").appendPathParam("migrations").appendPathParam(request.getMigrationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().handleBody(Migration.class, GetMigrationResponse.Builder::migration).handleResponseHeaderString("opc-request-id", GetMigrationResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetMigrationResponse.Builder::etag).callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("DatabaseMigration", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/database-migration/20230518/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20230518").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListConnectionsResponse listConnections(ListConnectionsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListConnectionsResponse)this.clientCall(request, ListConnectionsResponse::builder).logger(LOG, "listConnections").serviceDetails("DatabaseMigration", "ListConnections", "https://docs.oracle.com/iaas/api/#/en/database-migration/20230518/ConnectionSummary/ListConnections").method(Method.GET).requestBuilder(ListConnectionsRequest::builder).basePath("/20230518").appendPathParam("connections").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendListQueryParam("technologyType", request.getTechnologyType(), CollectionFormatType.Multi).appendListQueryParam("connectionType", request.getConnectionType(), CollectionFormatType.Multi).appendQueryParam("sourceConnectionId", (Object)request.getSourceConnectionId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ConnectionCollection.class, ListConnectionsResponse.Builder::connectionCollection).handleResponseHeaderString("opc-request-id", ListConnectionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListConnectionsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListExcludedObjectsResponse listExcludedObjects(ListExcludedObjectsRequest request) {
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        return (ListExcludedObjectsResponse)this.clientCall(request, ListExcludedObjectsResponse::builder).logger(LOG, "listExcludedObjects").serviceDetails("DatabaseMigration", "ListExcludedObjects", "https://docs.oracle.com/iaas/api/#/en/database-migration/20230518/ExcludedObjectSummary/ListExcludedObjects").method(Method.GET).requestBuilder(ListExcludedObjectsRequest::builder).basePath("/20230518").appendPathParam("jobs").appendPathParam(request.getJobId()).appendPathParam("excludedObjects").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("type", (Object)request.getType()).appendQueryParam("owner", (Object)request.getOwner()).appendQueryParam("object", (Object)request.getObject()).appendQueryParam("ownerContains", (Object)request.getOwnerContains()).appendQueryParam("objectContains", (Object)request.getObjectContains()).appendEnumQueryParam("reasonCategory", (BmcEnum)request.getReasonCategory()).appendQueryParam("sourceRule", (Object)request.getSourceRule()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ExcludedObjectSummaryCollection.class, ListExcludedObjectsResponse.Builder::excludedObjectSummaryCollection).handleResponseHeaderString("opc-request-id", ListExcludedObjectsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListExcludedObjectsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListJobOutputsResponse listJobOutputs(ListJobOutputsRequest request) {
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        return (ListJobOutputsResponse)this.clientCall(request, ListJobOutputsResponse::builder).logger(LOG, "listJobOutputs").serviceDetails("DatabaseMigration", "ListJobOutputs", "https://docs.oracle.com/iaas/api/#/en/database-migration/20230518/JobOutputSummary/ListJobOutputs").method(Method.GET).requestBuilder(ListJobOutputsRequest::builder).basePath("/20230518").appendPathParam("jobs").appendPathParam(request.getJobId()).appendPathParam("output").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(JobOutputSummaryCollection.class, ListJobOutputsResponse.Builder::jobOutputSummaryCollection).handleResponseHeaderString("opc-request-id", ListJobOutputsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListJobOutputsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListJobsResponse listJobs(ListJobsRequest request) {
        Objects.requireNonNull(request.getMigrationId(), "migrationId is required");
        return (ListJobsResponse)this.clientCall(request, ListJobsResponse::builder).logger(LOG, "listJobs").serviceDetails("DatabaseMigration", "ListJobs", "https://docs.oracle.com/iaas/api/#/en/database-migration/20230518/JobSummary/ListJobs").method(Method.GET).requestBuilder(ListJobsRequest::builder).basePath("/20230518").appendPathParam("jobs").appendQueryParam("migrationId", (Object)request.getMigrationId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(JobCollection.class, ListJobsResponse.Builder::jobCollection).handleResponseHeaderString("opc-request-id", ListJobsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListJobsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListMigrationObjectTypesResponse listMigrationObjectTypes(ListMigrationObjectTypesRequest request) {
        Objects.requireNonNull(request.getConnectionType(), "connectionType is required");
        return (ListMigrationObjectTypesResponse)this.clientCall(request, ListMigrationObjectTypesResponse::builder).logger(LOG, "listMigrationObjectTypes").serviceDetails("DatabaseMigration", "ListMigrationObjectTypes", "https://docs.oracle.com/iaas/api/#/en/database-migration/20230518/MigrationObjectTypeSummary/ListMigrationObjectTypes").method(Method.GET).requestBuilder(ListMigrationObjectTypesRequest::builder).basePath("/20230518").appendPathParam("migrationObjectTypes").appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("connectionType", (BmcEnum)request.getConnectionType()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(MigrationObjectTypeSummaryCollection.class, ListMigrationObjectTypesResponse.Builder::migrationObjectTypeSummaryCollection).handleResponseHeaderString("opc-request-id", ListMigrationObjectTypesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListMigrationObjectTypesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListMigrationObjectsResponse listMigrationObjects(ListMigrationObjectsRequest request) {
        Validate.notBlank((String)request.getMigrationId(), (String)"migrationId must not be blank", (Object[])new Object[0]);
        return (ListMigrationObjectsResponse)this.clientCall(request, ListMigrationObjectsResponse::builder).logger(LOG, "listMigrationObjects").serviceDetails("DatabaseMigration", "ListMigrationObjects", "https://docs.oracle.com/iaas/api/#/en/database-migration/20230518/MigrationObjectCollection/ListMigrationObjects").method(Method.GET).requestBuilder(ListMigrationObjectsRequest::builder).basePath("/20230518").appendPathParam("migrations").appendPathParam(request.getMigrationId()).appendPathParam("migrationObjects").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().handleBody(MigrationObjectCollection.class, ListMigrationObjectsResponse.Builder::migrationObjectCollection).handleResponseHeaderString("opc-request-id", ListMigrationObjectsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListMigrationObjectsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListMigrationsResponse listMigrations(ListMigrationsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListMigrationsResponse)this.clientCall(request, ListMigrationsResponse::builder).logger(LOG, "listMigrations").serviceDetails("DatabaseMigration", "ListMigrations", "https://docs.oracle.com/iaas/api/#/en/database-migration/20230518/MigrationSummary/ListMigrations").method(Method.GET).requestBuilder(ListMigrationsRequest::builder).basePath("/20230518").appendPathParam("migrations").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("lifecycleDetails", (BmcEnum)request.getLifecycleDetails()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(MigrationCollection.class, ListMigrationsResponse.Builder::migrationCollection).handleResponseHeaderString("opc-request-id", ListMigrationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListMigrationsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("DatabaseMigration", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/database-migration/20230518/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20230518").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("DatabaseMigration", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/database-migration/20230518/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20230518").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("DatabaseMigration", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/database-migration/20230518/WorkRequestSummary/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20230518").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestCollection.class, ListWorkRequestsResponse.Builder::workRequestCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public RemoveMigrationObjectsResponse removeMigrationObjects(RemoveMigrationObjectsRequest request) {
        Validate.notBlank((String)request.getMigrationId(), (String)"migrationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemoveMigrationObjectsDetails(), "removeMigrationObjectsDetails is required");
        return (RemoveMigrationObjectsResponse)this.clientCall(request, RemoveMigrationObjectsResponse::builder).logger(LOG, "removeMigrationObjects").serviceDetails("DatabaseMigration", "RemoveMigrationObjects", "https://docs.oracle.com/iaas/api/#/en/database-migration/20230518/Migration/RemoveMigrationObjects").method(Method.POST).requestBuilder(RemoveMigrationObjectsRequest::builder).basePath("/20230518").appendPathParam("migrations").appendPathParam(request.getMigrationId()).appendPathParam("actions").appendPathParam("removeMigrationObjects").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", RemoveMigrationObjectsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ResumeJobResponse resumeJob(ResumeJobRequest request) {
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        return (ResumeJobResponse)this.clientCall(request, ResumeJobResponse::builder).logger(LOG, "resumeJob").serviceDetails("DatabaseMigration", "ResumeJob", "https://docs.oracle.com/iaas/api/#/en/database-migration/20230518/Job/ResumeJob").method(Method.POST).requestBuilder(ResumeJobRequest::builder).basePath("/20230518").appendPathParam("jobs").appendPathParam(request.getJobId()).appendPathParam("actions").appendPathParam("resume").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(Job.class, ResumeJobResponse.Builder::job).handleResponseHeaderString("opc-request-id", ResumeJobResponse.Builder::opcRequestId).handleResponseHeaderString("etag", ResumeJobResponse.Builder::etag).callSync();
    }

    @Override
    public RetrieveSupportedPhasesResponse retrieveSupportedPhases(RetrieveSupportedPhasesRequest request) {
        Validate.notBlank((String)request.getMigrationId(), (String)"migrationId must not be blank", (Object[])new Object[0]);
        return (RetrieveSupportedPhasesResponse)this.clientCall(request, RetrieveSupportedPhasesResponse::builder).logger(LOG, "retrieveSupportedPhases").serviceDetails("DatabaseMigration", "RetrieveSupportedPhases", "https://docs.oracle.com/iaas/api/#/en/database-migration/20230518/Migration/RetrieveSupportedPhases").method(Method.POST).requestBuilder(RetrieveSupportedPhasesRequest::builder).basePath("/20230518").appendPathParam("migrations").appendPathParam(request.getMigrationId()).appendPathParam("actions").appendPathParam("getSupportedPhases").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(MigrationPhaseCollection.class, RetrieveSupportedPhasesResponse.Builder::migrationPhaseCollection).handleResponseHeaderString("opc-request-id", RetrieveSupportedPhasesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public StartMigrationResponse startMigration(StartMigrationRequest request) {
        Validate.notBlank((String)request.getMigrationId(), (String)"migrationId must not be blank", (Object[])new Object[0]);
        return (StartMigrationResponse)this.clientCall(request, StartMigrationResponse::builder).logger(LOG, "startMigration").serviceDetails("DatabaseMigration", "StartMigration", "https://docs.oracle.com/iaas/api/#/en/database-migration/20230518/Job/StartMigration").method(Method.POST).requestBuilder(StartMigrationRequest::builder).basePath("/20230518").appendPathParam("migrations").appendPathParam(request.getMigrationId()).appendPathParam("actions").appendPathParam("start").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(Job.class, StartMigrationResponse.Builder::job).handleResponseHeaderString("opc-request-id", StartMigrationResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", StartMigrationResponse.Builder::opcWorkRequestId).handleResponseHeaderString("etag", StartMigrationResponse.Builder::etag).callSync();
    }

    @Override
    public UpdateConnectionResponse updateConnection(UpdateConnectionRequest request) {
        Validate.notBlank((String)request.getConnectionId(), (String)"connectionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateConnectionDetails(), "updateConnectionDetails is required");
        return (UpdateConnectionResponse)this.clientCall(request, UpdateConnectionResponse::builder).logger(LOG, "updateConnection").serviceDetails("DatabaseMigration", "UpdateConnection", "https://docs.oracle.com/iaas/api/#/en/database-migration/20230518/Connection/UpdateConnection").method(Method.PUT).requestBuilder(UpdateConnectionRequest::builder).basePath("/20230518").appendPathParam("connections").appendPathParam(request.getConnectionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", UpdateConnectionResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateConnectionResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public UpdateJobResponse updateJob(UpdateJobRequest request) {
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateJobDetails(), "updateJobDetails is required");
        return (UpdateJobResponse)this.clientCall(request, UpdateJobResponse::builder).logger(LOG, "updateJob").serviceDetails("DatabaseMigration", "UpdateJob", "https://docs.oracle.com/iaas/api/#/en/database-migration/20230518/Job/UpdateJob").method(Method.PUT).requestBuilder(UpdateJobRequest::builder).basePath("/20230518").appendPathParam("jobs").appendPathParam(request.getJobId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleBody(Job.class, UpdateJobResponse.Builder::job).handleResponseHeaderString("opc-request-id", UpdateJobResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateJobResponse.Builder::etag).callSync();
    }

    @Override
    public UpdateMigrationResponse updateMigration(UpdateMigrationRequest request) {
        Validate.notBlank((String)request.getMigrationId(), (String)"migrationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateMigrationDetails(), "updateMigrationDetails is required");
        return (UpdateMigrationResponse)this.clientCall(request, UpdateMigrationResponse::builder).logger(LOG, "updateMigration").serviceDetails("DatabaseMigration", "UpdateMigration", "https://docs.oracle.com/iaas/api/#/en/database-migration/20230518/Migration/UpdateMigration").method(Method.PUT).requestBuilder(UpdateMigrationRequest::builder).basePath("/20230518").appendPathParam("migrations").appendPathParam(request.getMigrationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", UpdateMigrationResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateMigrationResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public DatabaseMigrationWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public DatabaseMigrationPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public DatabaseMigrationClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)DatabaseMigrationClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DatabaseMigrationClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(DatabaseMigrationClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DatabaseMigrationClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)DatabaseMigrationClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DatabaseMigrationClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)DatabaseMigrationClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DatabaseMigrationClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)DatabaseMigrationClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DatabaseMigrationClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)DatabaseMigrationClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DatabaseMigrationClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DatabaseMigrationClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DatabaseMigrationClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DatabaseMigrationClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DatabaseMigrationClient> {
        private boolean isStreamWarningEnabled = true;
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "databasemigration";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"databasemigration");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder isStreamWarningEnabled(boolean isStreamWarningEnabled) {
            this.isStreamWarningEnabled = isStreamWarningEnabled;
            return this;
        }

        public DatabaseMigrationClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new DatabaseMigrationClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService, this.isStreamWarningEnabled);
        }
    }
}

