/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemigration;

import com.oracle.bmc.databasemigration.DatabaseMigration;
import com.oracle.bmc.databasemigration.model.Connection;
import com.oracle.bmc.databasemigration.model.JobLifecycleStates;
import com.oracle.bmc.databasemigration.model.MigrationLifecycleStates;
import com.oracle.bmc.databasemigration.requests.GetConnectionRequest;
import com.oracle.bmc.databasemigration.requests.GetJobRequest;
import com.oracle.bmc.databasemigration.requests.GetMigrationRequest;
import com.oracle.bmc.databasemigration.requests.GetWorkRequestRequest;
import com.oracle.bmc.databasemigration.responses.GetConnectionResponse;
import com.oracle.bmc.databasemigration.responses.GetJobResponse;
import com.oracle.bmc.databasemigration.responses.GetMigrationResponse;
import com.oracle.bmc.databasemigration.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class DatabaseMigrationWaiters {
    private final ExecutorService executorService;
    private final DatabaseMigration client;

    public DatabaseMigrationWaiters(ExecutorService executorService, DatabaseMigration client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetConnectionRequest, GetConnectionResponse> forConnection(GetConnectionRequest request, Connection.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forConnection(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetConnectionRequest, GetConnectionResponse> forConnection(GetConnectionRequest request, Connection.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forConnection(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetConnectionRequest, GetConnectionResponse> forConnection(GetConnectionRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Connection.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forConnection(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetConnectionRequest, GetConnectionResponse> forConnection(BmcGenericWaiter waiter, GetConnectionRequest request, Connection.LifecycleState ... targetStates) {
        final HashSet<Connection.LifecycleState> targetStatesSet = new HashSet<Connection.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetConnectionRequest, GetConnectionResponse>(){

            @Override
            public GetConnectionResponse apply(GetConnectionRequest request) {
                return DatabaseMigrationWaiters.this.client.getConnection(request);
            }
        }, (Predicate)new Predicate<GetConnectionResponse>(){

            @Override
            public boolean test(GetConnectionResponse response) {
                return targetStatesSet.contains((Object)response.getConnection().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Connection.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetJobRequest, GetJobResponse> forJob(GetJobRequest request, JobLifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forJob(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetJobRequest, GetJobResponse> forJob(GetJobRequest request, JobLifecycleStates targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forJob(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetJobRequest, GetJobResponse> forJob(GetJobRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, JobLifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forJob(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetJobRequest, GetJobResponse> forJob(BmcGenericWaiter waiter, GetJobRequest request, JobLifecycleStates ... targetStates) {
        final HashSet<JobLifecycleStates> targetStatesSet = new HashSet<JobLifecycleStates>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetJobRequest, GetJobResponse>(){

            @Override
            public GetJobResponse apply(GetJobRequest request) {
                return DatabaseMigrationWaiters.this.client.getJob(request);
            }
        }, (Predicate)new Predicate<GetJobResponse>(){

            @Override
            public boolean test(GetJobResponse response) {
                return targetStatesSet.contains((Object)response.getJob().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)JobLifecycleStates.Terminated)), (Object)request);
    }

    public Waiter<GetMigrationRequest, GetMigrationResponse> forMigration(GetMigrationRequest request, MigrationLifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forMigration(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetMigrationRequest, GetMigrationResponse> forMigration(GetMigrationRequest request, MigrationLifecycleStates targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forMigration(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetMigrationRequest, GetMigrationResponse> forMigration(GetMigrationRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, MigrationLifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forMigration(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetMigrationRequest, GetMigrationResponse> forMigration(BmcGenericWaiter waiter, GetMigrationRequest request, MigrationLifecycleStates ... targetStates) {
        final HashSet<MigrationLifecycleStates> targetStatesSet = new HashSet<MigrationLifecycleStates>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetMigrationRequest, GetMigrationResponse>(){

            @Override
            public GetMigrationResponse apply(GetMigrationRequest request) {
                return DatabaseMigrationWaiters.this.client.getMigration(request);
            }
        }, (Predicate)new Predicate<GetMigrationResponse>(){

            @Override
            public boolean test(GetMigrationResponse response) {
                return targetStatesSet.contains((Object)response.getMigration().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)MigrationLifecycleStates.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return DatabaseMigrationWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

