/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemigration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemigration.model.CreateGoldenGateHubDetails;
import com.oracle.bmc.databasemigration.model.CreateMigrationDetails;
import com.oracle.bmc.databasemigration.model.CreateMySqlAdvisorSettings;
import com.oracle.bmc.databasemigration.model.CreateMySqlDataTransferMediumDetails;
import com.oracle.bmc.databasemigration.model.CreateMySqlGgsDeploymentDetails;
import com.oracle.bmc.databasemigration.model.CreateMySqlInitialLoadSettings;
import com.oracle.bmc.databasemigration.model.MigrationTypes;
import com.oracle.bmc.databasemigration.model.MySqlDatabaseObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="databaseCombination")
@JsonFilter(value="explicitlySetFilter")
public final class CreateMySqlMigrationDetails
extends CreateMigrationDetails {
    @JsonProperty(value="dataTransferMediumDetails")
    private final CreateMySqlDataTransferMediumDetails dataTransferMediumDetails;
    @JsonProperty(value="initialLoadSettings")
    private final CreateMySqlInitialLoadSettings initialLoadSettings;
    @JsonProperty(value="advisorSettings")
    private final CreateMySqlAdvisorSettings advisorSettings;
    @JsonProperty(value="excludeObjects")
    private final List<MySqlDatabaseObject> excludeObjects;
    @JsonProperty(value="includeObjects")
    private final List<MySqlDatabaseObject> includeObjects;
    @JsonProperty(value="bulkIncludeExcludeData")
    private final String bulkIncludeExcludeData;
    @JsonProperty(value="hubDetails")
    private final CreateGoldenGateHubDetails hubDetails;
    @JsonProperty(value="ggsDetails")
    private final CreateMySqlGgsDeploymentDetails ggsDetails;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CreateMySqlMigrationDetails(String description, String compartmentId, MigrationTypes type, String displayName, String sourceDatabaseConnectionId, String targetDatabaseConnectionId, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, CreateMySqlDataTransferMediumDetails dataTransferMediumDetails, CreateMySqlInitialLoadSettings initialLoadSettings, CreateMySqlAdvisorSettings advisorSettings, List<MySqlDatabaseObject> excludeObjects, List<MySqlDatabaseObject> includeObjects, String bulkIncludeExcludeData, CreateGoldenGateHubDetails hubDetails, CreateMySqlGgsDeploymentDetails ggsDetails) {
        super(description, compartmentId, type, displayName, sourceDatabaseConnectionId, targetDatabaseConnectionId, freeformTags, definedTags);
        this.dataTransferMediumDetails = dataTransferMediumDetails;
        this.initialLoadSettings = initialLoadSettings;
        this.advisorSettings = advisorSettings;
        this.excludeObjects = excludeObjects;
        this.includeObjects = includeObjects;
        this.bulkIncludeExcludeData = bulkIncludeExcludeData;
        this.hubDetails = hubDetails;
        this.ggsDetails = ggsDetails;
    }

    public CreateMySqlDataTransferMediumDetails getDataTransferMediumDetails() {
        return this.dataTransferMediumDetails;
    }

    public CreateMySqlInitialLoadSettings getInitialLoadSettings() {
        return this.initialLoadSettings;
    }

    public CreateMySqlAdvisorSettings getAdvisorSettings() {
        return this.advisorSettings;
    }

    public List<MySqlDatabaseObject> getExcludeObjects() {
        return this.excludeObjects;
    }

    public List<MySqlDatabaseObject> getIncludeObjects() {
        return this.includeObjects;
    }

    public String getBulkIncludeExcludeData() {
        return this.bulkIncludeExcludeData;
    }

    public CreateGoldenGateHubDetails getHubDetails() {
        return this.hubDetails;
    }

    public CreateMySqlGgsDeploymentDetails getGgsDetails() {
        return this.ggsDetails;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateMySqlMigrationDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", dataTransferMediumDetails=").append(String.valueOf((Object)this.dataTransferMediumDetails));
        sb.append(", initialLoadSettings=").append(String.valueOf((Object)this.initialLoadSettings));
        sb.append(", advisorSettings=").append(String.valueOf((Object)this.advisorSettings));
        sb.append(", excludeObjects=").append(String.valueOf(this.excludeObjects));
        sb.append(", includeObjects=").append(String.valueOf(this.includeObjects));
        sb.append(", bulkIncludeExcludeData=").append(String.valueOf(this.bulkIncludeExcludeData));
        sb.append(", hubDetails=").append(String.valueOf((Object)this.hubDetails));
        sb.append(", ggsDetails=").append(String.valueOf((Object)this.ggsDetails));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateMySqlMigrationDetails)) {
            return false;
        }
        CreateMySqlMigrationDetails other = (CreateMySqlMigrationDetails)((Object)o);
        return Objects.equals((Object)this.dataTransferMediumDetails, (Object)other.dataTransferMediumDetails) && Objects.equals((Object)this.initialLoadSettings, (Object)other.initialLoadSettings) && Objects.equals((Object)this.advisorSettings, (Object)other.advisorSettings) && Objects.equals(this.excludeObjects, other.excludeObjects) && Objects.equals(this.includeObjects, other.includeObjects) && Objects.equals(this.bulkIncludeExcludeData, other.bulkIncludeExcludeData) && Objects.equals((Object)this.hubDetails, (Object)other.hubDetails) && Objects.equals((Object)this.ggsDetails, (Object)other.ggsDetails) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dataTransferMediumDetails == null ? 43 : this.dataTransferMediumDetails.hashCode());
        result = result * 59 + (this.initialLoadSettings == null ? 43 : this.initialLoadSettings.hashCode());
        result = result * 59 + (this.advisorSettings == null ? 43 : this.advisorSettings.hashCode());
        result = result * 59 + (this.excludeObjects == null ? 43 : this.excludeObjects.hashCode());
        result = result * 59 + (this.includeObjects == null ? 43 : this.includeObjects.hashCode());
        result = result * 59 + (this.bulkIncludeExcludeData == null ? 43 : this.bulkIncludeExcludeData.hashCode());
        result = result * 59 + (this.hubDetails == null ? 43 : this.hubDetails.hashCode());
        result = result * 59 + (this.ggsDetails == null ? 43 : this.ggsDetails.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="type")
        private MigrationTypes type;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="sourceDatabaseConnectionId")
        private String sourceDatabaseConnectionId;
        @JsonProperty(value="targetDatabaseConnectionId")
        private String targetDatabaseConnectionId;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="dataTransferMediumDetails")
        private CreateMySqlDataTransferMediumDetails dataTransferMediumDetails;
        @JsonProperty(value="initialLoadSettings")
        private CreateMySqlInitialLoadSettings initialLoadSettings;
        @JsonProperty(value="advisorSettings")
        private CreateMySqlAdvisorSettings advisorSettings;
        @JsonProperty(value="excludeObjects")
        private List<MySqlDatabaseObject> excludeObjects;
        @JsonProperty(value="includeObjects")
        private List<MySqlDatabaseObject> includeObjects;
        @JsonProperty(value="bulkIncludeExcludeData")
        private String bulkIncludeExcludeData;
        @JsonProperty(value="hubDetails")
        private CreateGoldenGateHubDetails hubDetails;
        @JsonProperty(value="ggsDetails")
        private CreateMySqlGgsDeploymentDetails ggsDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder type(MigrationTypes type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder sourceDatabaseConnectionId(String sourceDatabaseConnectionId) {
            this.sourceDatabaseConnectionId = sourceDatabaseConnectionId;
            this.__explicitlySet__.add("sourceDatabaseConnectionId");
            return this;
        }

        public Builder targetDatabaseConnectionId(String targetDatabaseConnectionId) {
            this.targetDatabaseConnectionId = targetDatabaseConnectionId;
            this.__explicitlySet__.add("targetDatabaseConnectionId");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder dataTransferMediumDetails(CreateMySqlDataTransferMediumDetails dataTransferMediumDetails) {
            this.dataTransferMediumDetails = dataTransferMediumDetails;
            this.__explicitlySet__.add("dataTransferMediumDetails");
            return this;
        }

        public Builder initialLoadSettings(CreateMySqlInitialLoadSettings initialLoadSettings) {
            this.initialLoadSettings = initialLoadSettings;
            this.__explicitlySet__.add("initialLoadSettings");
            return this;
        }

        public Builder advisorSettings(CreateMySqlAdvisorSettings advisorSettings) {
            this.advisorSettings = advisorSettings;
            this.__explicitlySet__.add("advisorSettings");
            return this;
        }

        public Builder excludeObjects(List<MySqlDatabaseObject> excludeObjects) {
            this.excludeObjects = excludeObjects;
            this.__explicitlySet__.add("excludeObjects");
            return this;
        }

        public Builder includeObjects(List<MySqlDatabaseObject> includeObjects) {
            this.includeObjects = includeObjects;
            this.__explicitlySet__.add("includeObjects");
            return this;
        }

        public Builder bulkIncludeExcludeData(String bulkIncludeExcludeData) {
            this.bulkIncludeExcludeData = bulkIncludeExcludeData;
            this.__explicitlySet__.add("bulkIncludeExcludeData");
            return this;
        }

        public Builder hubDetails(CreateGoldenGateHubDetails hubDetails) {
            this.hubDetails = hubDetails;
            this.__explicitlySet__.add("hubDetails");
            return this;
        }

        public Builder ggsDetails(CreateMySqlGgsDeploymentDetails ggsDetails) {
            this.ggsDetails = ggsDetails;
            this.__explicitlySet__.add("ggsDetails");
            return this;
        }

        public CreateMySqlMigrationDetails build() {
            CreateMySqlMigrationDetails model = new CreateMySqlMigrationDetails(this.description, this.compartmentId, this.type, this.displayName, this.sourceDatabaseConnectionId, this.targetDatabaseConnectionId, this.freeformTags, this.definedTags, this.dataTransferMediumDetails, this.initialLoadSettings, this.advisorSettings, this.excludeObjects, this.includeObjects, this.bulkIncludeExcludeData, this.hubDetails, this.ggsDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateMySqlMigrationDetails model) {
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("sourceDatabaseConnectionId")) {
                this.sourceDatabaseConnectionId(model.getSourceDatabaseConnectionId());
            }
            if (model.wasPropertyExplicitlySet("targetDatabaseConnectionId")) {
                this.targetDatabaseConnectionId(model.getTargetDatabaseConnectionId());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("dataTransferMediumDetails")) {
                this.dataTransferMediumDetails(model.getDataTransferMediumDetails());
            }
            if (model.wasPropertyExplicitlySet("initialLoadSettings")) {
                this.initialLoadSettings(model.getInitialLoadSettings());
            }
            if (model.wasPropertyExplicitlySet("advisorSettings")) {
                this.advisorSettings(model.getAdvisorSettings());
            }
            if (model.wasPropertyExplicitlySet("excludeObjects")) {
                this.excludeObjects(model.getExcludeObjects());
            }
            if (model.wasPropertyExplicitlySet("includeObjects")) {
                this.includeObjects(model.getIncludeObjects());
            }
            if (model.wasPropertyExplicitlySet("bulkIncludeExcludeData")) {
                this.bulkIncludeExcludeData(model.getBulkIncludeExcludeData());
            }
            if (model.wasPropertyExplicitlySet("hubDetails")) {
                this.hubDetails(model.getHubDetails());
            }
            if (model.wasPropertyExplicitlySet("ggsDetails")) {
                this.ggsDetails(model.getGgsDetails());
            }
            return this;
        }
    }
}

