/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemigration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemigration.model.CreateObjectStoreBucket;
import com.oracle.bmc.databasemigration.model.CreateOracleDataTransferMediumDetails;
import com.oracle.bmc.databasemigration.model.HostDumpTransferDetails;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class CreateOracleNfsDataTransferMediumDetails
extends CreateOracleDataTransferMediumDetails {
    @JsonProperty(value="objectStorageBucket")
    private final CreateObjectStoreBucket objectStorageBucket;
    @JsonProperty(value="source")
    private final HostDumpTransferDetails source;
    @JsonProperty(value="target")
    private final HostDumpTransferDetails target;
    @JsonProperty(value="sharedStorageMountTargetId")
    private final String sharedStorageMountTargetId;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CreateOracleNfsDataTransferMediumDetails(CreateObjectStoreBucket objectStorageBucket, HostDumpTransferDetails source, HostDumpTransferDetails target, String sharedStorageMountTargetId) {
        this.objectStorageBucket = objectStorageBucket;
        this.source = source;
        this.target = target;
        this.sharedStorageMountTargetId = sharedStorageMountTargetId;
    }

    public CreateObjectStoreBucket getObjectStorageBucket() {
        return this.objectStorageBucket;
    }

    public HostDumpTransferDetails getSource() {
        return this.source;
    }

    public HostDumpTransferDetails getTarget() {
        return this.target;
    }

    public String getSharedStorageMountTargetId() {
        return this.sharedStorageMountTargetId;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateOracleNfsDataTransferMediumDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", objectStorageBucket=").append(String.valueOf((Object)this.objectStorageBucket));
        sb.append(", source=").append(String.valueOf((Object)this.source));
        sb.append(", target=").append(String.valueOf((Object)this.target));
        sb.append(", sharedStorageMountTargetId=").append(String.valueOf(this.sharedStorageMountTargetId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateOracleNfsDataTransferMediumDetails)) {
            return false;
        }
        CreateOracleNfsDataTransferMediumDetails other = (CreateOracleNfsDataTransferMediumDetails)((Object)o);
        return Objects.equals((Object)this.objectStorageBucket, (Object)other.objectStorageBucket) && Objects.equals((Object)this.source, (Object)other.source) && Objects.equals((Object)this.target, (Object)other.target) && Objects.equals(this.sharedStorageMountTargetId, other.sharedStorageMountTargetId) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.objectStorageBucket == null ? 43 : this.objectStorageBucket.hashCode());
        result = result * 59 + (this.source == null ? 43 : this.source.hashCode());
        result = result * 59 + (this.target == null ? 43 : this.target.hashCode());
        result = result * 59 + (this.sharedStorageMountTargetId == null ? 43 : this.sharedStorageMountTargetId.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="objectStorageBucket")
        private CreateObjectStoreBucket objectStorageBucket;
        @JsonProperty(value="source")
        private HostDumpTransferDetails source;
        @JsonProperty(value="target")
        private HostDumpTransferDetails target;
        @JsonProperty(value="sharedStorageMountTargetId")
        private String sharedStorageMountTargetId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder objectStorageBucket(CreateObjectStoreBucket objectStorageBucket) {
            this.objectStorageBucket = objectStorageBucket;
            this.__explicitlySet__.add("objectStorageBucket");
            return this;
        }

        public Builder source(HostDumpTransferDetails source) {
            this.source = source;
            this.__explicitlySet__.add("source");
            return this;
        }

        public Builder target(HostDumpTransferDetails target) {
            this.target = target;
            this.__explicitlySet__.add("target");
            return this;
        }

        public Builder sharedStorageMountTargetId(String sharedStorageMountTargetId) {
            this.sharedStorageMountTargetId = sharedStorageMountTargetId;
            this.__explicitlySet__.add("sharedStorageMountTargetId");
            return this;
        }

        public CreateOracleNfsDataTransferMediumDetails build() {
            CreateOracleNfsDataTransferMediumDetails model = new CreateOracleNfsDataTransferMediumDetails(this.objectStorageBucket, this.source, this.target, this.sharedStorageMountTargetId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateOracleNfsDataTransferMediumDetails model) {
            if (model.wasPropertyExplicitlySet("objectStorageBucket")) {
                this.objectStorageBucket(model.getObjectStorageBucket());
            }
            if (model.wasPropertyExplicitlySet("source")) {
                this.source(model.getSource());
            }
            if (model.wasPropertyExplicitlySet("target")) {
                this.target(model.getTarget());
            }
            if (model.wasPropertyExplicitlySet("sharedStorageMountTargetId")) {
                this.sharedStorageMountTargetId(model.getSharedStorageMountTargetId());
            }
            return this;
        }
    }
}

